/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.scriptlets;

import com.ez.report.generation.common.internal.Messages;
import com.ez.report.generation.common.model.HeadingBean;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRScriptletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadingsScriptletFactory {
    private static final Logger L = LoggerFactory.getLogger(HeadingsScriptletFactory.class);
    public static final String VARIABLE_NAME_PAGE_NUMBER = "PAGE_NUMBER";
    private static final String HEADINGS_COLLECTION_VARIABLE_NAME = "HeadingsCollection";
    int groupNumber = 0;
    JRDefaultScriptlet scriptlet;

    public HeadingsScriptletFactory(JRDefaultScriptlet headingsScriptlet) {
        this.setScriptlet(headingsScriptlet);
        L.trace("HeadingsScriptletFactory constructor");
    }

    public Boolean addHeading(String fieldName) throws JRScriptletException {
        return this.addHeading(fieldName, null, null);
    }

    public Boolean addHeading(String fieldName, String groupCountName) throws JRScriptletException {
        return this.addHeading(fieldName, groupCountName, null);
    }

    public Boolean addHeading(String fieldName, String groupCountName, String tocTooltip) throws JRScriptletException {
        if (fieldName != null && !"".equals(fieldName)) {
            String prgNameFieldValue;
            List<HeadingBean> headings = this.getHeadings();
            String text = null;
            String reference = null;
            Integer pageIndex = (Integer)this.scriptlet.getVariableValue(VARIABLE_NAME_PAGE_NUMBER);
            Integer groupCount = null;
            try {
                if (groupCountName != null && !"".equals(groupCountName)) {
                    groupCount = (Integer)this.scriptlet.getVariableValue(groupCountName);
                } else {
                    L.debug("name of groupCount variable is null or empty!");
                }
            }
            catch (JRScriptletException e) {
                L.debug("wrong name of groupCount variable: " + groupCountName, (Throwable)e);
            }
            text = prgNameFieldValue = (String)this.scriptlet.getFieldValue(fieldName);
            reference = prgNameFieldValue;
            if (text != null && (groupCount == null || groupCount != null && groupCount == 0)) {
                L.debug("addHeading for: ");
                L.debug("       prg: " + prgNameFieldValue);
                L.debug("      page: " + pageIndex);
                L.debug("      group_COUNT=" + groupCount);
                HeadingBean el = new HeadingBean(HeadingBean.HEADING_TWO, text, reference, HeadingBean.getBackReference(reference), pageIndex, null);
                el.setTooltip(tocTooltip);
                headings.add(el);
            }
        }
        return Boolean.FALSE;
    }

    public Boolean addSubHeading(String parentHeading, String currentHeading, int pos) throws JRScriptletException {
        return this.addSubHeading(parentHeading, currentHeading, null, pos);
    }

    public Boolean addSubHeading(String parentHeading, String currentHeading, String tooltip, int pos) throws JRScriptletException {
        if (currentHeading != null && !"".equals(currentHeading)) {
            String reference = null;
            reference = parentHeading != null && !"".equals(parentHeading) ? parentHeading.concat("_").concat(currentHeading) : currentHeading;
            return this.addSubHeading(parentHeading, currentHeading, reference, tooltip, pos);
        }
        return Boolean.TRUE;
    }

    public Boolean addSubHeading(String parentHeading, String currentHeading, String reference, String tooltip, int pos) throws JRScriptletException {
        if (currentHeading != null && !"".equals(currentHeading)) {
            List<HeadingBean> headings = this.getHeadings();
            String text = currentHeading;
            if (text != null) {
                Integer pageIndex = (Integer)this.scriptlet.getVariableValue(VARIABLE_NAME_PAGE_NUMBER);
                L.debug("addSubHeading for: " + text + " of group: " + parentHeading);
                L.debug("      page: " + pageIndex);
                HeadingBean el = new HeadingBean(HeadingBean.HEADING_THREE, text, reference, HeadingBean.getBackReference(reference), pageIndex, null);
                el.setTooltip(tooltip);
                if (pos == -1) {
                    headings.add(el);
                } else {
                    headings.add(pos, el);
                }
            }
        }
        return Boolean.TRUE;
    }

    public Boolean addSubHeading(String parentHeading, String currentHeading) throws JRScriptletException {
        return this.addSubHeading(parentHeading, currentHeading, -1);
    }

    public Boolean addSubHeading(String parentHeading, String currentHeading, String reference) throws JRScriptletException {
        if (reference == null) {
            return this.addSubHeading(parentHeading, currentHeading);
        }
        return this.addSubHeading(parentHeading, currentHeading, reference, null, -1);
    }

    public static String getAnchor(String parentHeading, String currentHeading) {
        String reference = null;
        if (currentHeading != null && !"".equals(currentHeading)) {
            reference = parentHeading != null && !"".equals(parentHeading) ? parentHeading.concat("_").concat(currentHeading) : currentHeading;
        }
        reference = HeadingBean.replaceIllegalForHiperlink(reference);
        L.debug("anchor=" + reference + " --- for " + currentHeading + ", " + parentHeading);
        return reference;
    }

    public Boolean addSummaryHeading(String reference) throws JRScriptletException {
        List<HeadingBean> headings = this.getHeadings();
        String txt = Messages.getString(HeadingsScriptletFactory.class, "reportSummaryPage.linkLabel");
        L.debug("addSummaryHeading: {}", (Object)txt);
        headings.add(new HeadingBean(HeadingBean.HEADING_ONE, txt, reference, HeadingBean.getBackReference(reference), new Integer(2), null));
        return Boolean.TRUE;
    }

    public List<HeadingBean> getHeadings() throws JRScriptletException {
        ArrayList headings = (ArrayList)this.scriptlet.getVariableValue(HEADINGS_COLLECTION_VARIABLE_NAME);
        if (headings == null) {
            headings = new ArrayList();
            this.scriptlet.setVariableValue(HEADINGS_COLLECTION_VARIABLE_NAME, headings);
            L.debug("<HeadingsCollection> variable was null and now is reseted");
        }
        return headings;
    }

    public Boolean addAppendixHeading(String reference) throws JRScriptletException {
        List<HeadingBean> headings = this.getHeadings();
        Integer pageIndex = (Integer)this.scriptlet.getVariableValue(VARIABLE_NAME_PAGE_NUMBER);
        L.debug("addAppendixHeading at page: " + pageIndex);
        headings.add(new HeadingBean(HeadingBean.HEADING_ONE, Messages.getString(HeadingsScriptletFactory.class, "appendix.linkLabel"), reference, HeadingBean.getBackReference(reference), pageIndex, null));
        return Boolean.TRUE;
    }

    public Boolean addReportDetailsHeading(String reference) throws JRScriptletException {
        List<HeadingBean> headings = this.getHeadings();
        Integer pageIndex = (Integer)this.scriptlet.getVariableValue(VARIABLE_NAME_PAGE_NUMBER);
        String txt = Messages.getString(HeadingsScriptletFactory.class, "reportDetailsPage.linkLabel");
        L.debug("addReportDetailsHeading at page {}; txt={}", (Object)pageIndex, (Object)txt);
        headings.add(new HeadingBean(HeadingBean.HEADING_ONE, txt, reference, HeadingBean.getBackReference(reference), pageIndex, null));
        return Boolean.TRUE;
    }

    public Boolean addHeadingSubreport(String text, Integer groupCount) throws JRScriptletException {
        String reference = null;
        Integer pageIndex = (Integer)this.scriptlet.getVariableValue(VARIABLE_NAME_PAGE_NUMBER);
        L.debug(" addHeadingSubreport()     page: " + pageIndex);
        reference = text;
        List<HeadingBean> headings = this.getHeadings();
        if (text != null && (groupCount == null || groupCount != null && groupCount == 0)) {
            L.debug("addHeading for: ");
            L.debug("       prg: " + text);
            L.debug("      page: " + pageIndex);
            L.debug("      group_COUNT=" + groupCount);
            headings.add(new HeadingBean(HeadingBean.HEADING_TWO, text, reference, HeadingBean.getBackReference(reference), pageIndex, null));
        }
        return Boolean.FALSE;
    }

    public Boolean addHeadingSubreport(String parentName, String text) throws JRScriptletException {
        String reference = null;
        Integer pageIndex = (Integer)this.scriptlet.getVariableValue(VARIABLE_NAME_PAGE_NUMBER);
        L.debug(" addHeadingSubreport()     page: " + pageIndex);
        reference = text;
        List<HeadingBean> headings = this.getHeadings();
        if (text != null) {
            if (parentName != null && !parentName.isEmpty()) {
                reference = String.valueOf(parentName) + "_" + text;
            }
            L.debug("addHeading for: ");
            L.debug("      prg: " + text);
            L.debug("      parent=" + parentName);
            L.debug("      page: " + pageIndex);
            headings.add(new HeadingBean(HeadingBean.HEADING_TWO, text, reference, HeadingBean.getBackReference(reference), pageIndex, null));
        }
        return Boolean.TRUE;
    }

    public Boolean addHeadingForParam(String paramName) throws JRScriptletException {
        return this.addHeadingForParam(paramName, HeadingBean.HEADING_TWO);
    }

    public Boolean addHeadingForParam(String paramName, Integer headingBean) throws JRScriptletException {
        if (paramName != null && !"".equals(paramName)) {
            Integer pageIndex = (Integer)this.scriptlet.getVariableValue(VARIABLE_NAME_PAGE_NUMBER);
            String paramValue = (String)this.scriptlet.getParameterValue(paramName);
            if (paramValue != null) {
                L.debug("addHeading for: " + paramValue);
                L.debug("      page: " + pageIndex);
                List<HeadingBean> headings = this.getHeadings();
                headings.add(new HeadingBean(headingBean, paramValue, paramValue, HeadingBean.getBackReference(paramValue), pageIndex, null));
            }
        }
        return Boolean.FALSE;
    }

    public void setScriptlet(JRDefaultScriptlet scriptlet) {
        this.scriptlet = scriptlet;
    }

    public Boolean addDuplicateHeading(String fieldName, String groupName) throws JRScriptletException {
        if (fieldName != null && !"".equals(fieldName) && groupName != null && !"".contains(groupName)) {
            String text = null;
            String reference = null;
            Integer pageIndex = (Integer)this.scriptlet.getVariableValue(VARIABLE_NAME_PAGE_NUMBER);
            String prgNameFieldValue = (String)this.scriptlet.getFieldValue(fieldName);
            text = Messages.getString(HeadingsScriptletFactory.class, "notUniqueField.entry", new String[]{groupName, prgNameFieldValue});
            if (text != null) {
                L.debug("addHeading for: ");
                L.debug("       prg: " + prgNameFieldValue);
                L.debug("      page: " + pageIndex);
                L.debug("      group_name=" + groupName);
                List<HeadingBean> headings = this.getHeadings();
                reference = text;
                headings.add(new HeadingBean(HeadingBean.HEADING_TWO, text, reference, HeadingBean.getBackReference(reference), pageIndex, null));
            }
        }
        return Boolean.FALSE;
    }

    public Boolean addSubSubHeading(String ancestor1, String ancestor2, String current, int pos) throws JRScriptletException {
        if (current != null && !"".equals(current)) {
            List<HeadingBean> headings = this.getHeadings();
            String text = current;
            String reference = current;
            if (ancestor2 != null && !"".equals(ancestor2)) {
                reference = ancestor2.concat("_").concat(reference);
            }
            if (ancestor1 != null && !"".equals(ancestor1)) {
                reference = ancestor1.concat("_").concat(reference);
            }
            Integer pageIndex = (Integer)this.scriptlet.getVariableValue(VARIABLE_NAME_PAGE_NUMBER);
            if (text != null) {
                L.debug("addSubSubHeading for: " + text + " of group: " + ancestor2);
                L.debug("      page: " + pageIndex);
                HeadingBean el = new HeadingBean(HeadingBean.HEADING_FOUR, text, reference, HeadingBean.getBackReference(reference), pageIndex, null);
                if (pos == -1) {
                    headings.add(el);
                } else {
                    headings.add(pos, el);
                }
            }
        }
        return Boolean.TRUE;
    }
}

