/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.model;

import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadingBean {
    private static final Logger L = LoggerFactory.getLogger(HeadingBean.class);
    public static final Integer HEADING_ONE = new Integer(1);
    public static final Integer HEADING_TWO = new Integer(2);
    public static final Integer HEADING_THREE = new Integer(3);
    public static final Integer HEADING_FOUR = new Integer(4);
    private Integer headingType = null;
    private String headingText = null;
    private String reference = null;
    private String backReference = null;
    private Integer pageIndex = null;
    private Integer weight = null;
    private String tooltip = null;
    private String path = null;

    public HeadingBean(Integer type, String text, String reference, String backReference, Integer pageIndex, Integer weight) {
        this.headingType = type;
        this.headingText = text;
        this.reference = reference;
        this.path = reference;
        if (reference != null) {
            this.reference = HeadingBean.replaceIllegalForHiperlink(reference);
        }
        this.backReference = backReference;
        this.pageIndex = pageIndex;
        this.weight = weight;
    }

    public Integer getHeadingType() {
        return this.headingType;
    }

    public String getHeadingText() {
        return this.headingText;
    }

    public void setText(String text) {
        this.headingText = text;
    }

    public static String changeEncoding(String externalized) {
        try {
            externalized = new String(externalized.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            L.error("error at externalize parameters of report", (Throwable)e);
        }
        return externalized;
    }

    public String getReference() {
        return this.reference;
    }

    public String getBackReference() {
        return this.backReference;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public String getPageStr() {
        String ret = this.pageIndex != null ? this.pageIndex.toString() : "";
        return ret;
    }

    public static String getBackReference(String reference) {
        return "toc" + reference;
    }

    public static String replaceIllegalForHiperlink(String reference) {
        return HeadingBean.stringToHex("\n" + reference.hashCode());
    }

    private static String stringToHex(String base) {
        StringBuffer hex = new StringBuffer();
        char[] cArray = base.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            hex.append(Integer.toHexString(c));
            ++n2;
        }
        return hex.toString();
    }

    public String getPath() {
        return this.path;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }
}

