/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.datasource;

import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.ReportRow;
import com.ez.report.generation.common.utils.Utils;
import java.io.InputStream;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class SC7DataSource
extends BaseSubreportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected ReportRow cValue;
    private String[] titles;
    private int style = 0;

    public SC7DataSource(String title, List<ReportRow> list) {
        super(title, list);
        this.setColumns(7);
    }

    public SC7DataSource(String title, List<ReportRow> list, String[] titles) {
        this(title, list);
        this.titles = titles;
    }

    public SC7DataSource() {
        this.setColumns(7);
    }

    @Override
    public JRDataSource getDataSource() {
        return this;
    }

    @Override
    public String getReportName() {
        if (this.style == 2) {
            return "/reports/subcols7-table_lay2.jasper";
        }
        return "/reports/subcols7-table.jasper";
    }

    @Override
    public InputStream getReportTemplate() {
        String name = "reports/subcols7-table.jasper";
        if (this.style == 2) {
            name = "reports/subcols7-table_lay2.jasper";
        }
        InputStream rs = Utils.getResourceStreamFromPlugin(name, null);
        return rs;
    }

    @Override
    public boolean next() throws JRException {
        ReportRow reportRow = this.cValue = this.list.isEmpty() ? null : (ReportRow)this.list.remove(0);
        return this.cValue != null;
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("col1Value")) {
            value = this.cValue.getFirstField();
        } else if (field.getName().equals("col2Value")) {
            value = this.cValue.getSecondField();
        } else if (field.getName().equals("col3Value")) {
            value = Integer.valueOf(this.cValue.getThirdField());
        } else if (field.getName().equals("col4Value")) {
            value = Integer.valueOf(this.cValue.getFourthField());
        } else if (field.getName().equals("col5Value")) {
            value = this.cValue.getFifthField();
        } else if (field.getName().equals("col6Value")) {
            value = this.cValue.getSixthField();
        } else if (field.getName().equals("col7Value")) {
            value = this.cValue.getSeventhField() != null ? Integer.valueOf(this.cValue.getSeventhField()) : null;
        } else if (field.getName().equals("col1Title")) {
            value = this.titles[0];
        } else if (field.getName().equals("col2Title")) {
            value = this.titles[1];
        } else if (field.getName().equals("col3Title")) {
            value = this.titles[2];
        } else if (field.getName().equals("col4Title")) {
            value = this.titles[3];
        } else if (field.getName().equals("col5Title")) {
            value = this.titles[4];
        } else if (field.getName().equals("col6Title")) {
            value = this.titles[5];
        } else if (field.getName().equals("col7Title")) {
            value = this.titles[6];
        } else if (field.getName().equals("extraTitle")) {
            value = this.extraTitle;
        }
        return value;
    }

    public void setLayoutStyle(int layStyle) {
        this.style = layStyle;
    }
}

