/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.datasource;

import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.internal.Messages;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementGroupInfo
implements JRRewindableDataSource {
    private static final Logger L = LoggerFactory.getLogger(ElementGroupInfo.class);
    private String groupElem;
    private List subgroupList;
    private String jasperName;
    protected SubreportDataSource currentValue;
    boolean hasRealDataSource = false;
    public boolean hasSummaryAdded = false;
    @Deprecated
    private String subReport2Name;
    private SubreportDataSource subReport2DS;
    private InputStream subreport2Template;
    private Map<String, BaseSubreportDataSource> subgroups = new HashMap<String, BaseSubreportDataSource>();
    private String groupElemType = null;

    public ElementGroupInfo(String groupElem) {
        this(groupElem, null, Messages.getString(ElementGroupInfo.class, "noData.label"));
    }

    public ElementGroupInfo(String groupElem, String elemType, String noDataMessage) {
        this.groupElem = groupElem;
        this.subgroupList = new ArrayList();
        if (groupElem != null) {
            DSFactory factory = new DSFactory();
            BaseSubreportDataSource noDataAvailableDS = factory.createDS(0);
            ArrayList<ObjectForSubreport> noDataList = new ArrayList<ObjectForSubreport>();
            ObjectForSubreport noDataObj = new ObjectForSubreport();
            noDataObj.setExp(noDataMessage);
            noDataList.add(noDataObj);
            noDataAvailableDS.setList(noDataList);
            this.subgroupList.add(noDataAvailableDS);
        }
    }

    public ElementGroupInfo(String name, String type) {
        this(name);
        this.groupElemType = type;
    }

    public String getGroupElem() {
        return this.groupElem;
    }

    public String getGroupElemType() {
        return this.groupElemType;
    }

    public void setGroupElemType(String type) {
        this.groupElemType = type;
    }

    public JRDataSource getElemDataSource() {
        JRDataSource datasource = null;
        if (this.currentValue != null) {
            datasource = this.currentValue.getDataSource();
            this.jasperName = this.currentValue.getReportName();
        }
        return datasource;
    }

    public String getReportName() {
        return this.jasperName;
    }

    public boolean next() throws JRException {
        SubreportDataSource subreportDataSource = this.currentValue = this.subgroupList.size() > 0 ? (SubreportDataSource)this.subgroupList.remove(0) : null;
        return this.currentValue != null;
    }

    public Object getDataSource() {
        return this;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equalsIgnoreCase("subreportDataSource")) {
            value = this.currentValue.getDataSource();
        } else if (field.getName().equalsIgnoreCase("subReportName")) {
            value = this.currentValue.getReportName();
        } else if (field.getName().equalsIgnoreCase("subreport2DataSource")) {
            value = this.subReport2DS;
        } else if (field.getName().equalsIgnoreCase("subReport2")) {
            value = this.subReport2Name;
        } else if (!field.getName().equalsIgnoreCase("subreport3DataSource") && !field.getName().equalsIgnoreCase("subReport3")) {
            if (field.getName().equalsIgnoreCase("subreport1Template")) {
                value = this.currentValue.getReportTemplate();
            } else if (field.getName().equalsIgnoreCase("subreport2Template")) {
                value = this.subreport2Template;
            } else {
                field.getName().equalsIgnoreCase("subreport3Template");
            }
        }
        return value;
    }

    public void addDataSource(SubreportDataSource sds) {
        if (!this.hasRealDataSource) {
            this.subgroupList.clear();
            this.hasRealDataSource = true;
        }
        this.subgroupList.add(sds);
        if (sds instanceof BaseSubreportDataSource) {
            BaseSubreportDataSource ds = (BaseSubreportDataSource)sds;
            this.subgroups.put(ds.getKey(), ds);
        }
    }

    public BaseSubreportDataSource getDS(String key) {
        return this.subgroups.get(key);
    }

    public void changeTitles(String extraTitle) {
        Set<String> inputPrgSet = this.subgroups.keySet();
        ArrayList<String> inputPrgList = new ArrayList<String>();
        inputPrgList.addAll(inputPrgSet);
        Collections.sort(inputPrgList);
        ArrayList<BaseSubreportDataSource> list = new ArrayList<BaseSubreportDataSource>();
        int i = 0;
        while (i < inputPrgList.size()) {
            BaseSubreportDataSource ds = this.subgroups.get(inputPrgList.get(i));
            if (i == 0) {
                ds.setExtraTitle(extraTitle);
            }
            list.add(i, ds);
            ++i;
        }
        this.subgroupList = list;
        for (BaseSubreportDataSource ds : this.subgroupList) {
            ObjectForSubreport o;
            String oldTitle = ds.getTitle();
            if (oldTitle.trim().equalsIgnoreCase("")) continue;
            List subReportList = ds.getList();
            int nr = subReportList.size();
            if (subReportList.size() > 0 && (o = (ObjectForSubreport)subReportList.get(0)).isNotCountInSummary()) {
                nr = 0;
            }
            String newTitle = oldTitle.concat(" (").concat(String.valueOf(nr)).concat(")");
            ds.setTitle(newTitle);
        }
    }

    public String getSubReport2Name() {
        return this.subReport2Name;
    }

    public void setSubReport2Name(String subReport2Name) {
        this.subReport2Name = subReport2Name;
    }

    public SubreportDataSource getSubReport2DS() {
        return this.subReport2DS;
    }

    public void setSubreport2Template(InputStream is) {
        this.subreport2Template = is;
    }

    public void setSubReport2DS(SubreportDataSource subReport2DS) {
        this.subReport2DS = subReport2DS;
    }

    public boolean hasSummaryAdded() {
        return this.hasSummaryAdded;
    }

    public void setSummaryAdded(boolean hasSummaryAdded) {
        this.hasSummaryAdded = hasSummaryAdded;
    }

    public void moveFirst() throws JRException {
        L.trace("move first!!");
    }

    public boolean hasNoData() {
        return !this.hasRealDataSource;
    }
}

