/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.datasource;

import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SC2DataSource;
import com.ez.report.generation.common.datasource.SC2DataSourceWithGroup;
import com.ez.report.generation.common.datasource.SC3DataSource;
import com.ez.report.generation.common.datasource.SEmptySpaceDataSource;
import com.ez.report.generation.common.datasource.SPageBreakDataSource;

public class DSFactory {
    public static final int SC2_DATA_SOURCE = 0;
    public static final int SC3_DATA_SOURCE = 1;
    public static final int SC2_WITH_GROUP_DATA_SOURCE = 2;
    public static final int SC1_DATA_SOURCE = 3;
    public static final int SPAGEBREAK_DATA_SOURCE = 4;
    public static final int SEMPTYSPACE_DATA_SOURCE = 5;

    public BaseSubreportDataSource createDS(int summaryDSKind) {
        BaseSubreportDataSource ds = null;
        switch (summaryDSKind) {
            case 3: {
                ds = new SC1DataSource();
                break;
            }
            case 0: {
                ds = new SC2DataSource();
                break;
            }
            case 1: {
                ds = new SC3DataSource();
                break;
            }
            case 2: {
                ds = new SC2DataSourceWithGroup();
                break;
            }
            case 4: {
                ds = new SPageBreakDataSource();
                break;
            }
            case 5: {
                ds = new SEmptySpaceDataSource();
                break;
            }
        }
        return ds;
    }

    public ObjectForSubreport createObj(int elemDSKind, String[] results, String groupPrefix) {
        ObjectForSubreport obj = new ObjectForSubreport();
        switch (elemDSKind) {
            case 0: 
            case 1: 
            case 3: {
                String elemExpression = results[1];
                obj.setExp(elemExpression);
                obj.setParent(results[0]);
                break;
            }
            case 2: {
                if (groupPrefix != null && !"".equalsIgnoreCase(groupPrefix)) {
                    obj.setElGroup(String.valueOf(groupPrefix) + ": " + results[1]);
                } else {
                    obj.setElGroup(results[1]);
                }
                obj.setParent(results[0]);
                obj.setExp(results[2]);
                obj.setExpVal(results[3]);
                break;
            }
        }
        return obj;
    }
}

