/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.datasource;

import com.ez.report.generation.common.datasource.Object4TestReport;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSubreportDataSource
implements SubreportDataSource {
    private static final Logger L = LoggerFactory.getLogger(BaseSubreportDataSource.class);
    protected List list;
    protected String title;
    protected String key;
    protected String tocEntry = null;
    protected int columns = 0;
    protected String extraTitle;
    protected Object4TestReport currentValue;
    private ArrayList<ObjectForSubreport> values = new ArrayList();
    protected int idx = 0;
    private String decision;
    private Object listNamesDataSource;
    protected int count = 0;
    protected String tocTooltip = null;

    public BaseSubreportDataSource(String title, List list) {
        this.list = list;
        this.title = title;
        this.idx = 0;
    }

    public BaseSubreportDataSource() {
        this.idx = 0;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        L.trace("field.name={}", (Object)field.getName());
        if (field.getName().equals("titleField")) {
            value = this.title;
        }
        if (field.getName().equals("groupDiscriminator")) {
            value = this.currentValue.getElementFromGroup();
        }
        if (field.getName().equals("parentTOC")) {
            value = this.currentValue.getParentElement();
        }
        if (field.getName().equals("subreportType4TOC")) {
            value = this.tocEntry;
        }
        if (field.getName().equals("leftField")) {
            value = this.currentValue.getLeftExpresion();
        }
        if (field.getName().equals("leftValue")) {
            value = this.currentValue.getLeftValueExpresion();
        }
        if (field.getName().equals("middleField")) {
            value = this.currentValue.getMiddleExpresion();
        }
        field.getName().equals("middleValue");
        if (field.getName().equals("extraTitle")) {
            value = this.extraTitle;
        }
        if (field.getName().equals("rightField")) {
            value = this.currentValue.getRightExpresion();
        }
        if (field.getName().equals("rightValue")) {
            value = this.currentValue.getRightValueExpresion();
        }
        if (field.getName().equals("extraTitle") && value == null) {
            value = this.currentValue.getHyperlink();
        }
        if (field.getName().equals("hyperlink")) {
            value = this.currentValue.getHyperlink();
        }
        if (field.getName().equals("fourthField")) {
            value = this.currentValue.getFourthField();
        }
        if (field.getName().equals("fifthField")) {
            value = this.currentValue.getFifthField();
        }
        if (field.getName().equals("decision")) {
            value = this.decision;
        }
        if (field.getName().equals("listNamesDataSource")) {
            value = this.listNamesDataSource;
        }
        if (field.getName().equals("leftHyperlink")) {
            value = this.currentValue.hasHyperlink() ? this.currentValue.getHyperlink() : this.currentValue.getLeftHyperlink();
        }
        if (field.getName().equals("leftAnchor")) {
            value = this.currentValue.getLeftAnchor();
        }
        if (field.getName().equals("rightHyperlink")) {
            value = this.currentValue.getRightHyperlink();
        }
        if (field.getName().equals("tocTooltip")) {
            value = ReportsUtils.prepareTooltip(this.tocTooltip);
        }
        if (field.getName().equals("rightAnchor")) {
            value = this.currentValue.getRightAnchor();
        }
        return value;
    }

    public boolean next() throws JRException {
        this.values.clear();
        int i = 0;
        while (i < this.columns) {
            ObjectForSubreport obj;
            if (this.idx + i < this.list.size() && (obj = (ObjectForSubreport)this.list.get(this.idx + i)) != null) {
                this.values.add(obj);
            }
            ++i;
        }
        this.constructCurrent(this.values);
        return this.values.size() > 0;
    }

    protected void constructCurrent(ArrayList<ObjectForSubreport> values) {
        if (values.size() > 0) {
            this.currentValue = new Object4TestReport();
            ObjectForSubreport leftObj = values.get(0);
            this.currentValue.setParentElement(leftObj.getParent());
            String group = leftObj.getElGroup();
            this.currentValue.setElementFromGroup(group);
            this.currentValue.setLeftAnchor(leftObj.getAnchor());
            switch (this.columns) {
                case 1: {
                    this.currentValue.setLeftExpresion(leftObj.getExp());
                    this.currentValue.setRightExpresion(leftObj.getExpVal());
                    this.currentValue.setHyperlink(leftObj.getHyperlink());
                    this.currentValue.setSubreportDS(leftObj.getSubreportDS());
                    this.currentValue.setSubreportName(leftObj.getSubreportName());
                    this.currentValue.setElementFromGroup(leftObj.getElGroup());
                    ++this.idx;
                    break;
                }
                case 2: {
                    ObjectForSubreport right;
                    this.currentValue.setLeftExpresion(leftObj.getExp());
                    this.currentValue.setLeftValueExpresion(leftObj.getExpVal());
                    if (leftObj.getHyperlink() != null && !"".equals(leftObj.getHyperlink())) {
                        this.currentValue.setHyperlink(leftObj.getHyperlink());
                    }
                    ++this.idx;
                    if (values.size() <= 1 || (right = values.get(1)) == null || (group != null || right.getElGroup() != null) && (group == null || right.getElGroup() == null || !right.getElGroup().equalsIgnoreCase(group))) break;
                    this.currentValue.setRightExpresion(right.getExp());
                    this.currentValue.setRightValueExpresion(right.getExpVal());
                    this.currentValue.setRightHyperlink(right.getHyperlink());
                    this.currentValue.setLeftAnchor(right.getAnchor());
                    if (right.getColumnName() != null) {
                        this.currentValue.setRightColumName(right.getColumnName());
                    }
                    ++this.idx;
                    break;
                }
                case 3: {
                    ObjectForSubreport right;
                    ObjectForSubreport middle;
                    this.currentValue.setLeftExpresion(leftObj.getExp());
                    this.currentValue.setLeftValueExpresion(leftObj.getExpVal());
                    this.currentValue.setHyperlink(leftObj.getAnchor());
                    ++this.idx;
                    if (values.size() <= 1 || (middle = values.get(1)) == null || (group != null || middle.getElGroup() != null) && (group == null || middle.getElGroup() == null || !middle.getElGroup().equalsIgnoreCase(group))) break;
                    this.currentValue.setMiddleExpresion(middle.getExp());
                    ++this.idx;
                    if (values.size() <= 2 || (right = values.get(2)) == null || (group != null || right.getElGroup() != null) && (group == null || right.getElGroup() == null || !right.getElGroup().equalsIgnoreCase(group))) break;
                    this.currentValue.setRightExpresion(right.getExp());
                    this.currentValue.setRightValueExpresion(right.getExpVal());
                    ++this.idx;
                    break;
                }
                case 4: {
                    ObjectForSubreport fourth;
                    ObjectForSubreport right;
                    ObjectForSubreport middle;
                    this.currentValue.setLeftExpresion(leftObj.getExp());
                    this.currentValue.addHyperlink(leftObj.getHyperlink());
                    this.currentValue.addColorCondition(leftObj.getColorCondition());
                    ++this.idx;
                    if (values.size() <= 1 || (middle = values.get(1)) == null || (group != null || middle.getElGroup() != null) && (group == null || middle.getElGroup() == null || !middle.getElGroup().equalsIgnoreCase(group))) break;
                    this.currentValue.setMiddleExpresion(middle.getExp());
                    this.currentValue.addHyperlink(middle.getHyperlink());
                    this.currentValue.addColorCondition(middle.getColorCondition());
                    ++this.idx;
                    if (values.size() <= 2 || (right = values.get(2)) == null || (group != null || right.getElGroup() != null) && (group == null || right.getElGroup() == null || !right.getElGroup().equalsIgnoreCase(group))) break;
                    this.currentValue.setRightExpresion(right.getExp());
                    this.currentValue.addHyperlink(right.getHyperlink());
                    this.currentValue.addColorCondition(right.getColorCondition());
                    ++this.idx;
                    if (values.size() <= 3 || (fourth = values.get(3)) == null || (group != null || fourth.getElGroup() != null) && (group == null || fourth.getElGroup() == null || !fourth.getElGroup().equalsIgnoreCase(group))) break;
                    this.currentValue.setFourthField(fourth.getExp());
                    this.currentValue.addHyperlink(fourth.getHyperlink());
                    this.currentValue.addColorCondition(fourth.getColorCondition());
                    ++this.idx;
                    break;
                }
                case 5: {
                    ObjectForSubreport fifth;
                    ObjectForSubreport fourth;
                    ObjectForSubreport right;
                    ObjectForSubreport middle;
                    this.currentValue.setLeftExpresion(leftObj.getExp());
                    this.currentValue.setLeftValueExpresion(leftObj.getExpVal());
                    ++this.idx;
                    if (values.size() <= 1 || (middle = values.get(1)) == null || (group != null || middle.getElGroup() != null) && (group == null || middle.getElGroup() == null || !middle.getElGroup().equalsIgnoreCase(group))) break;
                    this.currentValue.setMiddleExpresion(middle.getExp());
                    ++this.idx;
                    if (values.size() <= 2 || (right = values.get(2)) == null || (group != null || right.getElGroup() != null) && (group == null || right.getElGroup() == null || !right.getElGroup().equalsIgnoreCase(group))) break;
                    this.currentValue.setRightExpresion(right.getExp());
                    this.currentValue.setRightValueExpresion(right.getExpVal());
                    ++this.idx;
                    if (values.size() <= 3 || (fourth = values.get(3)) == null || (group != null || fourth.getElGroup() != null) && (group == null || fourth.getElGroup() == null || !fourth.getElGroup().equalsIgnoreCase(group))) break;
                    this.currentValue.setFourthField(fourth.getExp());
                    ++this.idx;
                    if (values.size() <= 4 || (fifth = values.get(3)) == null || (group != null || fifth.getElGroup() != null) && (group == null || fifth.getElGroup() == null || !fifth.getElGroup().equalsIgnoreCase(group))) break;
                    this.currentValue.setFifthField(fifth.getExp());
                    ++this.idx;
                    break;
                }
            }
        }
    }

    @Override
    public JRDataSource getDataSource() {
        return null;
    }

    @Override
    public String getReportName() {
        return null;
    }

    protected void setColumns(int columns) {
        if (columns > 10 || columns < 1) {
            throw new IllegalArgumentException("columns must be in [1,10]");
        }
        this.columns = columns;
    }

    public List getList() {
        return this.list;
    }

    public void setList(List list) {
        this.list = list;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getKey() {
        return this.key != null ? this.key : this.title;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setTocEntry(String tocEntry) {
        this.tocEntry = tocEntry;
    }

    public void setExtraTitle(String extraTitle) {
        this.extraTitle = extraTitle;
    }

    public void setDecision(String decision) {
        this.decision = decision;
    }

    public void setListNamesDataSource(Object listNamesDataSource) {
        this.listNamesDataSource = listNamesDataSource;
    }

    public void moveFirst() throws JRException {
        L.trace("move first!!");
    }

    public int getObjNr() {
        return this.count;
    }

    @Override
    public InputStream getReportTemplate() {
        return null;
    }
}

