/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common;

import com.ez.report.generation.common.GenericCommonReportBuilder;
import com.ez.report.generation.common.ReportExecutorInterface;
import com.ez.report.generation.common.model.ReportGroupInformation;
import com.ez.report.generation.common.model.ReportInformation;
import com.ez.report.generation.common.utils.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsRepository {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportsRepository.class);
    private static Map<String, ReportInformation> repInfo = new HashMap<String, ReportInformation>();
    private static Map reportGroupIndex = new HashMap();
    private static Map<String, ReportGroupInformation> groups = new HashMap<String, ReportGroupInformation>();

    public static GenericCommonReportBuilder getBuilder(String reportName, String indicator) {
        String className = ReportsRepository.getBuilderClassName(indicator);
        Class[] params = new Class[]{String.class, String.class};
        Object[] args = new String[]{reportName, "sett"};
        GenericCommonReportBuilder builder = ReportsRepository.instantiateBuilder(className, params, args);
        return builder;
    }

    private static GenericCommonReportBuilder instantiateBuilder(String className, Class[] params, Object[] args) {
        GenericCommonReportBuilder builder = (GenericCommonReportBuilder)Utils.instantiate(className, params, args);
        if (builder == null) {
            L.error("could not instantiate builder with className: {}", (Object)className);
        }
        return builder;
    }

    public static GenericCommonReportBuilder getBuilder(String reportName, String settings, String indicator) {
        String className = ReportsRepository.getBuilderClassName(indicator);
        Class[] params = new Class[]{String.class, String.class};
        Object[] args = new String[]{reportName, settings};
        GenericCommonReportBuilder builder = ReportsRepository.instantiateBuilder(className, params, args);
        return builder;
    }

    private static String getBuilderClassName(String indicator) {
        ReportInformation ri = ReportsRepository.getReportInformation(indicator);
        String className = ri.getBuilderClassName();
        return className;
    }

    public static void addReportInformation(int indicator, ReportInformation repInformation) {
        repInfo.put(String.valueOf(indicator), repInformation);
        String gID = repInformation.getGroupID();
        ReportGroupInformation gInfo = groups.get(gID);
        if (gInfo != null) {
            gInfo.addReport(repInformation.getId());
        } else {
            L.warn("unknown group for report: {} (groupsId={})", (Object)repInformation.getReportName(), (Object)gID);
        }
    }

    public static ReportInformation getReportInformation(String indicator) {
        return repInfo.get(indicator);
    }

    public static ReportInformation getReportInformation(int reportId) {
        return repInfo.get(String.valueOf(reportId));
    }

    public static Set<String> getRegisteredReportIndicators() {
        return repInfo.keySet();
    }

    public static String[] getGroupIndexes(int indicator) {
        return (String[])reportGroupIndex.get(String.valueOf(indicator));
    }

    public static void addGroupIndex(String indicator, String[] indexesString) {
        reportGroupIndex.put(indicator, indexesString);
    }

    public static String[] getGroupIndexes(String indicator) {
        return (String[])reportGroupIndex.get(indicator);
    }

    public static ReportExecutorInterface getExecutor(String reportIndicator, Map<String, Object> settings) {
        ReportExecutorInterface executor = null;
        ReportInformation ri = ReportsRepository.getReportInformation(reportIndicator);
        if (ri != null) {
            String className = ri.getExecutorClassName();
            if (className != null && !className.isEmpty()) {
                Class[] params = new Class[]{Map.class};
                Object[] args = new Object[]{settings};
                executor = (ReportExecutorInterface)Utils.instantiate(className, params, args);
                if (executor == null) {
                    L.error("could not instantiate executor for {}", (Object)reportIndicator);
                }
            } else {
                L.error("report without executor className: {}", (Object)reportIndicator);
            }
        } else {
            L.error("unknown type of report: {}", (Object)reportIndicator);
        }
        return executor;
    }

    public static void addReportGroupInformation(ReportGroupInformation info) {
        groups.put(info.getId(), info);
    }

    public static Collection<ReportGroupInformation> getGroups() {
        return groups.values();
    }
}

