/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.ann.configuration.service.impl;

import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.eclient.service.database.DatabaseService;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.api.DatabaseInfoBuilder;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.ann.core.AnnotationsConnDetailsService;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotsConnDetailsServiceImpl
implements AnnotationsConnDetailsService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Logger L = LoggerFactory.getLogger(AnnotsConnDetailsServiceImpl.class);
    private DatabaseInfo dbInfo;

    public DatabaseInfo getAnnDbInfo() {
        if (this.dbInfo == null) {
            this.dbInfo = this.readAnnDbInfo();
        }
        if (this.dbInfo == null) {
            this.L.info("dbinfo is null");
        }
        return this.dbInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseInfo readAnnDbInfo() {
        DatabaseInfo info = null;
        DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
        if (srv == null) {
            this.L.error("no pref service available for now");
            return null;
        }
        String val = srv.getString("general.networking.annotations", "annotations.server", null, null);
        if (val == null) {
            this.L.error("server is not set for annotations in CCS! cannot continue!");
        } else {
            DatabaseService dbsrv = null;
            int k = 0;
            while (k < 3 && dbsrv == null) {
                dbsrv = (DatabaseService)ServiceUtils.getService(DatabaseService.class);
                if (dbsrv == null) {
                    long t = 3000L;
                    this.L.trace("database service is null; will wait {}sec and ask again", (Object)(t / 1000L));
                    AnnotsConnDetailsServiceImpl annotsConnDetailsServiceImpl = this;
                    synchronized (annotsConnDetailsServiceImpl) {
                        try {
                            this.wait(t);
                        }
                        catch (InterruptedException e) {
                            this.L.trace("", (Throwable)e);
                        }
                    }
                }
                ++k;
            }
            if (dbsrv == null) {
                this.L.error("database service is null!");
            } else {
                UUID serverid = UUID.fromString(val);
                info = (DatabaseInfo)dbsrv.getEntities().get(serverid);
                if (info == null) {
                    this.L.error("no details found for serverId={}", (Object)val);
                } else {
                    DatabaseInfoBuilder dbBuilder = DatabaseInfoBuilder.from((DatabaseInfo)info);
                    val = srv.getString("general.networking.annotations", "annotations.database", null, null);
                    dbBuilder.setDatabase(val);
                    val = srv.getString("general.networking.annotations", "annotations.schema", null, null);
                    dbBuilder.setSchema(val);
                    info = dbBuilder.build();
                }
            }
        }
        return info;
    }
}

