/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.ann.configuration.config;

import com.ez.eclient.configuration.bootstrap.BootstrapParticipant;
import com.ez.eclient.configuration.bootstrap.Bootstrapper;
import com.ez.eclient.configuration.bootstrap.internal.Messages;
import com.ez.eclient.configuration.service.ConfigurationInterceptorFactory;
import com.ez.eclient.configuration.synchro.service.ConfigurationDescription;
import com.ez.eclient.configuration.synchro.service.ConfigurationEvent;
import com.ez.eclient.configuration.synchro.service.ConfigurationFormat;
import com.ez.eclient.configuration.synchro.service.ConfigurationListener;
import com.ez.eclient.configuration.synchro.service.PropertiesInterceptor;
import com.ez.eclient.service.database.DatabaseService;
import com.ez.eclient.service.database.DatabaseServiceListener;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.ann.core.AnnotationsConnDetailsService;
import com.ibm.ez.ann.configuration.config.AnnotRepoConfigInterceptorFactory;
import com.ibm.ez.ann.configuration.config.AnnotsConfigurationWrapper;
import com.ibm.ez.ann.configuration.config.AnnotsDbServiceListener;
import com.ibm.ez.ann.configuration.service.impl.AnnotsConnDetailsServiceImpl;
import java.util.List;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationConfigurator
implements BootstrapParticipant {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ConfigurationConfigurator.class);

    public void preConfigure(Properties properties) {
    }

    public void postConfigure(Bootstrapper bs) {
        final ConfigurationDescription confDesc = new ConfigurationDescription("general.networking.annotations", "common", null, null, ConfigurationFormat.EnhancedProperties, false, Messages.getString(ConfigurationConfigurator.class, (String)"configuration.categoryName.annots"), Messages.getString(ConfigurationConfigurator.class, (String)"configuration.name.annots"), (PropertiesInterceptor)new AnnotsConfigurationWrapper());
        bs.registerConfiguration(confDesc, null, (ConfigurationInterceptorFactory)new AnnotRepoConfigInterceptorFactory());
        final BundleContext bundleContext = FrameworkUtil.getBundle(ServiceUtils.class).getBundleContext();
        if (bundleContext != null) {
            ServiceListener listener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    L.debug("OSGI service {} changed", event.getSource());
                    switch (event.getType()) {
                        case 1: {
                            DatabaseService dbServ = (DatabaseService)bundleContext.getService(event.getServiceReference());
                            if (dbServ == null) {
                                L.warn("database service null!");
                                break;
                            }
                            dbServ.registerListener((DatabaseServiceListener)new AnnotsDbServiceListener(dbServ, confDesc));
                            break;
                        }
                        case 4: {
                            bundleContext.removeServiceListener((ServiceListener)this);
                        }
                    }
                }
            };
            String filter = "(objectClass=" + DatabaseService.class.getName() + ")";
            try {
                bundleContext.addServiceListener(listener, filter);
            }
            catch (InvalidSyntaxException e) {
                L.error("error adding OSGI service listener", (Throwable)e);
            }
            bundleContext.registerService(AnnotationsConnDetailsService.class, (Object)new AnnotsConnDetailsServiceImpl(), null);
        } else {
            L.error("context is null! cannot add annotations database OSGI listener");
        }
    }

    class Listener
    implements ConfigurationListener {
        Listener() {
        }

        public void notifyEvent(List<ConfigurationEvent> events) {
            for (ConfigurationEvent e : events) {
                L.debug("{}", (Object)e.toString());
            }
        }
    }
}

