/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.ann.configuration.config;

import com.ez.eclient.configuration.synchro.PropertiesEclipseService;
import com.ez.eclient.configuration.synchro.PropertiesEclipseServiceImpl;
import com.ez.eclient.configuration.synchro.SynchronizablePropertiesService;
import com.ez.eclient.configuration.synchro.service.Configuration;
import com.ez.eclient.configuration.synchro.service.ConfigurationDescription;
import com.ez.eclient.configuration.synchro.service.impl.VersionablePropertiesReadonly;
import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.eclient.service.database.DatabaseService;
import com.ez.eclient.service.database.DatabaseServiceListener;
import com.ez.eclient.service.database.impl.GenericEntityImpl;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.internal.utils.ServiceUtils;
import com.ez.keeper.binding.ObjectEvent;
import com.ibm.ez.ann.configuration.config.AnnotsConfigurationWrapper;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotsDbServiceListener
implements DatabaseServiceListener {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(AnnotsDbServiceListener.class);
    DatabaseService dbServ;
    private String serverId;
    private ConfigurationDescription confDesc;

    public AnnotsDbServiceListener(DatabaseService databaseService, ConfigurationDescription configurationDescription) {
        this.dbServ = databaseService;
        this.confDesc = configurationDescription;
    }

    public void databaseServerDeleted(ObjectEvent e) {
        UUID serverid;
        this.serverId = this.readCurrentServer(null);
        if (this.serverId != null && (serverid = (UUID)e.getId().getId()).toString().equals(this.serverId)) {
            L.warn("Server associated with annotations repository was deleted; after changes it will be applied you'll not be able to use this feature");
            this.dbServerDetailsChanged(e);
        }
    }

    public void databaseServerChanged(ObjectEvent e) {
        UUID serverid;
        this.serverId = this.readCurrentServer(null);
        if (this.serverId != null && (serverid = (UUID)e.getId().getId()).toString().equals(this.serverId)) {
            L.debug("details of annotations database server changed: {}", (Object)e);
            this.dbServerDetailsChanged(e);
        }
    }

    private void dbServerDetailsChanged(ObjectEvent e) {
        SynchronizablePropertiesService syncServ;
        DatabaseInfo newInfo = (DatabaseInfo)((GenericEntityImpl)e.getArgs().get(0)).getAdapter();
        DatabaseInfo oldInfo = (DatabaseInfo)((GenericEntityImpl)e.getArgs().get(1)).getAdapter();
        L.trace("old details: {}", (Object)oldInfo);
        L.trace("new details: {}", (Object)newInfo);
        PropertiesEclipseServiceImpl eclipsePropServ = (PropertiesEclipseServiceImpl)ServiceUtils.getService(PropertiesEclipseService.class);
        if (eclipsePropServ != null && (syncServ = (SynchronizablePropertiesService)eclipsePropServ.getPropertiesService()) != null) {
            Properties currentProp = this.getCurrentProps();
            Properties np = new Properties(currentProp);
            AnnotsConfigurationWrapper.fillProps(newInfo, np);
            Properties op = new Properties(currentProp);
            AnnotsConfigurationWrapper.fillProps(oldInfo, op);
            long version = syncServ.getCurrentVersion(this.confDesc);
            long nversion = version + 1L;
            syncServ.dispatchSyncAvailableEvent(this.confDesc, (Configuration)new VersionablePropertiesReadonly(this.confDesc, np, nversion), (Configuration)new VersionablePropertiesReadonly(this.confDesc, op, version));
        }
    }

    private String readCurrentServer(DynamicPreferencesService srv) {
        if (srv == null) {
            srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
        }
        if (srv == null) {
            L.error("no pref service available for now");
            return null;
        }
        String serverID = srv.getString("general.networking.annotations", "annotations.server", null, null);
        return serverID;
    }

    private Properties getCurrentProps() {
        Properties p = new Properties();
        DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
        if (srv == null) {
            L.error("no pref service available for now");
            return null;
        }
        String val = srv.getString("general.networking.annotations", "annotations.schema", null, null);
        p.put("annotations.schema", val);
        val = srv.getString("general.networking.annotations", "annotations.database", null, null);
        p.put("annotations.database", val);
        val = this.readCurrentServer(srv);
        p.put("annotations.server", val);
        return p;
    }
}

