/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.ann.configuration.config;

import com.ez.eclient.configuration.synchro.service.PropertiesInterceptor;
import com.ez.eclient.service.database.DatabaseService;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.internal.utils.ServiceUtils;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotsConfigurationWrapper
implements PropertiesInterceptor {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(AnnotsConfigurationWrapper.class);
    DatabaseService dbServ;

    private void ensureDBService() {
        this.dbServ = (DatabaseService)ServiceUtils.getService(DatabaseService.class);
        if (this.dbServ == null) {
            L.warn("database service null!");
        }
    }

    public void fillProperties(Properties prop) {
        if (prop == null) {
            L.warn("given properties is NULL; stop here");
            return;
        }
        if (this.dbServ == null) {
            this.ensureDBService();
        }
        DatabaseInfo dbInfo = null;
        String serverId = (String)prop.get("annotations.server");
        if (serverId == null) {
            L.error("db server null for annotations repo!");
            dbInfo = null;
        } else {
            UUID uSrv = UUID.fromString(serverId);
            DatabaseInfo databaseInfo = dbInfo = this.dbServ != null ? (DatabaseInfo)this.dbServ.getEntities().get(uSrv) : null;
        }
        if (dbInfo != null) {
            AnnotsConfigurationWrapper.fillProps(dbInfo, prop);
        } else {
            L.warn("database info null for serverid={}", (Object)serverId);
        }
    }

    static void fillProps(DatabaseInfo dbInfo, Properties prop) {
        prop.put("annotations.servertype", dbInfo.getServerType());
        prop.put("annotations.host", dbInfo.getHost());
        prop.put("annotations.port", String.valueOf(dbInfo.getPort()));
        prop.put("annotations.instance", dbInfo.getInstance());
        prop.put("annotations.storagegroup", dbInfo.getStorageGroup() != null ? dbInfo.getStorageGroup() : "");
        prop.put("annotations.username", dbInfo.getUsername());
    }
}

