/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.ann.configuration.config;

import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.ConfigurationAdapter;
import com.ez.eclient.service.database.DatabaseService;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.internal.utils.ServiceUtils;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotRepoConfigInterceptor
extends ConfigurationAdapter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(AnnotRepoConfigInterceptor.class);
    final DatabaseService dbServ = (DatabaseService)ServiceUtils.getService(DatabaseService.class);
    String serverId = null;
    DatabaseInfo dbInfo = null;

    protected AnnotRepoConfigInterceptor(Configuration c) {
        super(c);
        if (this.dbServ == null) {
            L.warn("database service null!");
        }
    }

    public Object getObject(String path) {
        if (path.equals("annotations.servertype")) {
            this.ensureServer();
            return this.dbInfo != null ? this.dbInfo.getServerType() : null;
        }
        if (path.equals("annotations.host")) {
            this.ensureServer();
            return this.dbInfo != null ? this.dbInfo.getHost() : null;
        }
        if (path.equals("annotations.port")) {
            this.ensureServer();
            return this.dbInfo != null ? this.dbInfo.getPort() : null;
        }
        if (path.equals("annotations.instance")) {
            this.ensureServer();
            return this.dbInfo != null ? this.dbInfo.getInstance() : null;
        }
        if (path.equals("annotations.storagegroup")) {
            this.ensureServer();
            return this.dbInfo != null ? this.dbInfo.getStorageGroup() : null;
        }
        if (path.equals("annotations.username")) {
            this.ensureServer();
            return this.dbInfo != null ? this.dbInfo.getUsername() : null;
        }
        if (path.equals("annotations.password")) {
            this.ensureServer();
            return this.dbInfo != null ? this.dbInfo.getPassword() : null;
        }
        return this.c.getObject(path);
    }

    private void ensureServer() {
        if (this.serverId == null) {
            this.serverId = (String)this.getObject("annotations.server");
            if (this.serverId == null) {
                L.error("db server null for annotations repo!");
                this.dbInfo = null;
            } else {
                UUID uSrv = UUID.fromString(this.serverId);
                this.dbInfo = this.dbServ != null ? (DatabaseInfo)this.dbServ.getEntities().get(uSrv) : null;
            }
        }
    }
}

