/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.ca7.wizard.pages;

import com.ez.common.ui.listselection.Listable;
import com.ez.graphs.internal.Messages;
import com.ez.mainframe.gui.wizard.SingleSelectionPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchidWithGraphSettingsPage<T extends Listable>
extends SingleSelectionPage<Listable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Logger L = LoggerFactory.getLogger(SchidWithGraphSettingsPage.class);
    private static final String INCLUDE_JOB_DEP_LBL = Messages.getString(SchidWithGraphSettingsPage.class, (String)"include.job.dep");
    private static final String INCLUDE_DS_LBL = Messages.getString(SchidWithGraphSettingsPage.class, (String)"include.ds");
    private static final String SHOW_SYS_NAME_LBL = Messages.getString(SchidWithGraphSettingsPage.class, (String)"show.sys.name");
    private static final String SHOW_JOB_INFO_LBL = Messages.getString(SchidWithGraphSettingsPage.class, (String)"show.job.info");
    private boolean restrictGraphOptions = true;

    public SchidWithGraphSettingsPage(String pageName, boolean useFilters, boolean restrictGraphOptions) {
        super(pageName, useFilters);
        this.restrictGraphOptions = restrictGraphOptions;
    }

    protected void createContent(Composite composite) {
        composite.setLayout((Layout)new GridLayout(2, true));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        composite.setLayoutData((Object)data);
        super.createContent(composite);
        Composite parentOptions = new Composite(composite, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        parentOptions.setLayoutData((Object)data);
        parentOptions.setLayout((Layout)new GridLayout());
        Group options = new Group(parentOptions, 0);
        GridLayout gl = new GridLayout();
        gl.marginTop = 50;
        options.setLayout((Layout)gl);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        options.setLayoutData((Object)data);
        options.setText(Messages.getString(SchidWithGraphSettingsPage.class, (String)"options.group.lbl"));
        this.createGraphOptions(options);
    }

    private void createGraphOptions(Group options) {
        GridData data;
        ChoiseSelection selListener = new ChoiseSelection();
        if (this.restrictGraphOptions) {
            Button includeJobDepButton = new Button((Composite)options, 32);
            includeJobDepButton.setText(INCLUDE_JOB_DEP_LBL);
            includeJobDepButton.setData((Object)"include external job dependencies");
            includeJobDepButton.addSelectionListener((SelectionListener)selListener);
            data = new GridData();
            data.verticalAlignment = 1024;
            includeJobDepButton.setLayoutData((Object)data);
            includeJobDepButton.setSelection(true);
            this.setOptionInWizard(includeJobDepButton);
            Button includeDS = new Button((Composite)options, 32);
            includeDS.setText(INCLUDE_DS_LBL);
            includeDS.setData((Object)"include datasets");
            includeDS.addSelectionListener((SelectionListener)selListener);
            data = new GridData();
            data.verticalAlignment = 1024;
            includeDS.setLayoutData((Object)data);
            includeDS.setSelection(true);
            this.setOptionInWizard(includeDS);
        }
        Button showSystemName = new Button((Composite)options, 32);
        showSystemName.setText(SHOW_SYS_NAME_LBL);
        showSystemName.setData((Object)"Show job's system names");
        showSystemName.addSelectionListener((SelectionListener)selListener);
        data = new GridData();
        data.verticalAlignment = 1024;
        showSystemName.setLayoutData((Object)data);
        showSystemName.setSelection(true);
        this.setOptionInWizard(showSystemName);
        Button showJobInfo = new Button((Composite)options, 32);
        showJobInfo.setText(SHOW_JOB_INFO_LBL);
        showJobInfo.setData((Object)"show job information");
        showJobInfo.addSelectionListener((SelectionListener)selListener);
        data = new GridData();
        data.verticalAlignment = 1024;
        showJobInfo.setLayoutData((Object)data);
        showJobInfo.setSelection(false);
        this.setOptionInWizard(showJobInfo);
    }

    private void setOptionInWizard(Button button) {
        this.wizard.set((String)button.getData(), (Object)button.getSelection());
    }

    class ChoiseSelection
    extends SelectionAdapter {
        ChoiseSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            SchidWithGraphSettingsPage.this.setOptionInWizard(b);
        }
    }
}

