/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.ca7.wizard.collectors;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.graphs.ca7.model.CA7Job;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CA7JobCollector
extends BridgeResourcesCollectorAdapter<CA7Job> {
    private static final Logger L = LoggerFactory.getLogger(CA7JobCollector.class);
    private static final String ALL_CA7_JOBS_QUERY = "select JobId, Job_Name, case when  EXISTS (select CA7_SchedulesPerJob.JobID FROM CA7_SchedulesPerJob where CA7_SchedulesPerJob.JobID = CA7_Jobs.jobID ) then 0 \r\n\t\telse (case when (EXISTS (SELECT TriggeredBy_JobID FROM CA7_JobsTriggeredByJobs where CA7_JobsTriggeredByJobs.TriggeredBy_JobID = CA7_Jobs.jobID)\r\n\t\t       AND NOT EXISTS (SELECT   JobID FROM CA7_JobsTriggeredByJobs where CA7_JobsTriggeredByJobs.JobID = CA7_Jobs.jobID)) then 1 \r\n\t\telse (case when ( NOT EXISTS (SELECT  TriggeredBy_JobID FROM CA7_JobsTriggeredByJobs where CA7_JobsTriggeredByJobs.TriggeredBy_JobID = CA7_Jobs.jobID)\r\n       \t\tAND EXISTS (SELECT JobID FROM CA7_JobsTriggeredByJobs where CA7_JobsTriggeredByJobs.JobID = CA7_Jobs.jobID)) then 3 \r\n\t\telse 2\r\n\t\tend) \r\n\t\tend) \r\n\t\tend as jobtype\r\nfrom CA7_Jobs ";
    Map<Integer, ImageObj4Wizard> jobTypes;
    private String resourcesQuery;

    public List<CA7Job> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        this.resourcesQuery = ALL_CA7_JOBS_QUERY;
        ArrayList<CA7Job> jobList = new ArrayList<CA7Job>();
        try {
            String[][] results = conn.executeSQL(this.resourcesQuery);
            if (results != null && results.length > 0) {
                this.jobTypes = new TreeMap<Integer, ImageObj4Wizard>();
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    Integer jobID = Integer.valueOf(result[0]);
                    String jobName = result[1];
                    Integer jobType = Integer.valueOf(result[2]);
                    CA7Job job = new CA7Job(jobID, jobName, jobType);
                    jobList.add(job);
                    if (!this.jobTypes.containsKey(jobType)) {
                        String textType = job.getTypeText();
                        ImageDescriptor image_desc = job.getTypeImageDescriptor();
                        ImageObj4Wizard imageObj = new ImageObj4Wizard(jobType, textType, image_desc);
                        this.jobTypes.put(jobType, imageObj);
                    }
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return jobList;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        if (this.jobTypes != null) {
            return new ArrayList<ImageObj4Wizard>(this.jobTypes.values());
        }
        return null;
    }
}

