/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.ca7.wizard;

import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.graphs.ca7.model.CA7Job;
import com.ez.graphs.ca7.model.CA7JobSchidSg;
import com.ez.graphs.ca7.model.CA7Schid;
import com.ez.graphs.ca7.utils.CA7Utils;
import com.ez.graphs.ca7.wizard.CA7Wizard;
import com.ez.graphs.ca7.wizard.CA7WizardDialog;
import com.ez.graphs.ca7.wizard.collectors.CA7JobCollector;
import com.ez.graphs.ca7.wizard.collectors.CA7JobSchidCollector;
import com.ez.graphs.ca7.wizard.pages.ExportCSVPage;
import com.ez.graphs.ca7.wizard.pages.SchidWithGraphSettingsPage;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.filters.AbstractProjectInputsFilter;
import com.ez.mainframe.gui.wizard.SingleSelectionPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class CA7InputsFilter
extends AbstractProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Integer ca7JobId = null;
    private String ca7JobName = null;
    private boolean withJobPage = true;

    public CA7InputsFilter() {
    }

    public CA7InputsFilter(Integer ca7JobId, String ca7JobName) {
        this.ca7JobId = ca7JobId;
        this.ca7JobName = ca7JobName;
        if (ca7JobId != null) {
            this.withJobPage = false;
        }
    }

    protected PrepareReportWizard getWizard() {
        CA7Wizard wizard = new CA7Wizard();
        String wizardName = Messages.getString(CA7InputsFilter.class, (String)"ca7.wizard.title");
        wizard.setWindowTitle(wizardName);
        if (this.withJobPage) {
            if (CA7Utils.hasExportCsvOption()) {
                ExportCSVPage exportCsvPage = new ExportCSVPage("export ca7 graph in csv");
                wizard.addPage((IWizardPage)exportCsvPage);
                exportCsvPage.setTitle("export ca7 graph in csv");
            }
            String jobWizardPageTitle = Messages.getString(CA7InputsFilter.class, (String)"ca7.job.wizard.page.title");
            String jobWizardPageDescription = Messages.getString(CA7InputsFilter.class, (String)"ca7.job.wizard.page.description");
            SingleSelectionPage getJobSingleSelectionPage = new SingleSelectionPage("jobs elements for ca7 flow/path graph analysis page", true);
            getJobSingleSelectionPage.setLeftGroupLabel(Messages.getString(CA7InputsFilter.class, (String)"av.ca7.job.wizard.page.object.type"));
            getJobSingleSelectionPage.setErrMsgNoResource(Messages.getString(CA7InputsFilter.class, (String)"ca7.job.wizard.page.err.message"));
            getJobSingleSelectionPage.setTitle(jobWizardPageTitle);
            getJobSingleSelectionPage.setDescription(jobWizardPageDescription);
            getJobSingleSelectionPage.setSelectedPropName("selectedJob");
            getJobSingleSelectionPage.setAvailablePropName("availableJobs");
            CA7JobCollector jobCollector = new CA7JobCollector();
            getJobSingleSelectionPage.setResourcesCollector((ResourcesCollector)jobCollector);
            wizard.addPage((IWizardPage)getJobSingleSelectionPage);
        } else {
            wizard.set("INPUT_JOB_ID", this.ca7JobId);
        }
        String skidWizardPageTitle = Messages.getString(CA7InputsFilter.class, (String)"ca7.skid.wizard.page.title");
        String skidWizardPageDescription = Messages.getString(CA7InputsFilter.class, (String)"ca7.skid.wizard.page.description");
        SchidWithGraphSettingsPage getSchIDSingleSelectionPage = new SchidWithGraphSettingsPage("skid elements for ca7 flow/path graph analysis page", false, true);
        getSchIDSingleSelectionPage.setLeftGroupLabel(Messages.getString(CA7InputsFilter.class, (String)"av.ca7.skid.wizard.page.object.type"));
        getSchIDSingleSelectionPage.setErrMsgNoResource(Messages.getString(CA7InputsFilter.class, (String)"ca7.skid.wizard.page.err.message"));
        getSchIDSingleSelectionPage.setTitle(skidWizardPageTitle);
        getSchIDSingleSelectionPage.setDescription(skidWizardPageDescription);
        getSchIDSingleSelectionPage.setSelectedPropName("selectedSchID");
        getSchIDSingleSelectionPage.setAvailablePropName("availableSchIDs");
        CA7JobSchidCollector skidCollector = new CA7JobSchidCollector();
        skidCollector.setResourcesQuery("EZViewer_CA7_Get_Available_SCHID");
        getSchIDSingleSelectionPage.setResourcesCollector((ResourcesCollector)skidCollector);
        wizard.addPage((IWizardPage)getSchIDSingleSelectionPage);
        if (System.getProperty("test") != null) {
            SelectPathPage selectPathPage = new SelectPathPage("tests page");
            wizard.addPage((IWizardPage)selectPathPage);
        }
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) {
        Object path = analysis.getContextValue("selected path");
        if (CA7Utils.hasExportCsvOption() || path != null && !path.toString().trim().equals("")) {
            analysis.addContextValue("InternalEXportCSVOption", wizard.getValue("InternalEXportCSVOption"));
            List allJobIds = wizard.getList("availableJobs");
            analysis.addContextValue("availableJobs", (Object)allJobIds);
        }
        analysis.addContextValue("include external job dependencies", wizard.getValue("include external job dependencies"));
        analysis.addContextValue("include datasets", wizard.getValue("include datasets"));
        analysis.addContextValue("show job information", wizard.getValue("show job information"));
        analysis.addContextValue("Show job's system names", wizard.getValue("Show job's system names"));
        CA7Job ca7Job = null;
        if (this.withJobPage) {
            List selectedJobIds = wizard.getList("selectedJob");
            ca7Job = (CA7Job)((Object)selectedJobIds.get(0));
        } else {
            ca7Job = new CA7Job(this.ca7JobId, this.ca7JobName);
        }
        List selectedSchIds = wizard.getList("selectedSchID");
        if (ca7Job != null && selectedSchIds != null) {
            ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ProjectInfo projectName = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(projectName);
            Integer jobid = ca7Job.getJobId();
            Iterator iterator = selectedSchIds.iterator();
            if (iterator.hasNext()) {
                BaseResourceInput4GUI inpt = (BaseResourceInput4GUI)iterator.next();
                CA7Schid si = (CA7Schid)inpt.getObject();
                EZEntityID inp = new EZEntityID();
                inp.addSegment((EZSegment)prjIdSg);
                inp.addSegment((EZSegment)new CA7JobSchidSg(jobid, ca7Job.getName(), si.getName()));
                list.add(inp);
            }
            analysis.addContextValue("input_list", list);
            analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
        }
    }

    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        CA7WizardDialog dialog = new CA7WizardDialog(shell, (IWizard)wiz);
        return dialog;
    }
}

