/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.ca7.utils;

import com.ez.graphs.internal.Messages;
import com.ez.internal.analysis.config.inputs.EZJobCA7InputType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.model.segments.EZSourceJobCA7IDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CA7Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CA7Utils.class);
    public static final String JOB_ID_KEY = "Job_ID";
    public static final String TO_SCHID = "to_SCHID";
    public static final String DEP_SCHID = "dependency_SCHID";
    public static final String FROM_SCHID = "from_SCHID";
    private static final String ZERO_SCHID_VALUE_3FORMAT = "000";
    private static final String STRING_FORMAT_03D = "%03d";
    private static final String INFO_FOR_CSV_KEY = "info for csv";
    private static final String NEW_LINE = "\n";
    private static final String TXT_FILE_EXTENSION = ".txt";
    public static final Integer DEPENDENCY_TYPE_REGULAR = 0;
    public static final Integer DEPENDENCY_TYPE_NEGATIVE = 1;
    public static final Integer DEPENDENCY_TYPE_CONDITIONAL = 2;

    public static boolean isIncludeDS(EZAnalysis analysis) {
        return (Boolean)analysis.getContextValue("include datasets");
    }

    public static boolean isIncludeJobDep(EZAnalysis analysis) {
        return (Boolean)analysis.getContextValue("include external job dependencies");
    }

    public static boolean hasExportCsvOption() {
        return System.getProperty("ca7Location") != null;
    }

    public static boolean isExportAllGraphs(EZAnalysis analysis) {
        return CA7Utils.hasExportCsvOption() && "export all graphs".equals(analysis.getContextValue("InternalEXportCSVOption"));
    }

    public static boolean isExportCurrentGraph(EZAnalysis analysis) {
        return CA7Utils.hasExportCsvOption() && "export current graph".equals(analysis.getContextValue("InternalEXportCSVOption"));
    }

    public static boolean isShowSystemName(EZAnalysis analysis) {
        return (Boolean)analysis.getContextValue("Show job's system names");
    }

    public static boolean isShowJobInfo(EZAnalysis analysis) {
        return (Boolean)analysis.getContextValue("show job information");
    }

    public static void addContextValue(EZAnalysis analysis, String key, String suffix, Object results) {
        analysis.addContextValue(CA7Utils.getKey(key, suffix), results);
    }

    public static String getKey(String key, String suffix) {
        return suffix == null ? key : key.concat(suffix);
    }

    public static String replaceNegativeSchidValue(String schid) {
        int schidInt = Integer.parseInt(schid);
        return schidInt < 0 ? ZERO_SCHID_VALUE_3FORMAT : String.format(STRING_FORMAT_03D, schidInt);
    }

    public static TSEEdge createTriggerEdge(EZAnalysis analysis, TSEGraphManager graphManager, TSENode from, TSENode to, String fromSchid, String toSchid, TSEColor edgeColor) {
        TSEdgeBuilder edgeBuilder = graphManager.getEdgeBuilder();
        TSEEdge edge = edgeBuilder.addEdge(graphManager, from, to);
        String fromName = from.getText();
        String toName = to.getText();
        String tooltip = Messages.getString(CA7Utils.class, (String)"tooltip.from.to.schid", (Object[])new String[]{fromName, CA7Utils.replaceNegativeSchidValue(fromSchid), toName, CA7Utils.replaceNegativeSchidValue(toSchid)});
        edge.setTooltipText(tooltip);
        edge.setAttribute(FROM_SCHID, (Object)fromSchid);
        edge.setAttribute(TO_SCHID, (Object)toSchid);
        edge.setAttribute("Color", (Object)edgeColor);
        CA7Utils.computeEdgeInformation(analysis, edge);
        return edge;
    }

    public static TSEEdge createDependencyEdge(EZAnalysis analysis, TSEGraphManager graphManager, TSENode sourceTSNode, TSENode targetTSNode, String schid, TSEColor color) {
        TSEEdge edge = graphManager.getEdgeBuilder().addEdge(graphManager, sourceTSNode, targetTSNode);
        edge.setAttribute("Color", (Object)color);
        schid = CA7Utils.replaceNegativeSchidValue(schid);
        edge.setAttribute(DEP_SCHID, (Object)schid);
        String tooltip = Messages.getString(CA7Utils.class, (String)"tooltip.from.to", (Object[])new Object[]{sourceTSNode.getName(), targetTSNode.getName(), schid});
        edge.setTooltipText(tooltip);
        CA7Utils.computeEdgeInformation(analysis, edge);
        return edge;
    }

    public static void computeEdgeInformation(EZAnalysis analysis, TSEEdge edge) {
        TSNode from;
        if (!CA7Utils.isExportCurrentGraph(analysis) && !CA7Utils.isExportAllGraphs(analysis)) {
            return;
        }
        StringBuilder name = new StringBuilder();
        if (edge.hasAttribute(DEP_SCHID)) {
            from = edge.getSourceNode();
            String fromName = from.getText();
            String fromJobId = (String)from.getAttributeValue(JOB_ID_KEY);
            String fromSchid = (String)edge.getAttributeValue(DEP_SCHID);
            TSNode to = edge.getTargetNode();
            String toName = to.getText();
            name.append(fromName);
            name.append(",");
            name.append(toName);
            name.append(",");
            name.append(String.format(STRING_FORMAT_03D, Integer.parseInt(fromSchid)));
            name.append(",");
            if (fromJobId != null) {
                name.append(",depend job on job");
            } else {
                name.append(",dependent job on ds");
            }
        } else {
            from = edge.getSourceNode();
            String fromName = from.getText();
            String fromJobId = (String)from.getAttributeValue(JOB_ID_KEY);
            String fromSchid = CA7Utils.replaceNegativeSchidValue((String)edge.getAttributeValue(FROM_SCHID));
            TSNode to = edge.getTargetNode();
            String toName = to.getText();
            String toSchid = CA7Utils.replaceNegativeSchidValue((String)edge.getAttributeValue(TO_SCHID));
            name.append(fromName);
            name.append(",");
            name.append(toName);
            name.append(",");
            name.append(fromSchid);
            name.append(",");
            name.append(toSchid);
            if (fromJobId != null) {
                name.append(",trig job by job");
            } else {
                name.append(",trig job by ds");
            }
        }
        edge.setAttribute(INFO_FOR_CSV_KEY, (Object)name);
        TSEdgeLabel l = edge.addLabel();
        l.setName((Object)name);
    }

    public static void writeInFile(String jobAndSchid, TSEGraph graph) {
        block15: {
            String loc = System.getProperty("ca7Location");
            if (loc == null) {
                return;
            }
            String suffix = loc.concat(jobAndSchid).concat(TXT_FILE_EXTENSION);
            File file = new File(suffix);
            BufferedWriter bw = null;
            try {
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileWriter fw = new FileWriter(file.getAbsoluteFile());
                    bw = new BufferedWriter(fw);
                    List edges = graph.buildEdges();
                    for (TSEEdge edge : edges) {
                        if (!edge.hasAttribute(INFO_FOR_CSV_KEY)) continue;
                        bw.write(((StringBuilder)edge.getAttributeValue(INFO_FOR_CSV_KEY)).toString());
                        bw.write(NEW_LINE);
                    }
                }
                catch (Exception ex) {
                    L.error("could not write in file " + file, (Throwable)ex);
                    if (bw == null) break block15;
                    try {
                        bw.close();
                    }
                    catch (IOException ex1) {
                        L.error("can't close " + file, (Throwable)ex1);
                    }
                }
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException ex1) {
                        L.error("can't close " + file, (Throwable)ex1);
                    }
                }
            }
        }
    }

    public static void setTSJobAttributes(EZAnalysis analysis, TSENode tsNode, String[] result) {
        StringBuilder name = new StringBuilder(result[2]);
        if (CA7Utils.isShowSystemName(analysis) && Utils.filterNullValue((String)result[5]) != null) {
            name.append("[");
            name.append(result[5]);
            name.append("]");
        }
        if (CA7Utils.isShowJobInfo(analysis) && Utils.filterNullValue((String)result[6]) != null) {
            name.append(NEW_LINE);
            name.append(result[6]);
        }
        String jobName = result[2];
        tsNode.setName((Object)name.toString());
        EZJobCA7InputType inputType = null;
        EZSourceJobCA7IDSg jobSg = null;
        if (Utils.filterNullValue((String)result[3]) != null) {
            jobSg = new EZSourceJobIDSg(jobName, result[3], Integer.valueOf(22), result[4], result[2], Integer.valueOf(result[0]));
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22));
            ((EZSourceJobIDSg)jobSg).setDeleted(!"1".equals(result[8]));
        } else {
            jobSg = new EZSourceJobCA7IDSg(result[2], Integer.valueOf(result[0]), result[4]);
            inputType = new EZJobCA7InputType();
        }
        EZEntityID entID = new EZEntityID();
        entID.addSegment((EZSegment)analysis.getContextValue("ezsource prj sg"));
        entID.addSegment((EZSegment)jobSg);
        inputType.setEntID(entID);
        inputType.setName(jobName);
        tsNode.setAttribute("APPLICABLE_INPUT", (Object)inputType);
        String tooltip = Messages.getString(CA7Utils.class, (String)"job.lbl", (Object[])new String[]{result[2], result[5]});
        tsNode.setTooltipText(tooltip);
    }

    public static void addEntriesToLegend(AbstractAnalysisGraphModel graphModel, LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        if (uiStyle == 0) {
            com.ez.cobol.callgraph.utils.Utils.setImageProvider((LegendPanel)legend);
        }
        CA7Utils.addNodesToLegend(graphModel, legend, uiStyle);
        com.ez.cobol.callgraph.utils.Utils.setImageProvider((LegendPanel)legend);
        CA7Utils.addEdgesToLegend(graphModel, legend);
    }

    private static void addNodesToLegend(AbstractAnalysisGraphModel graphModel, LegendPanel legend, int uiStyle) {
        Set nodeTypesSetForLegend = graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<IGraphNodeLegendInfo>(){

            @Override
            public int compare(IGraphNodeLegendInfo nodeType1, IGraphNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (IGraphNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            String imagePath = null;
            if (uiStyle == 2) {
                imagePath = nodeLegendInfo.getLegendImagePath();
            } else if (uiStyle == 0) {
                imagePath = nodeLegendInfo.getColorboxImagePath();
            }
            legend.placeLegendEntry(imagePath, nodeLegendInfo.getLegendLabel());
        }
    }

    private static void addEdgesToLegend(AbstractAnalysisGraphModel graphModel, LegendPanel legend) {
        Set edgeTypesSetForLegend = graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<IGraphEdgeLegendInfo>(){

            @Override
            public int compare(IGraphEdgeLegendInfo edgeType1, IGraphEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (IGraphEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    public static enum Type {
        JCL_Scheduled,
        JCL_Start,
        JCL_End,
        JCL_Middle,
        DS;

    }
}

