/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.ca7.path;

import com.ez.graphs.ca7.model.CA7Job;
import com.ez.graphs.ca7.model.TriggerJobRelation;
import com.ez.graphs.ca7.path.CA7PathGraphAnalysis;
import com.ez.graphs.ca7.path.TSENodeComparator;
import com.ez.graphs.ca7.utils.CA7EdgeLegendInfo;
import com.ez.graphs.ca7.utils.CA7NodeLegendInfo;
import com.ez.graphs.ca7.utils.CA7Utils;
import com.ez.graphs.internal.Messages;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.Quartet;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.gui.properties.CA7JobNode;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.tomsawyer.canvas.TSViewportCanvas;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.interactive.TSInteractivePreferenceTailor;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.editing.TSBaseLayoutWorker;
import com.tomsawyer.interactive.command.editing.TSELayoutCommand;
import com.tomsawyer.interactive.command.editing.TSLayoutOperationCommand;
import com.tomsawyer.interactive.command.editing.TSSwingLayoutWorker;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.layout.TSLayoutInputTailor;
import images.LoadSVGImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CA7PathGraphModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CA7PathGraphModel.class);
    private static final String SEPARATOR = "_";
    private static final String LAYOUT_LEVEL = "LEVEL";
    private Map<Integer, List<TSENode>> tsNodeLevels = new HashMap<Integer, List<TSENode>>();
    private CA7PathGraphAnalysis analysis;
    private Map<String, String[]> jobDetails = new HashMap<String, String[]>();

    public CA7PathGraphModel(AnalysisGraphManager graphManager, AbstractSharedAnalysis analysis) {
        this.graphManager = graphManager;
        this.analysis = (CA7PathGraphAnalysis)analysis;
        this.initialize();
    }

    private void initialize() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
    }

    private void initGraph() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.tsNodeLevels.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    public void clear() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.tsNodeLevels.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    public void loadGraph(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        pmonitor.setTaskName(Messages.getString(CA7PathGraphModel.class, (String)"loading.graph"));
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        TSEdgeBuilder edgeBuilder = this.graphManager.getEdgeBuilder();
        this.graphManager.startBatchProcessing(true);
        this.jobDetails.clear();
        this.processJobDetails();
        pmonitor.worked(50);
        Object path = this.analysis.getContextValue("selected path");
        if (CA7Utils.isExportAllGraphs((EZAnalysis)this.analysis) || path != null && !path.toString().trim().equals("")) {
            List alljobs = this.analysis.getContextListValue("availableJobs");
            for (CA7Job job : alljobs) {
                String jobName = job.getJobName();
                Set schids = (Set)this.analysis.getContextValue("available schids per job".concat(jobName));
                for (String schid : schids) {
                    for (CA7Job lastjob : alljobs) {
                        String suffix = jobName.concat(SEPARATOR).concat(schid).concat(SEPARATOR).concat(lastjob.getName());
                        this.buildGraph(suffix, nodeBuilder, edgeBuilder, (IProgressMonitor)pmonitor);
                    }
                }
            }
        }
        this.buildGraph(null, nodeBuilder, edgeBuilder, (IProgressMonitor)pmonitor.newChild(140));
        if (CA7Utils.isExportCurrentGraph((EZAnalysis)this.analysis)) {
            String schid = (String)this.analysis.getContextValue("INPUT_SCHID");
            String jobName = (String)this.analysis.getContextValue("INPUT_JOB_NAME");
            String lastJobName = (String)this.analysis.getContextValue("SECOND_INPUT_JOB_NAME");
            String suffix = jobName.concat(SEPARATOR).concat(schid).concat(SEPARATOR).concat(lastJobName);
            CA7Utils.writeInFile(suffix, this.graph);
        }
        this.graphManager.endBatchProcessing();
        pmonitor.setWorkRemaining(0);
    }

    private void buildGraph(String suffix, TSNodeBuilder nodeBuilder, TSEdgeBuilder edgeBuilder, IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        pmonitor.setTaskName(Messages.getString(CA7PathGraphModel.class, (String)"initializing"));
        this.initGraph();
        HashMap<String, TSENode> nodes = new HashMap<String, TSENode>();
        pmonitor.setTaskName(Messages.getString(CA7PathGraphModel.class, (String)"loading.path.graph"));
        ArrayList pathResults = (ArrayList)this.analysis.getContextValue(CA7Utils.getKey("PATHS ANALYSIS PROCESSED JOBS", suffix));
        boolean export = false;
        if (pathResults == null) {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)NO_RESULTS_NODE_LABEL);
        } else {
            for (TriggerJobRelation relation : pathResults) {
                TSENode sNode = null;
                String sourceId = relation.getSourceJobId();
                sNode = this.getOrCreateJobTSNode(nodeBuilder, sourceId, nodes);
                String targetId = relation.getTargetJobId();
                if (targetId == null) continue;
                TSENode tNode = this.getOrCreateJobTSNode(nodeBuilder, targetId, nodes);
                String tschid = relation.getTschid();
                String sschid = relation.getSschid();
                Integer dependencyType = relation.getDependencyType();
                this.getOrCreateEdge(edgeBuilder, sNode, tNode, sschid, tschid, dependencyType);
                Integer ord = relation.getTsSourceLevel();
                this.addLevel(sNode, ord);
                this.addLevel(tNode, ord + 1);
                export = true;
            }
        }
        pmonitor.worked(100);
        if (export && suffix != null) {
            Object path = this.analysis.getContextValue("selected path");
            if (path != null && !path.toString().trim().equals("")) {
                this.writeGraphToFile(this.graph, suffix, path.toString());
            } else {
                CA7Utils.writeInFile(suffix, this.graph);
            }
        }
        pmonitor.setWorkRemaining(0);
    }

    private void processJobDetails() {
        String[][] jobsInfo = (String[][])this.analysis.getContextValue("JOB_INFORMATION");
        if (jobsInfo == null) {
            return;
        }
        String[][] stringArray = jobsInfo;
        int n = jobsInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String[] info = stringArray[n2];
            this.jobDetails.put(info[0], info);
            ++n2;
        }
    }

    public TSCommand createCustomHLayoutCommand(TSDGraph graph) {
        TSELayoutCommand layoutCommand = null;
        TSServiceInputData inputData = ((AnalysisGraphManager)this.graphManager).inputData;
        TSLayoutInputTailor inputTaylor = new TSLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraphManager)this.graphManager);
        Set<Integer> keys = this.tsNodeLevels.keySet();
        ArrayList<Integer> keysList = new ArrayList<Integer>(keys);
        Collections.sort(keysList);
        L.debug("levels: {}", keysList);
        int i = 0;
        while (i < keysList.size() - 1) {
            Integer pos1 = (Integer)keysList.get(i);
            List<TSENode> list1 = this.tsNodeLevels.get(pos1);
            Integer pos2 = (Integer)keysList.get(i + 1);
            List<TSENode> list2 = this.tsNodeLevels.get(pos2);
            double distance = 100.0;
            inputTaylor.addSeparationConstraint(list1, list2, 3, distance, 0);
            inputTaylor.addAlignmentConstraint(list1, 1, 0, 0);
            ++i;
        }
        TSSwingCanvas canvas = (TSSwingCanvas)this.graphManager.getCurrentCanvas();
        TSInteractivePreferenceTailor layoutPreferenceTailor = new TSInteractivePreferenceTailor(canvas.getPreferenceData());
        layoutPreferenceTailor.setThreadedLayout(true);
        layoutPreferenceTailor.setShowLayoutProgress(false);
        layoutCommand = new TSELayoutCommand((TSViewportCanvas)canvas, (TSServiceInputDataInterface)inputData, 1){

            protected TSBaseLayoutWorker createLayoutWorker() {
                return new TSSwingLayoutWorker((TSLayoutOperationCommand)this){

                    public void processEventsAfterLayout() {
                        L.debug("nothing to process after layout");
                    }
                };
            }
        };
        layoutCommand.setCoalesced(true);
        return layoutCommand;
    }

    private void addLevel(TSENode tNode, Integer ord) {
        if (tNode.hasAttribute(LAYOUT_LEVEL)) {
            return;
        }
        List<TSENode> nodes = this.tsNodeLevels.get(ord);
        if (nodes == null) {
            nodes = new ArrayList<TSENode>();
            this.tsNodeLevels.put(ord, nodes);
        }
        nodes.add(tNode);
        tNode.setAttribute(LAYOUT_LEVEL, (Object)ord);
    }

    private final TSENode getOrCreateJobTSNode(TSNodeBuilder nodeBuilder, String jobId, Map<String, TSENode> nodes) {
        TSENode tsNode = nodes.get(jobId);
        if (tsNode == null) {
            Quartet<String, CA7Utils.Type, String, String> ca7JobInformation = this.getCA7JobInformation(jobId);
            String name = (String)ca7JobInformation.getFirst();
            CA7Utils.Type type = (CA7Utils.Type)((Object)ca7JobInformation.getSecond());
            String nodeTypeName = (String)ca7JobInformation.getThird();
            String jobInfo = (String)ca7JobInformation.getFourth();
            tsNode = this.getOrCreateTSNode(nodeBuilder, jobId, nodes, type);
            tsNode.setAttribute("Job_ID", (Object)jobId);
            tsNode.setAttribute("Node_Mainframe", (Object)new CA7JobNode(name, nodeTypeName, jobInfo));
        }
        return tsNode;
    }

    private Quartet<String, CA7Utils.Type, String, String> getCA7JobInformation(String jobId) {
        String[] det = this.jobDetails.get(jobId);
        Quartet ca7JobPropertiesInfo = new Quartet();
        ca7JobPropertiesInfo.setFirst((Object)(det[2] == null ? "" : det[2]));
        ca7JobPropertiesInfo.setSecond((Object)CA7Utils.Type.JCL_Middle);
        ca7JobPropertiesInfo.setThird((Object)ResultElementType.JCL_JOB.getDisplayName());
        ca7JobPropertiesInfo.setFourth((Object)(det[6] == null ? "" : det[6]));
        Integer jobType = Integer.valueOf(det[7]);
        if (jobType == 0) {
            ca7JobPropertiesInfo.setSecond((Object)CA7Utils.Type.JCL_Scheduled);
            ca7JobPropertiesInfo.setThird((Object)ResultElementType.JCL_JOB.getDisplayName());
        } else if (1 == jobType) {
            ca7JobPropertiesInfo.setSecond((Object)CA7Utils.Type.JCL_Start);
            ca7JobPropertiesInfo.setThird((Object)ResultElementType.JCL_JOB.getDisplayName());
        } else if (3 == jobType) {
            ca7JobPropertiesInfo.setSecond((Object)CA7Utils.Type.JCL_End);
            ca7JobPropertiesInfo.setThird((Object)ResultElementType.JCL_JOB.getDisplayName());
        }
        return ca7JobPropertiesInfo;
    }

    private final TSENode getOrCreateTSNode(TSNodeBuilder nodeBuilder, String nameOrId, Map<String, TSENode> nodes, CA7Utils.Type type) {
        TSENode tsNode = nodes.get(nameOrId);
        if (tsNode == null) {
            tsNode = nodeBuilder.addNode(this.graph);
            String[] det = this.jobDetails.get(nameOrId);
            CA7Utils.setTSJobAttributes((EZAnalysis)this.analysis, tsNode, det);
            nodes.put(nameOrId, tsNode);
            this.setUIAttributes(tsNode, type);
        }
        return tsNode;
    }

    private void setUIAttributes(TSENode tsNode, CA7Utils.Type type) {
        TSESVGImage image = null;
        String graphInventoryLbl = null;
        TSEColor fillColor = null;
        Object txtColor = null;
        switch (type) {
            case JCL_Scheduled: {
                image = LoadTSESVGImage.loadImage(LoadSVGImage.class, (String)CA7NodeLegendInfo.SCHEDULED_JOB.getGraphImagePath());
                fillColor = CA7NodeLegendInfo.SCHEDULED_JOB.getTSEColor();
                graphInventoryLbl = CA7NodeLegendInfo.SCHEDULED_JOB.getLegendLabel();
                this.nodeTypesSetForLegend.add(CA7NodeLegendInfo.SCHEDULED_JOB);
                break;
            }
            case JCL_Start: {
                image = LoadTSESVGImage.loadImage(LoadSVGImage.class, (String)CA7NodeLegendInfo.START_JOB.getGraphImagePath());
                fillColor = CA7NodeLegendInfo.START_JOB.getTSEColor();
                graphInventoryLbl = CA7NodeLegendInfo.START_JOB.getLegendLabel();
                this.nodeTypesSetForLegend.add(CA7NodeLegendInfo.START_JOB);
                break;
            }
            case JCL_End: {
                image = LoadTSESVGImage.loadImage(LoadSVGImage.class, (String)CA7NodeLegendInfo.END_JOB.getGraphImagePath());
                fillColor = CA7NodeLegendInfo.END_JOB.getTSEColor();
                graphInventoryLbl = CA7NodeLegendInfo.END_JOB.getLegendLabel();
                this.nodeTypesSetForLegend.add(CA7NodeLegendInfo.END_JOB);
                break;
            }
            case JCL_Middle: {
                image = LoadTSESVGImage.loadImage(LoadSVGImage.class, (String)CA7NodeLegendInfo.MIDDLE_JOB.getGraphImagePath());
                fillColor = CA7NodeLegendInfo.MIDDLE_JOB.getTSEColor();
                graphInventoryLbl = CA7NodeLegendInfo.MIDDLE_JOB.getLegendLabel();
                this.nodeTypesSetForLegend.add(CA7NodeLegendInfo.MIDDLE_JOB);
                break;
            }
            case DS: {
                image = LoadTSESVGImage.loadImage(LoadSVGImage.class, (String)CA7NodeLegendInfo.DATASET.getGraphImagePath());
                fillColor = CA7NodeLegendInfo.DATASET.getTSEColor();
                txtColor = null;
                graphInventoryLbl = CA7NodeLegendInfo.DATASET.getLegendLabel();
                this.nodeTypesSetForLegend.add(CA7NodeLegendInfo.DATASET);
            }
        }
        tsNode.setAttribute("uiImage", image);
        this.setNodeUI(tsNode, fillColor, txtColor);
        this.putEntryInGraphInventory(graphInventoryLbl, tsNode);
    }

    private TSEEdge getOrCreateEdge(TSEdgeBuilder edgeBuilder, TSENode from, TSENode to, String fromSchid, String toSchid, Integer dependencyType) {
        TSEEdge edge = null;
        List outs = from.outEdges();
        for (TSEEdge ed : outs) {
            if (!ed.getTargetNode().equals(to)) continue;
            edge = ed;
            break;
        }
        if (edge == null) {
            TSEColor edgeColor = TSEColor.red;
            if (CA7Utils.DEPENDENCY_TYPE_CONDITIONAL == dependencyType) {
                edgeColor = TSEColor.green;
                edge = CA7Utils.createDependencyEdge((EZAnalysis)this.analysis, this.graphManager, from, to, fromSchid, edgeColor);
                this.edgeTypesSetForLegend.add(CA7EdgeLegendInfo.CONDITIONAL_DEPENDENCY);
            } else if (CA7Utils.DEPENDENCY_TYPE_REGULAR == dependencyType || CA7Utils.DEPENDENCY_TYPE_NEGATIVE == dependencyType) {
                edgeColor = TSEColor.blue;
                edge = CA7Utils.createDependencyEdge((EZAnalysis)this.analysis, this.graphManager, from, to, fromSchid, edgeColor);
                this.edgeTypesSetForLegend.add(CA7EdgeLegendInfo.DEPENDENCY);
            } else {
                edge = CA7Utils.createTriggerEdge((EZAnalysis)this.analysis, this.graphManager, from, to, fromSchid, toSchid, edgeColor);
                this.edgeTypesSetForLegend.add(CA7EdgeLegendInfo.TRIGGER);
            }
        }
        return edge;
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
        }
        if (node.hasAttribute("node is input for callgraph")) {
            node.setAttribute("Text_Color", (Object)TSEColor.blue);
        }
    }

    public void setNodeUI(TSENode node, TSEColor fillColor, TSEColor textColor) {
        node.setAttribute("Fill_Color", (Object)fillColor);
        if (textColor != null) {
            node.setAttribute("Color", (Object)textColor);
            if ("!svg".equals(node.getAttributeValue("uiStyle"))) {
                node.setAttribute("Text_Color", (Object)textColor);
            }
        }
        this.setNodeUI(node);
    }

    public void updateDrawing() {
        TSDGraph hide;
        super.updateDrawing();
        List nodes = this.graph.nodes();
        if (nodes != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
        if ((hide = this.graph.hideOrHideFromGraph) != null && (nodes = hide.nodes()) != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    private void putEntryInGraphInventory(String lbl, TSENode node) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(lbl);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(lbl, nodes);
        }
        nodes.add(node);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        if (gNode != null && gNode.hasAttribute("APPLICABLE_INPUT")) {
            objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
        }
        return objType;
    }

    public void writeGraphToFile(TSEGraph graph, String fileName, String pathSelected) {
        block9: {
            String pathToWrite = String.valueOf(pathSelected) + "/" + fileName + ".txt";
            String newLine = System.getProperty("line.separator");
            try {
                File file;
                if (System.getProperty("test").trim().equals("")) break block9;
                boolean found = false;
                File firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        File f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                FileWriter fw = new FileWriter(file, true);
                fw.write("Program name : " + fileName);
                fw.write(newLine);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
                List graphNodes = graph.nodes();
                TSENodeComparator comparator = new TSENodeComparator();
                Collections.sort(graphNodes, comparator);
                for (TSENode node : graphNodes) {
                    String name = node.getText();
                    node.getAttributeNames();
                    fw.write(newLine);
                    fw.write(name);
                    for (Object allAttrNames : node.getAttributeNames()) {
                        if (allAttrNames.toString().equals("FILE")) {
                            Set locations = (Set)node.getAttributeValue("FILE");
                            if (locations == null) continue;
                            for (TextSelectionInFile tsf : locations) {
                                fw.write(newLine);
                                fw.write("File name :" + tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                                fw.write(newLine);
                                fw.write("Program type :" + tsf.getPrgType());
                                fw.write(newLine);
                            }
                            continue;
                        }
                        if (allAttrNames.toString().trim().equals("ScreenOccurId Attribute") || allAttrNames.toString().trim().equals("ScreenID attribute") || allAttrNames.toString().trim().equals("Node_Mainframe") || allAttrNames.toString().trim().equals("Bounds") || allAttrNames.toString().trim().equals("JCL to programs") || allAttrNames.toString().trim().equals("Sources") || allAttrNames.toString().trim().equals("APPLICABLE_INPUT")) continue;
                        fw.write(newLine);
                        fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                    }
                    List inEdges = node.inEdges();
                    fw.write(newLine);
                    fw.write(newLine);
                    fw.write("The in edges :");
                    this.writeEdge(inEdges, node, fw);
                    List outEdges = node.outEdges();
                    fw.write(newLine);
                    fw.write("The out edges :");
                    this.writeEdge(outEdges, node, fw);
                    fw.write(newLine);
                }
                fw.close();
            }
            catch (IOException iOException) {
                L.error("Couldn't write to file");
            }
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        TreeSet<String> listToWrite = new TreeSet<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = "";
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = "";
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    Collections.sort(fileAttrToWrite);
                    for (TextSelectionInFile textLine : textAttr) {
                        fileAttrToWrite.add("\t\tProgram " + textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1) + " of type " + textLine.getPrgType());
                    }
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                if (stmtType != null && !stmtType.isEmpty()) {
                    value.append("Statement Type: ");
                    value.append(stmtType);
                }
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }
}

