/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.ca7.path;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.common.ui.ImageDescriptorProvider;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.ParameterDirection;
import com.ez.ezdao.api.ParameterInfo;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.graphs.ca7.flow.CA7GraphAnalysisJob;
import com.ez.graphs.ca7.model.CA7Job;
import com.ez.graphs.ca7.model.CA7JobSchidSg;
import com.ez.graphs.ca7.model.TriggerJobRelation;
import com.ez.graphs.ca7.path.CA7PathGraphModel;
import com.ez.graphs.ca7.utils.CA7Utils;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.Activator;
import com.ez.graphs.viewer.utils.GraphsErrorLog;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CA7PathGraphAnalysisJob
extends GraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CA7PathGraphAnalysisJob.class);
    private MainframeMouseActionsHook mouseActionsHook = null;
    private static final String CA7_GET_ALL_PATHS_SP_NAME = "EZViewer_CA7_AllPathsBetween";
    private static final String SEPARATOR_ = "_";

    public CA7PathGraphAnalysisJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new MainframeMouseActionsHook(id);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new CA7GraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.graphModel = new CA7PathGraphModel(new AnalysisGraphManager(), this.analysis);
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        L.debug("ca7 graph - computeResults");
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(CA7PathGraphAnalysisJob.class, (String)"collectingData.taskName"));
        this.processInputs((IProgressMonitor)pmonitor.newChild(100));
        pmonitor.setWorkRemaining(0);
    }

    private void processInputs(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(CA7PathGraphAnalysisJob.class, (String)"process.input.taskName"));
        List inputs = this.analysis.getContextListValue("input_list");
        EZEntityID entity = (EZEntityID)inputs.get(0);
        List segments = entity.getSegments();
        CA7JobSchidSg firstCA7Sg = null;
        CA7JobSchidSg lastCA7Sg = null;
        for (EZSegment seg : segments) {
            if (!seg.isOfType(CA7JobSchidSg.class)) continue;
            if (firstCA7Sg == null) {
                firstCA7Sg = (CA7JobSchidSg)seg;
                continue;
            }
            lastCA7Sg = (CA7JobSchidSg)seg;
            break;
        }
        final Integer firstJobId = firstCA7Sg.getJobId();
        String firstScheduler = firstCA7Sg.getSchedulerId();
        final Integer firstSchedulerId = Integer.valueOf(firstScheduler);
        final Integer lastJobId = lastCA7Sg.getJobId();
        this.analysis.addContextValue("INPUT_SCHID", (Object)firstScheduler);
        this.analysis.addContextValue("INPUT_JOB_NAME", (Object)firstCA7Sg.getJobName());
        this.analysis.addContextValue("SECOND_INPUT_JOB_NAME", (Object)lastCA7Sg.getJobName());
        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
        this.analysis.addContextValue("ezsource prj sg", (Object)prjSg);
        pmonitor.worked(30);
        String prjName = prjSg.getProjectName();
        try {
            L.debug("will open project {}", (Object)prjName);
            IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = service.getProjectHandler(prjName, null);
            if (!pmonitor.isCanceled()) {
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pmonitor, (int)200);
                        if (!sm.isCanceled()) {
                            Set jobIds = CA7PathGraphAnalysisJob.this.computeDBResults(conn, firstJobId, firstSchedulerId, lastJobId, null, sm.newChild(100));
                            sm.setTaskName(Messages.getString(CA7GraphAnalysisJob.class, (String)"compute.job.details.taskName"));
                            CA7PathGraphAnalysisJob.this.computeJobsDetails(conn, jobIds, sm.newChild(100));
                            Object path = CA7PathGraphAnalysisJob.this.analysis.getContextValue("selected path");
                            if (!sm.isCanceled() && (CA7Utils.isExportAllGraphs((EZAnalysis)CA7PathGraphAnalysisJob.this.analysis) || path != null && !path.toString().trim().equals(""))) {
                                sm.setTaskName("computing information for export in csv");
                                List alljobs = CA7PathGraphAnalysisJob.this.analysis.getContextListValue("availableJobs");
                                HashSet<Integer> allJobSet = new HashSet<Integer>();
                                for (CA7Job job : alljobs) {
                                    Integer jobId = job.getJobId();
                                    Object[] param = new Object[]{jobId};
                                    String[][] schids = Utils.runStoredProcedure((EZSourceConnection)conn, (String)"EZViewer_CA7_Path_Available_SCHID", (Object[])param, null, null, (IProgressMonitor)sm);
                                    HashSet<String> schidPerJob = new HashSet<String>();
                                    if (schids != null && schids.length > 0) {
                                        String[][] stringArray = schids;
                                        int n = schids.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String[] res = stringArray[n2];
                                            String sch = res[0];
                                            for (CA7Job lastJob : alljobs) {
                                                String suffix = job.getJobName().concat(CA7PathGraphAnalysisJob.SEPARATOR_).concat(sch).concat(CA7PathGraphAnalysisJob.SEPARATOR_).concat(lastJob.getJobName());
                                                Integer lastjobIdStr = lastJob.getJobId();
                                                CA7PathGraphAnalysisJob.this.computeDBResults(conn, jobId, Integer.valueOf(sch), lastjobIdStr, suffix, sm);
                                            }
                                            schidPerJob.add(sch);
                                            ++n2;
                                        }
                                    }
                                    CA7Utils.addContextValue((EZAnalysis)CA7PathGraphAnalysisJob.this.analysis, "available schids per job", job.getJobName(), schidPerJob);
                                    allJobSet.add(jobId);
                                }
                                CA7PathGraphAnalysisJob.this.computeJobsDetails(conn, allJobSet, sm);
                            }
                        }
                    }
                }, LockType.Shared, (IProgressMonitor)pmonitor.newChild(70));
            }
        }
        catch (Exception e) {
            L.error("while computing results", (Throwable)e);
            GraphsErrorLog.err((String)e.getMessage(), (Throwable)e);
        }
        pmonitor.setWorkRemaining(0);
    }

    private Set<Integer> computeDBResults(EZSourceConnection conn, Integer firstJobId, Integer firstSchedulerId, Integer lastJobId, String suffix, SubMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(CA7PathGraphAnalysisJob.class, (String)"compute.paths.taskName"));
        HashSet<Integer> jobIds = new HashSet<Integer>();
        ParameterInfo[] pInfo = new ParameterInfo[]{ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4)};
        Object[] objectArray = new Object[4];
        objectArray[0] = firstJobId;
        objectArray[1] = lastJobId;
        objectArray[2] = firstSchedulerId;
        Object[] params = objectArray;
        String[][] pathResults = com.ez.mainframe.data.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)CA7_GET_ALL_PATHS_SP_NAME, (Object[])params, (ParameterInfo[])pInfo, null, null, (IProgressMonitor)pmonitor.newChild(100));
        pmonitor.worked(70);
        if (pathResults != null) {
            ArrayList<TriggerJobRelation> pathTriggers = new ArrayList<TriggerJobRelation>();
            String[][] stringArray = pathResults;
            int n = pathResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                String sourceId = result[1];
                String targetId = result[2];
                Integer targetIdInt = Integer.valueOf(targetId);
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)sourceId) != null) {
                    Integer sourceIdInt = Integer.valueOf(sourceId);
                    Integer dependencyType = com.ez.mainframe.data.utils.Utils.filterNullValue((String)result[6]) != null ? Integer.valueOf(Integer.parseInt(result[6])) : null;
                    pathTriggers.add(new TriggerJobRelation(sourceId, targetId, result[4], result[5], (Integer)(Integer.parseInt(result[3]) + 1), dependencyType));
                    jobIds.add(sourceIdInt);
                    jobIds.add(targetIdInt);
                } else {
                    pathTriggers.add(new TriggerJobRelation(targetId));
                    jobIds.add(targetIdInt);
                }
                ++n2;
            }
            CA7Utils.addContextValue((EZAnalysis)this.analysis, "PATHS ANALYSIS PROCESSED JOBS", suffix, pathTriggers);
        } else {
            L.debug("no results for all path analysis");
        }
        pmonitor.setWorkRemaining(0);
        return jobIds;
    }

    private void computeJobsDetails(EZSourceConnection conn, Set<Integer> jobIds, SubMonitor monitor) {
        if (jobIds.isEmpty()) {
            return;
        }
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        Object[] procParam = new Integer[]{1};
        String[][] jobInfoResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)"EZViewer_CA7_JobsInfo_Selective", (Object[])procParam, jobIds, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(10));
        this.analysis.addContextValue("JOB_INFORMATION", (Object)jobInfoResults);
        pmonitor.setWorkRemaining(0);
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSCommand layoutCommand = null;
        switch (type) {
            case 1: {
                L.debug("do specific constraints layout");
                layoutCommand = ((CA7PathGraphModel)this.graphModel).createCustomHLayoutCommand((TSDGraph)graph);
                break;
            }
            default: {
                layoutCommand = super.doLayout(type, graph);
            }
        }
        return layoutCommand;
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        monitor.setTaskName(Messages.getString(CA7PathGraphAnalysisJob.class, (String)"dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)pmonitor.newChild(50), result);
        if (this.gfi != null) {
            HashSet allNodes = new HashSet();
            Collection nodesSetsList = this.graphModel.getOutForStructView().values();
            for (Set nodesSet : nodesSetsList) {
                allNodes.addAll(nodesSet);
            }
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        pmonitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    private void addFilters(GraphFilterInfo gfi) {
    }

    class CA7GraphInfo
    extends GraphInfoAdapter {
        GraphFilterInfo gfi;
        String tabName;

        public CA7GraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor((String)"icons/ca7.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            ProjectInfo ezsourcePrj = (ProjectInfo)CA7PathGraphAnalysisJob.this.analysis.getContextValue("PROJECT_INFO");
            StringBuilder sb = new StringBuilder();
            String schid4Print = null;
            Object schid = CA7PathGraphAnalysisJob.this.analysis.getContextValue("selectedSchID");
            if (schid != null) {
                schid4Print = ((BaseMainframeResource4GUI)((List)schid).get(0)).getObject().getListableName();
            } else {
                schid = CA7PathGraphAnalysisJob.this.analysis.getContextValue("INPUT_SCHID");
                schid4Print = schid.toString();
            }
            String jobName = (String)CA7PathGraphAnalysisJob.this.analysis.getContextValue("INPUT_JOB_NAME");
            String lastjobName = (String)CA7PathGraphAnalysisJob.this.analysis.getContextValue("SECOND_INPUT_JOB_NAME");
            if (jobName != null && schid != null) {
                sb.append(Messages.getString(CA7PathGraphAnalysisJob.class, (String)"path.job.schid", (Object[])new Object[]{jobName, lastjobName, schid4Print}));
            }
            sb.append(Messages.getString(CA7PathGraphAnalysisJob.class, (String)"tab.lbl", (Object[])new String[]{ezsourcePrj.getName()}));
            this.tabName = sb.toString();
            return this.tabName;
        }

        public String getTooltip() {
            StringBuffer buf = new StringBuffer(this.tabName);
            return buf.toString();
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    CA7PathGraphAnalysisJob.this.legend = new LegendPanel((Composite)sc, 0);
                    CA7PathGraphAnalysisJob.this.legend.setImageDescriptorProvider(new ImageDescriptorProvider(){

                        public ImageDescriptor getImageDescriptor(String image) {
                            return Activator.getImageDescriptor((String)image);
                        }
                    });
                    int uiStyle = CA7PathGraphAnalysisJob.this.graphModel.getUIStyle();
                    CA7Utils.addEntriesToLegend(CA7PathGraphAnalysisJob.this.graphModel, CA7PathGraphAnalysisJob.this.legend, uiStyle, CA7GraphInfo.this.gfi);
                    sc.setContent((Control)CA7PathGraphAnalysisJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    CA7PathGraphAnalysisJob.this.legend.pack();
                    sc.setMinSize(CA7PathGraphAnalysisJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((CA7PathGraphAnalysisJob)((CA7GraphInfo)CA7GraphInfo.this).CA7PathGraphAnalysisJob.this).legend.getSize().x;
                    int x = ((CA7PathGraphAnalysisJob)((CA7GraphInfo)CA7GraphInfo.this).CA7PathGraphAnalysisJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }
    }
}

