/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.ca7.model;

public class TriggerJobRelation {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String sourceJobIdOrDS;
    private boolean isDSTrigger = false;
    private String targetJobId;
    private String sschid;
    private String tschid;
    private Integer tsSourceLevel;
    private Integer dependencyType;

    public TriggerJobRelation(String sourceJobId) {
        this.sourceJobIdOrDS = sourceJobId;
    }

    public TriggerJobRelation(String sourceJobIdOrDS, String targetJobId, String sschid, String tschid, Integer tsSourceLevel) {
        this(sourceJobIdOrDS);
        this.targetJobId = targetJobId;
        this.sschid = sschid;
        this.tschid = tschid;
        this.tsSourceLevel = tsSourceLevel;
    }

    public TriggerJobRelation(String sourceJobIdOrDS, String targetJobId, String sschid, String tschid, Integer tsSourceLevel, int dependencyType) {
        this(sourceJobIdOrDS, targetJobId, sschid, tschid, tsSourceLevel);
        this.dependencyType = dependencyType;
    }

    public TriggerJobRelation(String sourceJobIdOrDS, String targetJobId, String sschid, String tschid, Integer tsSourceLevel, boolean isDsTrigger) {
        this(sourceJobIdOrDS, targetJobId, sschid, tschid, tsSourceLevel);
        this.isDSTrigger = isDsTrigger;
    }

    public String getSourceJobId() {
        return this.isDSTrigger ? null : this.sourceJobIdOrDS;
    }

    public String getDS() {
        return this.isDSTrigger ? this.sourceJobIdOrDS : null;
    }

    public String getTargetJobId() {
        return this.targetJobId;
    }

    public String getSschid() {
        return this.sschid;
    }

    public String getTschid() {
        return this.tschid;
    }

    public Integer getTsSourceLevel() {
        return this.tsSourceLevel;
    }

    public boolean isDSTrigger() {
        return this.isDSTrigger;
    }

    public Integer getDependencyType() {
        return this.dependencyType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.sourceJobIdOrDS == null ? 0 : this.sourceJobIdOrDS.hashCode());
        result = 31 * result + (this.sschid == null ? 0 : this.sschid.hashCode());
        result = 31 * result + (this.targetJobId == null ? 0 : this.targetJobId.hashCode());
        result = 31 * result + (this.tschid == null ? 0 : this.tschid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TriggerJobRelation other = (TriggerJobRelation)obj;
        if (this.sourceJobIdOrDS == null ? other.sourceJobIdOrDS != null : !this.sourceJobIdOrDS.equals(other.sourceJobIdOrDS)) {
            return false;
        }
        if (this.sschid == null ? other.sschid != null : !this.sschid.equals(other.sschid)) {
            return false;
        }
        if (this.targetJobId == null ? other.targetJobId != null : !this.targetJobId.equals(other.targetJobId)) {
            return false;
        }
        return !(this.tschid == null ? other.tschid != null : !this.tschid.equals(other.tschid));
    }
}

