/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.ca7.flow;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.common.ui.ImageDescriptorProvider;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.ParameterDirection;
import com.ez.ezdao.api.ParameterInfo;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.graphs.ca7.flow.CA7GraphModel;
import com.ez.graphs.ca7.model.CA7Job;
import com.ez.graphs.ca7.model.CA7JobSchidSg;
import com.ez.graphs.ca7.model.TriggerJobRelation;
import com.ez.graphs.ca7.utils.CA7Utils;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.Activator;
import com.ez.graphs.viewer.utils.GraphsErrorLog;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CA7GraphAnalysisJob
extends GraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CA7GraphAnalysisJob.class);
    private MainframeMouseActionsHook mouseActionsHook = null;
    private static final String CA7_GET_GRAPH_FORWARD_SP_NAME = "EZViewer_CA7_Get_Graph_Forward";
    private static final String CA7_GET_JOBS_DEPENDENT_ON_DATASETS_SELECTIVE_SP_NAME = "EZViewer_CA7_Get_JobsDependentOnDatasets_Selective";
    private static final String CA7_GET_JOBS_DEPENDENT_ON_JOBS_SELECTIVE_SP_NAME = "EZViewer_CA7_Get_JobsDependentOnJobs_Selective";
    private static final String CA7_GET_GRAPH_BACKWARD_SP_NAME = "EZViewer_CA7_Get_Graph_Backward";

    public CA7GraphAnalysisJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new MainframeMouseActionsHook(id);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new CA7GraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.graphModel = new CA7GraphModel(new AnalysisGraphManager(), this.analysis);
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        L.debug("ca7 graph - computeResults");
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(CA7GraphAnalysisJob.class, (String)"collectingData.taskName"));
        this.processInputs((IProgressMonitor)pmonitor.newChild(100));
        pmonitor.setWorkRemaining(0);
    }

    private void processInputs(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        pmonitor.setTaskName(Messages.getString(CA7GraphAnalysisJob.class, (String)"compute.taskName"));
        List inputs = this.analysis.getContextListValue("input_list");
        EZEntityID entity = (EZEntityID)inputs.get(0);
        CA7JobSchidSg ca7Sg = (CA7JobSchidSg)entity.getSegment(CA7JobSchidSg.class);
        final Integer jobId = ca7Sg.getJobId();
        String schedulerId = ca7Sg.getSchedulerId();
        final Integer schedulerIdInt = Integer.valueOf(schedulerId);
        this.analysis.addContextValue("INPUT_SCHID", (Object)schedulerId);
        this.analysis.addContextValue("INPUT_JOB_NAME", (Object)ca7Sg.getJobName());
        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
        this.analysis.addContextValue("ezsource prj sg", (Object)prjSg);
        String prjName = prjSg.getProjectName();
        try {
            L.debug("will open project {}", (Object)prjName);
            IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = service.getProjectHandler(prjName, null);
            if (!pmonitor.isCanceled()) {
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pmonitor, (int)200);
                        if (!sm.isCanceled()) {
                            Set jobIds = CA7GraphAnalysisJob.this.computeDBResults(conn, jobId, schedulerIdInt, null, sm.newChild(100));
                            sm.setTaskName(Messages.getString(CA7GraphAnalysisJob.class, (String)"compute.job.details.taskName"));
                            CA7GraphAnalysisJob.this.computeJobsDetails(conn, jobIds, sm.newChild(100));
                            Object path = CA7GraphAnalysisJob.this.analysis.getContextValue("selected path");
                            if (!sm.isCanceled() && (CA7Utils.isExportAllGraphs((EZAnalysis)CA7GraphAnalysisJob.this.analysis) || path != null && !path.toString().trim().equals(""))) {
                                sm.setTaskName("computing information for export in csv");
                                List alljobs = CA7GraphAnalysisJob.this.analysis.getContextListValue("availableJobs");
                                HashSet<Integer> allJobSet = new HashSet<Integer>();
                                for (CA7Job job : alljobs) {
                                    Integer jobId2 = job.getJobId();
                                    ParameterInfo[] pInfo = new ParameterInfo[]{ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4)};
                                    Object[] objectArray = new Object[2];
                                    objectArray[0] = jobId2;
                                    Object[] param = objectArray;
                                    String[][] schids = com.ez.mainframe.data.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)"EZViewer_CA7_Get_Available_SCHID", (Object[])param, (ParameterInfo[])pInfo, null, null, (IProgressMonitor)sm);
                                    HashSet<String> schidPerJob = new HashSet<String>();
                                    if (schids != null && schids.length > 0) {
                                        String[][] stringArray = schids;
                                        int n = schids.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String[] res = stringArray[n2];
                                            String sch = res[0];
                                            String suffix = job.getJobName().concat("_").concat(sch);
                                            CA7GraphAnalysisJob.this.computeDBResults(conn, jobId2, Integer.valueOf(sch), suffix, sm);
                                            schidPerJob.add(sch);
                                            ++n2;
                                        }
                                    }
                                    CA7Utils.addContextValue((EZAnalysis)CA7GraphAnalysisJob.this.analysis, "available schids per job", job.getJobName(), schidPerJob);
                                    allJobSet.add(jobId2);
                                }
                                CA7GraphAnalysisJob.this.computeJobsDetails(conn, allJobSet, sm);
                            }
                        }
                    }
                }, LockType.Shared, (IProgressMonitor)pmonitor.newChild(30));
            }
        }
        catch (Exception e) {
            L.error("while computing results", (Throwable)e);
            GraphsErrorLog.err((String)e.getMessage(), (Throwable)e);
        }
        pmonitor.setWorkRemaining(0);
    }

    private Set<Integer> computeDBResults(EZSourceConnection conn, Integer jobId, Integer schedulerId, String suffix, SubMonitor monitor) {
        Object result;
        int n;
        String[][] stringArray;
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        Object[] objectArray = new Object[3];
        objectArray[0] = jobId;
        objectArray[1] = schedulerId;
        Object[] params = objectArray;
        ParameterInfo[] paramInfo = new ParameterInfo[]{ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4)};
        pmonitor.setTaskName(Messages.getString(CA7GraphAnalysisJob.class, (String)"compute.backward.taskName"));
        String[][] backwardResults = com.ez.mainframe.data.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)CA7_GET_GRAPH_BACKWARD_SP_NAME, (Object[])params, (ParameterInfo[])paramInfo, null, null, (IProgressMonitor)pmonitor.newChild(100));
        pmonitor.setTaskName(Messages.getString(CA7GraphAnalysisJob.class, (String)"compute.forward.taskName"));
        HashSet<Integer> jobIds = new HashSet<Integer>();
        jobIds.add(jobId);
        ArrayList<TriggerJobRelation> backTriggered = new ArrayList<TriggerJobRelation>();
        HashSet<String> schids = new HashSet<String>();
        boolean wasComputeForward = false;
        if (backwardResults != null) {
            boolean skip = true;
            stringArray = backwardResults;
            n = backwardResults.length;
            int n2 = 0;
            while (n2 < n) {
                Object targetId;
                result = stringArray[n2];
                String dsn = result[6];
                Object sourceId = result[1];
                Integer sourceIdInt = Integer.valueOf((String)sourceId);
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)dsn) != null) {
                    Object indsn = result[7];
                    Object outdsn = result[8];
                    backTriggered.add(new TriggerJobRelation(dsn, (String)sourceId, (String)indsn, (String)outdsn, (Integer)(Integer.parseInt((String)result[3]) + 1), true));
                    if (jobId.equals(sourceIdInt) && com.ez.mainframe.data.utils.Utils.filterNullValue((String)outdsn) != null && !schids.contains(outdsn)) {
                        Object[] objectArray2 = new Integer[3];
                        objectArray2[0] = sourceIdInt;
                        objectArray2[1] = Integer.valueOf((String)outdsn);
                        Object[] localparams = objectArray2;
                        this.computeForward(conn, (String)outdsn, localparams, paramInfo, schids, suffix, pmonitor.newChild(100));
                        wasComputeForward = true;
                    }
                    skip = false;
                }
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)(targetId = result[2])) == null) {
                    skip = true;
                    backTriggered.add(new TriggerJobRelation((String)result[1]));
                } else {
                    Integer targetIdInt = Integer.valueOf((String)targetId);
                    Object sschid = result[4];
                    int sschidIntValue = Integer.parseInt((String)sschid);
                    if (sschidIntValue < 0) {
                        sschidIntValue = -sschidIntValue;
                    }
                    if (!skip || schedulerId.equals(sschidIntValue)) {
                        skip = false;
                        Object targetSchId = result[5];
                        int tSchidIntValue = Integer.parseInt((String)targetSchId);
                        backTriggered.add(new TriggerJobRelation((String)sourceId, (String)targetId, (String)sschid, (String)targetSchId, Integer.parseInt((String)result[3])));
                        if (tSchidIntValue < 0) {
                            targetSchId = String.valueOf(-tSchidIntValue);
                        }
                        if (jobId.equals(targetIdInt) && com.ez.mainframe.data.utils.Utils.filterNullValue((String)targetSchId) != null && !schids.contains(targetSchId)) {
                            Object[] objectArray3 = new Integer[3];
                            objectArray3[0] = targetIdInt;
                            objectArray3[1] = tSchidIntValue;
                            Object[] localparams = objectArray3;
                            this.computeForward(conn, (String)targetSchId, localparams, paramInfo, schids, suffix, pmonitor.newChild(100));
                            wasComputeForward = true;
                        }
                        jobIds.add(sourceIdInt);
                    }
                }
                ++n2;
            }
        }
        if (!wasComputeForward) {
            this.computeForward(conn, schedulerId.toString(), params, paramInfo, schids, suffix, pmonitor.newChild(100));
        }
        CA7Utils.addContextValue((EZAnalysis)this.analysis, "BACKWARD PROCESSED JOBS", suffix, backTriggered);
        CA7Utils.addContextValue((EZAnalysis)this.analysis, "BACKWARD_SCHIDS", suffix, schids);
        for (String schId : schids) {
            String[][] forward = (String[][])this.analysis.getContextValue(CA7Utils.getKey("FORWARD".concat(schId), suffix));
            if (forward == null) continue;
            String[][] stringArray2 = forward;
            int n3 = forward.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] result2 = stringArray2[n4];
                jobIds.add(Integer.valueOf(result2[1]));
                ++n4;
            }
        }
        if (CA7Utils.isIncludeJobDep((EZAnalysis)this.analysis)) {
            pmonitor.setTaskName(Messages.getString(CA7GraphAnalysisJob.class, (String)"compute.dependencies.taskName"));
            String[][] jobDependenciesOnJobResults = Utils.runProc((EZSourceConnection)conn, (String)CA7_GET_JOBS_DEPENDENT_ON_JOBS_SELECTIVE_SP_NAME, jobIds, (EZSourceDataType)EZSourceDataType.Integer);
            CA7Utils.addContextValue((EZAnalysis)this.analysis, "JOB_DEPENDENCIES_JOBS", suffix, jobDependenciesOnJobResults);
            if (jobDependenciesOnJobResults != null) {
                stringArray = jobDependenciesOnJobResults;
                n = jobDependenciesOnJobResults.length;
                int n5 = 0;
                while (n5 < n) {
                    result = stringArray[n5];
                    jobIds.add(Integer.valueOf((String)result[1]));
                    ++n5;
                }
            }
        }
        pmonitor.worked(50);
        if (CA7Utils.isIncludeDS((EZAnalysis)this.analysis)) {
            pmonitor.setTaskName(Messages.getString(CA7GraphAnalysisJob.class, (String)"compute.dependencies.taskName"));
            String[][] jobDependenciesOnDatasetResults = Utils.runProc((EZSourceConnection)conn, (String)CA7_GET_JOBS_DEPENDENT_ON_DATASETS_SELECTIVE_SP_NAME, jobIds, (EZSourceDataType)EZSourceDataType.Integer);
            CA7Utils.addContextValue((EZAnalysis)this.analysis, "JOB_DEPENDENCIES_DATASETS", suffix, jobDependenciesOnDatasetResults);
        }
        pmonitor.worked(50);
        pmonitor.setWorkRemaining(0);
        return jobIds;
    }

    private void computeJobsDetails(EZSourceConnection conn, Set<Integer> jobIds, SubMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        Object[] procParam = new Integer[]{1};
        String[][] jobInfoResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)"EZViewer_CA7_JobsInfo_Selective", (Object[])procParam, jobIds, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(10));
        this.analysis.addContextValue("JOB_INFORMATION", (Object)jobInfoResults);
        pmonitor.setWorkRemaining(0);
    }

    private void computeForward(EZSourceConnection conn, String schedulerId, Object[] params, ParameterInfo[] pInfo, Set<String> schids, String suffix, SubMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)150);
        String[][] forwardResults = com.ez.mainframe.data.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)CA7_GET_GRAPH_FORWARD_SP_NAME, (Object[])params, (ParameterInfo[])pInfo, null, null, (IProgressMonitor)pmonitor.newChild(100));
        CA7Utils.addContextValue((EZAnalysis)this.analysis, "FORWARD".concat(schedulerId), suffix, forwardResults);
        schids.add(schedulerId);
        pmonitor.worked(50);
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSCommand layoutCommand = null;
        switch (type) {
            case 1: {
                L.debug("do specific constraints layout");
                layoutCommand = ((CA7GraphModel)this.graphModel).createCustomHLayoutCommand((TSDGraph)graph);
                break;
            }
            default: {
                layoutCommand = super.doLayout(type, graph);
            }
        }
        return layoutCommand;
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        monitor.setTaskName(Messages.getString(CA7GraphAnalysisJob.class, (String)"dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)pmonitor.newChild(50), result);
        if (this.gfi != null) {
            HashSet allNodes = new HashSet();
            Collection nodesSetsList = this.graphModel.getOutForStructView().values();
            for (Set nodesSet : nodesSetsList) {
                allNodes.addAll(nodesSet);
            }
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        pmonitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List<Separator> getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List<Separator> getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    private void addFilters(GraphFilterInfo gfi) {
    }

    class CA7GraphInfo
    extends GraphInfoAdapter {
        GraphFilterInfo gfi;
        String tabName;

        public CA7GraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor((String)"icons/ca7.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            ProjectInfo ezsourcePrj = (ProjectInfo)CA7GraphAnalysisJob.this.analysis.getContextValue("PROJECT_INFO");
            StringBuilder sb = new StringBuilder();
            String schid4Print = null;
            Object schid = CA7GraphAnalysisJob.this.analysis.getContextValue("selectedSchID");
            if (schid != null) {
                schid4Print = ((BaseMainframeResource4GUI)((List)schid).get(0)).getObject().getListableName();
            } else {
                schid = CA7GraphAnalysisJob.this.analysis.getContextValue("INPUT_SCHID");
                schid4Print = schid.toString();
            }
            String jobName = (String)CA7GraphAnalysisJob.this.analysis.getContextValue("INPUT_JOB_NAME");
            if (jobName != null && schid != null) {
                sb.append(Messages.getString(CA7GraphAnalysisJob.class, (String)"job.schid", (Object[])new String[]{jobName, schid4Print}));
            }
            sb.append(Messages.getString(CA7GraphAnalysisJob.class, (String)"tab.lbl", (Object[])new String[]{ezsourcePrj.getName()}));
            this.tabName = sb.toString();
            return this.tabName;
        }

        public String getTooltip() {
            StringBuffer buf = new StringBuffer(this.tabName);
            return buf.toString();
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    CA7GraphAnalysisJob.this.legend = new LegendPanel((Composite)sc, 0);
                    CA7GraphAnalysisJob.this.legend.setImageDescriptorProvider(new ImageDescriptorProvider(){

                        public ImageDescriptor getImageDescriptor(String image) {
                            return Activator.getImageDescriptor((String)image);
                        }
                    });
                    int uiStyle = CA7GraphAnalysisJob.this.graphModel.getUIStyle();
                    CA7Utils.addEntriesToLegend(CA7GraphAnalysisJob.this.graphModel, CA7GraphAnalysisJob.this.legend, uiStyle, CA7GraphInfo.this.gfi);
                    sc.setContent((Control)CA7GraphAnalysisJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    CA7GraphAnalysisJob.this.legend.pack();
                    sc.setMinSize(CA7GraphAnalysisJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((CA7GraphAnalysisJob)((CA7GraphInfo)CA7GraphInfo.this).CA7GraphAnalysisJob.this).legend.getSize().x;
                    int x = ((CA7GraphAnalysisJob)((CA7GraphInfo)CA7GraphInfo.this).CA7GraphAnalysisJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }
    }
}

