/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.ca7.flow;

import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.ca7.flow.CA7GraphAnalysisJob;
import com.ez.graphs.ca7.wizard.CA7InputsFilter;
import com.ez.graphs.internal.Messages;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceJobCA7IDSg;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CA7GraphAnalysis
extends MainframeGraphAnalysis {
    private static final Logger L = LoggerFactory.getLogger(CA7GraphAnalysis.class);
    private CA7GraphAnalysisJob job;

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (CA7GraphAnalysisJob)wk.getJob(id, CA7GraphAnalysisJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    public String getLabelType() {
        return Messages.getString(CA7GraphAnalysis.class, (String)"analysis.type.name");
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_CA7_GRAPH_ANALYSIS;
    }

    protected InputsFilter getInputsFilter() {
        CA7InputsFilter iFilter = null;
        List inputs = this.getContextListValue("input_list");
        if (inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType) {
            L.debug("start for ca7 graph on a project.");
            iFilter = new CA7InputsFilter();
        } else {
            EZEntityID entityid = (EZEntityID)inputs.get(0);
            EZSourceJobCA7IDSg ca7jobSg = (EZSourceJobCA7IDSg)entityid.getSegment(EZSourceJobCA7IDSg.class);
            Integer ca7JobId = ca7jobSg.getCa7JobId();
            String ca7JobName = ca7jobSg.getCa7JobName();
            iFilter = new CA7InputsFilter(ca7JobId, ca7JobName);
        }
        return iFilter;
    }
}

