/*
 * Decompiled with CFR 0.152.
 */
package com.ez.protection;

import com.ez.protection.MacUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RegistryBase {
    private static final Logger L = LoggerFactory.getLogger(RegistryBase.class);
    protected Map registry = new Properties();
    protected String fname = null;
    protected static List<String> macAddresses;
    protected boolean expired = false;

    protected void initMACList() {
        try {
            macAddresses = MacUtils.getMACList();
        }
        catch (Exception e) {
            L.error("Error:", (Throwable)e);
        }
    }

    protected boolean checkMAC() {
        if (!this.registry.containsKey("mac.n")) {
            return true;
        }
        Object objectNrofMac = this.registry.get("mac.n");
        boolean result = true;
        boolean exists = false;
        if (objectNrofMac != null) {
            int nr = 0;
            try {
                nr = Integer.parseInt(objectNrofMac.toString());
            }
            catch (NumberFormatException numberFormatException) {
                nr = 0;
            }
            if (nr == 0) {
                return true;
            }
            int i = 0;
            while (i < nr) {
                String key = "mac." + i;
                Object value = this.registry.get(key);
                if (value != null && macAddresses.contains(value)) {
                    exists = true;
                }
                ++i;
            }
            if (!exists) {
                result = false;
            }
        } else {
            result = true;
        }
        return result;
    }

    public Map get() {
        return this.registry;
    }

    public void update(Map newmap) {
        this.registry = newmap;
        this.setLicenseDate(false);
    }

    protected void setLicenseDate(boolean inv) {
    }

    public boolean check(String key) {
        boolean value;
        boolean bl = value = key == null;
        if (key != null && this.registry.containsKey(key)) {
            try {
                value = Boolean.valueOf((String)this.registry.get(key));
            }
            catch (Exception exception) {}
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd H:mm:ss", Locale.JAPAN);
        try {
            boolean exp = true;
            if (this.registry.containsKey("expires")) {
                try {
                    exp = Boolean.valueOf((String)this.registry.get("expires"));
                }
                catch (Exception exception) {}
            }
            Date now = new Date();
            String expDateS = (String)this.registry.get("expDate");
            Date expDate = df.parse(expDateS);
            Date lastDate = null;
            String lastDateS = (String)this.registry.get("lastDate");
            lastDate = "firstTimeDate".equalsIgnoreCase(lastDateS) ? now : df.parse(lastDateS);
            boolean bl2 = this.expired = exp;
            if (lastDate.after(expDate) && exp) {
                value = false;
            } else if (now.after(expDate) && exp) {
                value = false;
            } else if (now.before(lastDate) && exp) {
                value = false;
            } else {
                this.expired = false;
            }
        }
        catch (Exception exception) {
            value = false;
            this.expired = true;
        }
        if (value) {
            value = this.checkMAC();
        }
        this.setLicenseDate(!value);
        return true;
    }
}

