/*
 * Decompiled with CFR 0.152.
 */
package com.ez.protection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class MacUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static void main(String[] args) throws Exception {
        String javaVersion = System.getProperty("java.specification.version");
        List<String> addresses = null;
        if (MacUtils.versionCompatibleWith(javaVersion, "1.6")) {
            System.out.println("Java Version Compatible with 1.6");
            addresses = MacUtils.getMacs();
        } else {
            System.out.println("Java Version NOT Compatible with 1.6");
            addresses = MacUtils.getXPMacs();
        }
        System.out.println("Size = " + addresses.size());
        for (String address : addresses) {
            System.out.println(address);
        }
    }

    public static List<String> getMACList() throws Exception {
        String javaVersion = System.getProperty("java.specification.version");
        ArrayList<String> addresses = new ArrayList<String>();
        if (MacUtils.versionCompatibleWith(javaVersion, "1.6")) {
            addresses.addAll(MacUtils.getMacs());
        } else {
            addresses.addAll(MacUtils.getXPMacs());
        }
        return addresses;
    }

    private static List<String> getMacs() throws SocketException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> addresses = new ArrayList<String>();
        Enumeration<NetworkInterface> itfs = NetworkInterface.getNetworkInterfaces();
        Method m = NetworkInterface.class.getMethod("getHardwareAddress", null);
        while (itfs.hasMoreElements()) {
            NetworkInterface itf = itfs.nextElement();
            byte[] addr = (byte[])m.invoke((Object)itf, null);
            if (addr == null) continue;
            StringBuffer adr = new StringBuffer();
            int i = 0;
            while (i < addr.length) {
                int e = 0xFF & addr[i];
                String bt = Integer.toHexString(e).toUpperCase();
                if (bt.length() == 1) {
                    bt = "0" + bt;
                }
                adr.append(String.valueOf(bt) + (i == addr.length - 1 ? "" : "-"));
                ++i;
            }
            addresses.add(adr.toString());
        }
        return addresses;
    }

    private static boolean versionCompatibleWith(String javaVersion, String etalon) {
        String[] vNumbers = javaVersion.split("\\.");
        String[] eNumbers = etalon.split("\\.");
        boolean compatible = true;
        int i = 0;
        while (i < vNumbers.length) {
            if (i < eNumbers.length && Integer.parseInt(vNumbers[i]) < Integer.parseInt(eNumbers[i])) {
                compatible = false;
                break;
            }
            ++i;
        }
        return compatible;
    }

    public static List<String> getXPMacs() throws IOException {
        ArrayList<String> addresses = new ArrayList<String>();
        Process p = Runtime.getRuntime().exec("getmac /nh");
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = null;
        while ((line = in.readLine()) != null) {
            String[] result = line.split(" ");
            addresses.add(result[0]);
        }
        return addresses;
    }
}

