/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import com.ez.internal.Activator;
import com.ez.internal.Messages;
import com.ez.internal.utils.InternalLogUtil;
import com.ez.internal.utils.PathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.service.datalocation.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);
    public static final String ABAP_EXTENSION_WITH_DOT = ".abap";
    public static final String XML_EXTENSION_WITH_DOT = ".xml";
    public static final String ABAP_EXTENSION = "abap";
    public static final String XML_EXTENSION = "xml";
    public static final String JSP_EXTENSION = "jsp";
    public static final String JSP_EXTENSION_WITH_DOT = ".jsp";
    public static final String JS_EXTENSION = "js";
    public static final String HTML_EXTENSION = "html";
    public static final String JS_EXTENSION_WITH_DOT = ".js";
    public static final String HTML_EXTENSION_WITH_DOT = ".html";
    public static final String CSS_EXTENSION = "css";
    public static final String CSS_EXTENSION_WITH_DOT = ".css";
    public static final String ASP_EXTENSION = "asp";
    public static final String JPG_EXTENSION = "jpg";
    public static final String BMP_EXTENSION = "bmp";
    public static final String XHTML_EXTENSION = "xhtml";
    public static final String JAVA_EXTENSION = "java";
    public static final String JAVA_EXTENSION_WITH_DOT = ".java";
    public static final String JAR_EXTENSION = "jar";
    public static final String NW_EXTENTION_APPLICATION = "wdapplication";
    public static final String NW_EXTENTION_COMPONENT = "wdcomponent";
    public static final String NW_EXTENTION_CONTROLLER = "wdcontroller";
    public static final String NW_EXTENTION_MODELCLASS = "wdmodelclass";
    public static final String Form_Label = Messages.getString(Utils.class, "forms.label");
    public static final String Transaction_Label = Messages.getString(Utils.class, "transaction.label");
    public static final String Perform_Label = Messages.getString(Utils.class, "performs..label");
    public static final String DBTables_Label = Messages.getString(Utils.class, "dbTables.label");
    public static final String InternalTables_Label = Messages.getString(Utils.class, "internalTables.label");
    public static final String Table_Label = Messages.getString(Utils.class, "tables.label");
    public static final String View_Label = Messages.getString(Utils.class, "views.label");
    public static final String TableFields_Label = Messages.getString(Utils.class, "tableFields.label");
    public static final String Screen_Label = Messages.getString(Utils.class, "screens.label");
    public static final String CallScreen_Label = Messages.getString(Utils.class, "callScreens.label");
    public static final String SetScreen_Label = Messages.getString(Utils.class, "setScreens.label");
    public static final String ScreenEvent_Label = Messages.getString(Utils.class, "screenEvents.label");
    public static final String LeaveScreen_Label = Messages.getString(Utils.class, "leaveScreens.label");
    public static final String DataBase_Label = Messages.getString(Utils.class, "db.label");
    public static final String Dataset_Label = Messages.getString(Utils.class, "dataset.label");
    public static final String ModuleDef_Label = Messages.getString(Utils.class, "modules.label");
    public static final String ModuleCall_Label = Messages.getString(Utils.class, "moduleCalls.label");
    public static final String FunctDef_Label = Messages.getString(Utils.class, "functionDefs.label");
    public static final String FunctCall_Label = Messages.getString(Utils.class, "functionCalls.label");
    public static final String LeaveTransaction_Label = Messages.getString(Utils.class, "leaveTransaction.label");
    public static final String Program_Label = Messages.getString(Utils.class, "programs.label");
    public static final String Include_Label = Messages.getString(Utils.class, "includes.label");
    public static final String Resource_Label = Messages.getString(Utils.class, "resources.label");
    public static final String SimpleDates_Label = Messages.getString(Utils.class, "simpleData.label");
    public static final String Class_Label = Messages.getString(Utils.class, "classes.label");
    public static final String CallSubScreen_Label = Messages.getString(Utils.class, "callSubscreens.label");
    public static final String CallTransaction_Label = Messages.getString(Utils.class, "callTransact.label");
    public static final String CallMethod_Label = Messages.getString(Utils.class, "callMethods.label");
    public static final String Submit_Label = Messages.getString(Utils.class, "submit.lable");
    public static final String ClassEvent_Label = Messages.getString(Utils.class, "classEvents.label");
    public static final String Function_Label = Messages.getString(Utils.class, "functions.label");
    public static final String Structure_Label = Messages.getString(Utils.class, "structures.label");
    public static final String RFC_Label = Messages.getString(Utils.class, "rfc.label");
    public static final String Leave_Label = Messages.getString(Utils.class, "leaves.label");
    public static final String ProcessEvent_Label = Messages.getString(Utils.class, "processEvents.label");
    public static final String FlowEvent_Label = Messages.getString(Utils.class, "flowEvents.label");
    public static final String InteractiveEvent_Label = Messages.getString(Utils.class, "interactiveEvents.label");
    public static final String OutputEvent_Label = Messages.getString(Utils.class, "outputEvents.label");
    public static final String Method_Label = Messages.getString(Utils.class, "methods.label");
    public static final Object AbapClass_Label = Messages.getString(Utils.class, "abapClasses.label");
    public static final String DataElement_Label = Messages.getString(Utils.class, "dataElement.label");
    public static final String Domain_Label = Messages.getString(Utils.class, "domain.label");
    public static final String TableType_Label = Messages.getString(Utils.class, "tables.type.label");
    public static final String FunctModule_Label = Messages.getString(Utils.class, "function.module.label");
    public static final String FunctGroup_Label = Messages.getString(Utils.class, "function.group.label");
    public static final String DBStatements_Label = Messages.getString(Utils.class, "ddStatements.label");
    public static final String DatasetStatements_Label = Messages.getString(Utils.class, "datasetStatements.label");
    public static final String XIServers_Label = Messages.getString(Utils.class, "xiServers.label");
    public static final String FunctCall_RFC_Label = Messages.getString(Utils.class, "functionCallsRFC.label");
    public static final String FunctCall_XI_Label = Messages.getString(Utils.class, "functionCallsXI.label");
    public static final String TypeGroup_Label = Messages.getString(Utils.class, "typeGroups.label");
    public static final String TypePool_Label = Messages.getString(Utils.class, "typePoolStatements.label");
    public static final String InfoTypes_Label = Messages.getString(Utils.class, "infotypes.label");
    public static final String Controls_Label = Messages.getString(Utils.class, "controls.label");
    public static final String Nodes_Label = Messages.getString(Utils.class, "nodes.label");
    public static final String BDTApplication_Label = Messages.getString(Utils.class, "bdtApplications.label");
    public static final String SAP_DATA_FOLDER_CRM = "/sapData/CRM/";
    public static final String SAP_DATA_FOLDER_ECC6 = "/sapData/ECC6/";
    public static final String SAP_DATA_FOLDER_46C = "/sapData/46C/";
    public static final String SAP_DATA_FOLDER_47 = "/sapData/47/";
    public static final String BADI_CLASS_FILE_NAME = "badi-cls-4.7.txt";
    public static final String BADI_INTERFACE_FILE_NAME = "badi-itf-4.7.txt";
    public static final String OBSOLETE_FUNCTION_FILE_NAME = "obsoleteFunctions-ECC6.properties";
    public static final String PREFIX_USEREXIT_INCLUDE_PROG_NAME = "userexit_include-resource";
    public static final String PREFIX_USEREXIT_INCLUDE_NAME = "userexit-resource";
    public static final String PREFIX_USEREXIT_INCLUDE_PATH_NAME = "userexit_include-resource_path";
    public static final String SUFFIX_47 = "-4.7.properties";
    public static final String SUFFIX_CRM = "-CRM.properties";
    public static final String SUFFIX_46C = "-46C.properties";
    public static final String SUFFIX_ECC6 = "-ECC6.properties";
    public static final String CSHARP_EXTENSION = "cs";
    public static final String CSHARP_EXTENSION_WITH_DOT = ".cs";
    public static final String NO_LICENSE_MSG = Messages.getString(Utils.class, "no.license.msg");
    public static final String OPERATION_DENIED_MSG = Messages.getString(Utils.class, "op.denied.msg");
    public static final String SYSTEM_FILE_SEPARATOR_PROPERTY = System.getProperty("file.separator");
    public static final String PACKAGE_SEPARATOR = "/";
    public static final String NOT_CATEGORIZED_MODULE = Messages.getString(Utils.class, "uncategorized.module.name");

    public static String getDecodedPath(URL resURL) {
        return Utils.getDecodedPath(resURL.getPath());
    }

    public static String getDecodedPath(String spath) {
        StringBuffer path = new StringBuffer(spath);
        StringBuffer decoded = new StringBuffer();
        int sidx = 0;
        int eidx = -1;
        int code = 0;
        while (true) {
            boolean keepChar = false;
            eidx = path.indexOf("%", sidx);
            if (eidx == -1) break;
            decoded.append(path.subSequence(sidx, eidx));
            String charCode = path.substring(eidx + 1, eidx + 3);
            try {
                code = Integer.parseInt(charCode);
                switch (code) {
                    case 20: {
                        decoded.append(" ");
                        break;
                    }
                    case 25: {
                        decoded.append("%");
                        break;
                    }
                    case 23: {
                        L.warn("path with #: {}", (Object)path);
                        decoded.append("#");
                        break;
                    }
                    default: {
                        throw new RuntimeException("URL encoding not suported: %" + code + " in path: " + path);
                    }
                }
            }
            catch (NumberFormatException ex) {
                L.error("strange char in url: {}", (Object)spath, (Object)ex);
                if ("7B".equalsIgnoreCase(charCode)) {
                    decoded.append("{");
                }
                if ("7D".equalsIgnoreCase(charCode)) {
                    decoded.append("}");
                }
                keepChar = true;
            }
            if (keepChar) {
                decoded.append("%").append(charCode);
            }
            sidx = eidx + 3;
        }
        if (sidx < path.length()) {
            decoded.append(path.subSequence(sidx, path.length()));
        }
        return decoded.toString();
    }

    public static String computeRelativePath(String projectPath, URL resUrl) {
        String ret = null;
        IPath relPath = null;
        String resName = Utils.getDecodedPath(resUrl);
        Path prjPath = new Path("", projectPath);
        Path resPath = new Path("", resName);
        Path upperPrjPath = new Path("", projectPath.toUpperCase());
        Path upperResPath = new Path("", resName.toUpperCase());
        L.debug(" compute rel path {} {}", (Object)prjPath, (Object)resPath);
        if (upperPrjPath.isPrefixOf((IPath)upperResPath)) {
            int pos = upperResPath.matchingFirstSegments((IPath)upperPrjPath);
            if (pos < 0) {
                L.debug("pos for {} {}", (Object)pos, (Object)resUrl);
                return null;
            }
            relPath = resPath.removeFirstSegments(pos).makeAbsolute();
            L.debug("rel path for {} {}", (Object)resUrl, (Object)relPath);
        } else {
            L.debug("{} not in project {}", (Object)resUrl, (Object)projectPath);
        }
        if (relPath != null) {
            L.debug("relPath.toString {}", (Object)relPath.toString());
            ret = relPath.toString().substring(1);
        }
        return ret;
    }

    public static String removeExtension(String filename) {
        int pos = filename.lastIndexOf(".");
        if (pos != -1) {
            filename = filename.substring(0, pos);
        }
        return filename;
    }

    public static String getLegalFileNameFor(String abapName) {
        return abapName.replaceAll(PACKAGE_SEPARATOR, "__S__").replaceAll("<", "__L__").replaceAll(">", "__R__");
    }

    public static String getFileNameFor(String abapName) {
        return abapName.replaceAll("__s__", PACKAGE_SEPARATOR).replaceAll("__S__", PACKAGE_SEPARATOR).replaceAll("__l__", "<").replaceAll("__L__", "<").replaceAll("__r__", ">").replaceAll("__R__", ">");
    }

    public static Boolean getBoolVal(String value) {
        if (value != null && value.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static final String getApplicationDefaultPath() {
        boolean wkspSet = Platform.getInstanceLocation().isSet();
        L.trace("getApplicationDefaultPath()::wkspSet={}", (Object)wkspSet);
        return PathUtils.METADATA_FOLDER.getAbsolutePath();
    }

    public static boolean hasNature(IProject project, String natureID) {
        try {
            if (project.isOpen()) {
                return project.hasNature(natureID);
            }
            InternalLogUtil.info(Messages.getString(Utils.class, "projectClosed.message.log", new String[]{project.getName()}));
            L.info("project {} is closed; cannot check nature {}", (Object)project.getName(), (Object)natureID);
        }
        catch (CoreException e) {
            InternalLogUtil.err(Messages.getString(Utils.class, "nature.exception.log", new String[]{natureID, project.getName()}), e);
            L.error("exception dealing with nature ", (Throwable)e);
        }
        InternalLogUtil.info(Messages.getString(Utils.class, "noNature.error", new String[]{project.getName()}));
        return false;
    }

    public static String pluginsPath() {
        return Utils.computePath(true);
    }

    public static String instalationPath() {
        return Utils.computePath(false);
    }

    private static String computePath(boolean withPlugins) {
        String p;
        Location loc = Platform.getInstallLocation();
        String path = null;
        if (loc != null) {
            URL url = loc.getURL();
            path = url.getPath();
            if (withPlugins) {
                path = String.valueOf(path) + "plugins";
            }
            path = path.substring(1);
        }
        if ((p = System.getProperty("DEVEL_PATH")) != null) {
            System.out.println("using development path: " + p);
            path = p;
        }
        return path;
    }

    public static String removePackage(String name) {
        String ret = name;
        String[] parts = name.split(PACKAGE_SEPARATOR);
        if (parts.length > 1) {
            L.debug("name {} has {} parts", (Object)name, (Object)parts.length);
            ret = parts[parts.length - 1];
        }
        return ret;
    }

    public static String getPackage(String name) {
        String ret = null;
        String[] parts = name.split(PACKAGE_SEPARATOR);
        if (parts.length > 1) {
            L.debug("name {} has {} parts", (Object)name, (Object)parts.length);
            ret = parts[1];
        }
        return ret;
    }

    public static String getFuncGroupName(String programName) {
        String ret = programName;
        String[] parts = programName.split(PACKAGE_SEPARATOR);
        if (parts.length > 1) {
            L.debug("name {} has {} parts", (Object)programName, (Object)parts.length);
            ret = parts[parts.length - 1];
        }
        if (ret != null && ret.toUpperCase().startsWith("SAPL")) {
            ret = ret.substring(4);
        }
        if (parts.length > 1) {
            String fullName = "";
            int i = 0;
            while (i < parts.length - 1) {
                fullName = String.valueOf(fullName) + parts[i];
                fullName = String.valueOf(fullName) + PACKAGE_SEPARATOR;
                ++i;
            }
            ret = String.valueOf(fullName) + ret;
        }
        return ret;
    }

    public static boolean isFunctionGroup(String name) {
        boolean rez = false;
        int idx = name.lastIndexOf(PACKAGE_SEPARATOR);
        if (idx > 0) {
            name = name.substring(idx + 1);
        }
        if (name.toUpperCase().startsWith("SAPL")) {
            rez = true;
        }
        return rez;
    }

    public static boolean isDemo() {
        return false;
    }

    public static Set<String> getContentFile(String dataFolderType, String path) {
        HashSet<String> result = null;
        try {
            String line;
            InputStream inputStream = Activator.class.getResourceAsStream(dataFolderType.concat(path));
            if (inputStream == null) {
                L.debug("not found sap data file for {}", (Object)(String.valueOf(dataFolderType) + path));
                return result;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            result = new HashSet<String>();
            while ((line = in.readLine()) != null) {
                result.add(line);
            }
        }
        catch (IOException e) {
            L.debug("error reading sap data file: {}", (Object)(String.valueOf(dataFolderType) + path), (Object)e);
        }
        return result;
    }

    public static Properties getPropertiesFile(String path) {
        Properties file = new Properties();
        try {
            InputStream inputStream = Activator.class.getResourceAsStream(path);
            file.load(inputStream);
        }
        catch (Throwable t) {
            L.debug("error reading sap data file {}", (Object)path, (Object)t);
        }
        return file;
    }

    public static String getProjectDBServer(IProject project) {
        QualifiedName qName = Utils.buildProjectDBServer(project.getName());
        String srvName = "";
        try {
            srvName = project.getPersistentProperty(qName);
        }
        catch (CoreException e) {
            L.error("getProjectDBServer() for {}", (Object)project.getName(), (Object)e);
        }
        return srvName;
    }

    public static String getProjectDB(IProject project) {
        QualifiedName qName = Utils.buildProjectDB(project.getName());
        String dbName = "";
        try {
            dbName = project.getPersistentProperty(qName);
            dbName = dbName == null ? "" : dbName;
        }
        catch (CoreException e) {
            L.error("getProjectDB() for {}", (Object)project.getName(), (Object)e);
        }
        return dbName;
    }

    public static String getProjectSQLHost(IProject project) {
        QualifiedName qName = Utils.buildProjectSQLHost(project.getName());
        String sqlHost = "";
        try {
            sqlHost = project.getPersistentProperty(qName);
            sqlHost = sqlHost == null ? "" : sqlHost;
        }
        catch (CoreException e) {
            L.error("getProjectSQLHost() for {}", (Object)project.getName(), (Object)e);
        }
        return sqlHost;
    }

    public static String getProjectSQLPort(IProject project) {
        QualifiedName qName = Utils.buildProjectSQLPort(project.getName());
        String sqlPort = "";
        try {
            sqlPort = project.getPersistentProperty(qName);
            sqlPort = sqlPort == null ? "" : sqlPort;
        }
        catch (CoreException e) {
            L.error("getProjectSQLPort() for {}", (Object)project.getName(), (Object)e);
        }
        return sqlPort;
    }

    public static String getProjectSQLInstance(IProject project) {
        QualifiedName qName = Utils.buildProjectSQLInstance(project.getName());
        String sqlInstance = "";
        try {
            sqlInstance = project.getPersistentProperty(qName);
            sqlInstance = sqlInstance == null ? "" : sqlInstance;
        }
        catch (CoreException e) {
            L.error("getProjectSQLInstance() for {}", (Object)project.getName(), (Object)e);
        }
        return sqlInstance;
    }

    public static String getProjectSQLUser(IProject project) {
        QualifiedName qName = Utils.buildProjectSQLUser(project.getName());
        String sqlUser = "";
        try {
            sqlUser = project.getPersistentProperty(qName);
            sqlUser = sqlUser == null ? "" : sqlUser;
        }
        catch (CoreException e) {
            L.error("getProjectSQLUser() for {}", (Object)project.getName(), (Object)e);
        }
        return sqlUser;
    }

    public static String getProjectSQLPassw(IProject project) {
        QualifiedName qName = Utils.buildProjectSQLPassw(project.getName());
        String sqlPassw = "";
        try {
            sqlPassw = project.getPersistentProperty(qName);
            sqlPassw = sqlPassw == null ? "" : sqlPassw;
        }
        catch (CoreException e) {
            L.error("getProjectSQLPassw() for {}", (Object)project.getName(), (Object)e);
        }
        return sqlPassw;
    }

    public static QualifiedName buildProjectDBServer(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.internal", projectName.concat("_dbServer"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static QualifiedName buildProjectDB(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.internal", projectName.concat("_database"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static QualifiedName buildProjectSQLHost(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.internal", projectName.concat("_sqlHost"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static QualifiedName buildProjectSQLPort(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.internal", projectName.concat("_sqlPort"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static QualifiedName buildProjectSQLInstance(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.internal", projectName.concat("_sqlInstance"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static QualifiedName buildProjectSQLUser(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.internal", projectName.concat("_sqlUser"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static QualifiedName buildProjectSQLPassw(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.internal", projectName.concat("_sqlPassw"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static String getPlatformName() {
        String platform;
        String os = System.getProperty("os.name");
        String los = os.toLowerCase();
        if (los.indexOf("linux") != -1) {
            L.debug("assuming linux");
            platform = "linux";
        } else if (los.indexOf("win") != -1) {
            platform = "win";
            L.debug("assuming windows");
        } else {
            platform = null;
        }
        return platform;
    }

    public static String getPlatformDependentDirName() {
        String arch = System.getProperty("sun.arch.data.model", "32");
        String platform = Utils.getPlatformName();
        return platform != null ? String.valueOf(platform) + arch : null;
    }

    public static String adaptPathToPlatform(String path) {
        if (path != null) {
            path = path.trim();
            boolean unc = false;
            String separator = File.separator;
            String regexSeparator = separator.equals("\\") ? String.valueOf(separator) + separator : separator;
            boolean bl = unc = Utils.getPlatformName().equals("win") && (path.startsWith("\\\\") || path.startsWith("//"));
            if (path.startsWith("\"") && path.endsWith("\"")) {
                path = path.substring(1, path.length() - 1);
            }
            if ("linux".equals(Utils.getPlatformName()) && path.startsWith("~")) {
                String userDir = System.getProperty("user.dir");
                path = path.replaceFirst("~", userDir);
            }
            path = path.replaceAll("[\\\\/]+", regexSeparator);
            if (unc) {
                path = String.valueOf(separator) + path;
            }
        }
        return path;
    }
}

