/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(StringUtils.class);

    public static String null2empty(String string) {
        return string == null ? "" : string;
    }

    public static String empty2null(String string) {
        String retVal = string;
        if (retVal != null && string.isEmpty()) {
            retVal = string.isEmpty() ? null : string;
        }
        return retVal;
    }

    public static Map<String, String> parseMap(String value) {
        value = value.trim();
        HashMap<String, String> result = null;
        if (value != null) {
            if (value.startsWith("{") && value.endsWith("}")) {
                value = value.substring(1, value.length() - 1);
            }
            String[] entries = value.split(" *, *");
            result = new HashMap<String, String>();
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String val;
                String key;
                String entry = stringArray[n2];
                int split = entry.indexOf("=");
                if (split == -1) {
                    key = entry;
                    val = "";
                } else {
                    key = entry.substring(0, split);
                    val = entry.substring(split + 1);
                }
                result.put(key, val);
                ++n2;
            }
        }
        return result;
    }

    public static String[] parseArray(String value) {
        value = value.trim();
        String[] result = null;
        if (value != null) {
            if (value.startsWith("[") && value.endsWith("]")) {
                value = value.substring(1, value.length() - 1);
            }
            result = value.split(" *, *");
        }
        return result;
    }

    public static List<String> parseList(String value) {
        value = value.trim();
        ArrayList<String> result = null;
        String[] entries = StringUtils.parseArray(value);
        if (entries != null) {
            result = new ArrayList<String>(entries.length);
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                result.add(entry);
                ++n2;
            }
        }
        return result;
    }

    public static Set<String> parseSet(String value) {
        value = value.trim();
        HashSet<String> result = null;
        String[] entries = StringUtils.parseArray(value);
        if (entries != null) {
            result = new HashSet<String>(entries.length);
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                result.add(entry);
                ++n2;
            }
        }
        return result;
    }

    public static Integer parseInt(String value) {
        Integer retVal = null;
        if (value != null) {
            value = value.trim();
            try {
                retVal = Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                L.trace("number is not an int");
            }
        }
        return retVal;
    }

    public static boolean containsRegex(String string, Collection<String> list) {
        boolean retVal = false;
        for (String element : list) {
            if (!element.equals(string) && !Pattern.matches(element, string)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }
}

