/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ServiceUtils.class);
    private static boolean inOsgi = true;
    private static boolean testedOsgi = false;
    private static Map<String, Object> nonOsgiServices = new HashMap<String, Object>();
    private static Map<String, Class> registeredImplementations = Collections.synchronizedMap(new HashMap());
    private static Map<String, IServiceFactory<?>> registeredImplementationsFactory = Collections.synchronizedMap(new HashMap());

    public static <T> T getService(Class<T> itfClass) {
        return ServiceUtils.getService(itfClass.getName());
    }

    public static <T> T getService(String itfName) {
        Object s = null;
        if (ServiceUtils.isOsgi()) {
            ServiceReference sr;
            BundleContext context = FrameworkUtil.getBundle(ServiceUtils.class).getBundleContext();
            if (context != null && (sr = context.getServiceReference(itfName)) != null) {
                s = context.getService(sr);
            }
        } else {
            s = ServiceUtils.obtainServiceInstance(itfName);
        }
        return (T)s;
    }

    public static void registerServiceImplementation(Class intf, Class impl) {
        registeredImplementations.put(intf.getName(), impl);
    }

    public static <T> void registerServiceImplementation(Class intf, Class<T> impl, IServiceFactory<T> serviceFactory) {
        registeredImplementations.put(intf.getName(), impl);
        if (serviceFactory != null) {
            registeredImplementationsFactory.put(intf.getName(), serviceFactory);
        }
    }

    public static Class unregisterServiceImplementation(Class intf) {
        if (nonOsgiServices.containsKey(intf.getName())) {
            L.debug("removing nonosgi service instance");
            nonOsgiServices.remove(intf.getName());
        }
        registeredImplementationsFactory.remove(intf.getName());
        return registeredImplementations.remove(intf.getName());
    }

    public static synchronized boolean isOsgi() {
        if (!testedOsgi) {
            inOsgi = true;
            try {
                inOsgi = FrameworkUtil.getBundle(ServiceUtils.class) != null;
            }
            catch (Throwable throwable) {
                inOsgi = false;
            }
            testedOsgi = true;
        }
        return inOsgi;
    }

    private static synchronized <T> T obtainServiceInstance(String itfName) {
        Object s = null;
        if (nonOsgiServices.containsKey(itfName)) {
            s = nonOsgiServices.get(itfName);
        } else {
            Class implClass = registeredImplementations.get(itfName);
            if (implClass != null) {
                IServiceFactory<?> factory = registeredImplementationsFactory.get(itfName);
                try {
                    s = factory == null ? implClass.newInstance() : factory.build();
                    nonOsgiServices.put(itfName, s);
                }
                catch (Exception e) {
                    L.error("could not instantiate {}", (Object)itfName, (Object)e);
                }
            } else {
                L.warn("Service {} is not registered. This is a configuration issue, application has unpredictable results.", (Object)itfName);
            }
        }
        return (T)s;
    }

    private static void test() {
        class Test1
        implements ITest1 {
            Test1() {
            }

            public String toString() {
                return "test1";
            }
        }
        ServiceUtils.registerServiceImplementation(ITest1.class, Test1.class);
        class Test2
        implements ITest2 {
            private String s;

            public Test2(String s) {
                this.s = s;
                System.out.println("new " + Test2.class + " instance");
            }

            public String toString() {
                return this.s;
            }
        }
        ServiceUtils.registerServiceImplementation(ITest2.class, Test2.class, new IServiceFactory<Test2>(){

            @Override
            public Test2 build() {
                return new Test2("100");
            }
        });
        System.out.println(ServiceUtils.getService(ITest1.class));
        System.out.println(ServiceUtils.getService(ITest2.class));
        System.out.println(ServiceUtils.getService(ITest2.class));
        System.out.println(ServiceUtils.getService(ITest2.class));
    }

    public static interface IServiceFactory<T> {
        public T build();
    }

    private static interface ITest1 {
    }

    private static interface ITest2 {
    }
}

