/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import com.ez.internal.utils.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(ResourceUtils.class);

    public static IResource findResource(IProject prj, String resPath) {
        IResource res = null;
        String prName = prj.getName();
        String memberName = String.valueOf(prName) + Utils.SYSTEM_FILE_SEPARATOR_PROPERTY + resPath;
        res = ResourcesPlugin.getWorkspace().getRoot().findMember(memberName);
        if (res == null) {
            Path path = new Path(resPath);
            String fileName = path.lastSegment();
            path = path.removeLastSegments(1);
            IPath fullPath = new Path(prName).append((IPath)path);
            IResource found = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath);
            if (found != null && found.exists()) {
                try {
                    IResource[] resources = ((IContainer)found).members();
                    int ii = 0;
                    while (ii < resources.length) {
                        if (resources[ii].getName().equalsIgnoreCase(fileName)) {
                            res = resources[ii];
                            break;
                        }
                        ++ii;
                    }
                }
                catch (CoreException e) {
                    L.error("getResource.error", (Throwable)e);
                }
            }
            L.debug("ignoreCase fileName: {}", (Object)res);
        }
        return res;
    }

    public static IResource findLinkedResource(URL fiurl, IProject prj) {
        IFile res = null;
        try {
            IContainer[] cont;
            URI u = fiurl.toURI();
            IContainer[] iContainerArray = cont = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(u);
            int n = cont.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer c = iContainerArray[n2];
                if (c.getProject().equals((Object)prj)) {
                    res = c.getFile((IPath)new Path(""));
                    break;
                }
                ++n2;
            }
        }
        catch (URISyntaxException e) {
            L.debug("error while searching linked resource with URL: {}", (Object)fiurl, (Object)e);
        }
        return res;
    }

    public static void createFolderHelper(IResource folder, IProgressMonitor monitor, boolean isDerived) throws CoreException {
        switch (folder.getType()) {
            case 2: {
                if (!folder.exists()) {
                    IContainer parent = folder.getParent();
                    if (parent.getType() == 2 && !((IFolder)parent).exists()) {
                        ResourceUtils.createFolderHelper((IResource)((IFolder)parent), monitor, isDerived);
                    }
                    ((IFolder)folder).create(false, true, monitor);
                }
                if (!isDerived) break;
                folder.setDerived(true);
                break;
            }
            case 1: {
                if (!folder.exists()) {
                    IContainer parent = folder.getParent();
                    if (parent.getType() == 2 && !((IFolder)parent).exists()) {
                        ResourceUtils.createFolderHelper((IResource)((IFolder)parent), monitor, isDerived);
                    }
                    ((IFile)folder).create(null, true, monitor);
                }
                if (!isDerived) break;
                folder.setDerived(true);
                break;
            }
        }
    }
}

