/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import com.ez.internal.utils.PreferenceConstants;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PreferencesUtils.class);

    public static String manageClientIP() {
        IPreferenceStore ret = PreferenceConstants.getInternalPrefStore();
        String ip = ret.getString("clientCallbackExportIP");
        if (ip == null || "".equals(ip)) {
            L.debug("no client ip set, trying to find a default");
            List<String> ips = PreferencesUtils.getHostIpAddresses();
            L.trace("found IP: " + ips);
            if (ips != null && ips.size() > 0) {
                ip = ips.get(0);
            } else {
                L.info("no IP found for client, it will remain null");
            }
            ret.setDefault("clientCallbackExportIP", ip);
            ret.setValue("clientCallbackExportIP", ip);
        }
        return ip;
    }

    public static List<String> getHostIpAddresses() {
        LinkedList<String> ipAddresses = new LinkedList<String>();
        boolean allowLoopback = Boolean.parseBoolean(System.getProperty("ALLOW_LOOPBACK", "false"));
        try {
            Enumeration<NetworkInterface> nie = NetworkInterface.getNetworkInterfaces();
            if (nie != null) {
                while (nie.hasMoreElements()) {
                    NetworkInterface ni = nie.nextElement();
                    List<InterfaceAddress> itfAddresses = ni.getInterfaceAddresses();
                    if (!ni.isUp() || !allowLoopback && ni.isLoopback()) continue;
                    for (InterfaceAddress interfaceAddress : itfAddresses) {
                        if (interfaceAddress.getAddress().isLinkLocalAddress() || !allowLoopback && interfaceAddress.getAddress().isLoopbackAddress()) continue;
                        ipAddresses.add(interfaceAddress.getAddress().getHostAddress());
                    }
                }
            }
        }
        catch (SocketException e) {
            L.error("error when getting the host's ip addresses: ", (Throwable)e);
        }
        return ipAddresses;
    }
}

