/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import com.ez.internal.Activator;
import com.ez.internal.Messages;
import com.ez.internal.utils.InternalLogUtil;
import com.ez.internal.utils.PathUtils;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceConstants {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PreferenceConstants.class);
    public static final String P_LICENSE_DATE = "licPref";
    public static final String P_VERSION = "version";
    public static final String P_LICENSED_TO = "licensedTo";
    public static final String P_LICENSE_FILES_NUMBER = "licenseFileNumber";
    public static final String P_LICENSE_FILE = "licensedFile";
    public static final String FOREVER_LICENSE = Messages.getString(PreferenceConstants.class, "forever.license.text");
    public static final String LICENSE_EXPIRES = Messages.getString(PreferenceConstants.class, "expires.license.text");
    public static final String LICENSE_EXPIRED = Messages.getString(PreferenceConstants.class, "expired.license.text");
    public static final String INVALID_LICENSE = Messages.getString(PreferenceConstants.class, "invalid.license.text");
    public static final String P_CLIENT_CALLBACK_EXPORT_PORT = "client.callback.export.port";
    public static final int DEF_CLIENT_CALLBACK_EXPORT_PORT = 0;
    public static final String P_CLIENT_CALLBACK_EXPORT_IP = "clientCallbackExportIP";
    public static final String SP_CLIENT_ALLOW_LOOPBACK = "ALLOW_LOOPBACK";
    public static final String P_CLIENT_CALLBACK_EXPORT_IP_USE_TEXT_FIELD = "clientCallbackExportIPCheckboxUseCheckbox";
    public static final int P_CLIENT_SSDP_DEFAULT_IP = 9001;

    public static IPreferenceStore getInternalPrefStore() {
        Activator a = Activator.getDefault();
        if (a != null) {
            return a.getPreferenceStore();
        }
        return null;
    }

    public static int getInternalCallbackPort() {
        int defValue = PreferenceConstants.getInternalPrefStore().getDefaultInt(P_CLIENT_CALLBACK_EXPORT_PORT);
        if (defValue == 0) {
            PreferenceConstants.getInternalPrefStore().setDefault(P_CLIENT_CALLBACK_EXPORT_PORT, 0);
        }
        int port = PreferenceConstants.getInternalPrefStore().getInt(P_CLIENT_CALLBACK_EXPORT_PORT);
        L.debug("internal callback port: {}", (Object)port);
        return port;
    }

    public static void loadInstallPropFile() {
        Properties instProp = PathUtils.getInstallProperties();
        String dbServer = instProp.getProperty("dbServerPreference");
        if ("MS SQL SERVER".equalsIgnoreCase(dbServer)) {
            L.info("dbServer install properties changed (old={}, new=sqlServer", (Object)dbServer);
            instProp.setProperty("dbServerPreference", "sqlServer");
        }
        IPreferenceStore ret = Activator.getDefault().getPreferenceStore();
        Enumeration<?> e = instProp.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = instProp.getProperty(propName);
            if (value != null && !value.equals("")) {
                ret.setDefault(propName, value);
                continue;
            }
            L.error("null value for prop: {}", (Object)propName);
            InternalLogUtil.warn(Messages.getString(PreferenceConstants.class, "prop.with.no.value.message", new String[]{propName}), null);
        }
    }
}

