/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import com.ez.internal.Activator;
import com.ez.internal.Messages;
import com.ez.internal.utils.InternalLogUtil;
import com.ez.internal.utils.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static final Logger L = LoggerFactory.getLogger(PathUtils.class);
    public static final String APP_SETTINGS_FOLDER = ".ez";
    public static final File APP_SETTINGS_DIR = new File(PathUtils.getWorkspaceLocation(), ".metadata");
    public static final String VERSION_FILE_NAME = "versions.properties";
    public static final String ENABLE_CUSTOM_LOCATION_LOOKUP = "ENABLE_CUSTOM_LOCATION_LOOKUP";
    public static Properties packagedVersions = null;
    public static final File METADATA_FOLDER = new File(APP_SETTINGS_DIR + File.separator + ".ez" + File.separator);
    public static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";

    private static synchronized File getWorkspaceLocation() {
        boolean wkspSet = Platform.getInstanceLocation().isSet();
        if (!wkspSet) {
            String txt = "instance location not set! default location it will be used instead!!!";
            L.warn(txt);
            System.err.println(txt);
        }
        if (System.getProperty(ENABLE_CUSTOM_LOCATION_LOOKUP) == null) {
            File wkLocation = Platform.getLocation().toFile();
            L.info("Workspace: {}", (Object)wkLocation);
            return wkLocation;
        }
        File configLocation = null;
        File wkLocation = null;
        L.info("Custom location lookup enabled.");
        URL configLocationUrl = Platform.getConfigurationLocation().getURL();
        try {
            configLocation = new File(configLocationUrl.toURI());
        }
        catch (URISyntaxException e) {
            L.error("Unexpected error.", (Throwable)e);
        }
        if (configLocation != null) {
            L.info("Configuration folder location: {}", (Object)configLocation);
            File uiPrefs = new File(configLocation, DEFAULT_PREFERENCES_DIRNAME);
            uiPrefs = new File(uiPrefs, "org.eclipse.ui.ide.prefs");
            L.info("record of eclipse ui ide prefs location: {}", (Object)uiPrefs);
            if (uiPrefs.exists()) {
                wkLocation = PathUtils.getLastWorkspaceLocation(uiPrefs);
            } else {
                L.debug("File doesn't exist: {}", (Object)uiPrefs);
            }
        }
        if (wkLocation == null) {
            L.info("Custom location lookup failed, falling back to default implementation.");
            wkLocation = Platform.getLocation().toFile();
        }
        L.info("Workspace: {}", wkLocation);
        return wkLocation;
    }

    public static Properties getInstallProperties() {
        Properties instProp;
        block12: {
            instProp = new Properties();
            FileInputStream inStream = null;
            try {
                try {
                    String pathInPlugin = "/static/install.properties";
                    File output = new File(METADATA_FOLDER, pathInPlugin);
                    PathUtils.copyResource("com.ez.internal", pathInPlugin, METADATA_FOLDER);
                    inStream = new FileInputStream(output.getAbsolutePath());
                    instProp.load(inStream);
                }
                catch (Exception e) {
                    L.error("getInstallProperties()", (Throwable)e);
                    InternalLogUtil.err(Messages.getString(PathUtils.class, "install.properties.error.message"), e);
                    if (inStream == null) break block12;
                    try {
                        inStream.close();
                    }
                    catch (IOException e2) {
                        L.warn("could not close stream ", (Throwable)e2);
                    }
                }
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        L.warn("could not close stream ", (Throwable)e);
                    }
                }
            }
        }
        return instProp;
    }

    public static Properties getDeployedVersions() {
        Properties versionProperties;
        block12: {
            versionProperties = new Properties();
            FileInputStream inputStream = null;
            try {
                try {
                    String pathInPlugin = "/static/versions.properties";
                    File verFile = new File(METADATA_FOLDER, pathInPlugin);
                    inputStream = new FileInputStream(verFile.getAbsolutePath());
                    versionProperties.load(inputStream);
                }
                catch (Exception e) {
                    L.error("getDeployedVersions()", (Throwable)e);
                    if (inputStream == null) break block12;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        L.warn("could not close stream ", (Throwable)e2);
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        L.warn("could not close stream ", (Throwable)e);
                    }
                }
            }
        }
        return versionProperties;
    }

    public static boolean updateDeployedVersion(String versionKey) {
        boolean res;
        block13: {
            res = false;
            FileOutputStream out = null;
            try {
                try {
                    Properties p = PathUtils.getDeployedVersions();
                    Object versionVal = PathUtils.getPackagedVersions().get(versionKey);
                    if (versionVal != null) {
                        p.put(versionKey, versionVal);
                    }
                    String pathInPlugin = "/static/versions.properties";
                    out = new FileOutputStream(new File(METADATA_FOLDER, pathInPlugin));
                    p.store(out, "Static resources versions");
                    res = true;
                }
                catch (Exception e) {
                    L.error("updateDeployedVersions", (Throwable)e);
                    InternalLogUtil.err(Messages.getString(PathUtils.class, "update.versions.error.message"), e);
                    if (out == null) break block13;
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        L.warn("could not close stream ", (Throwable)e2);
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        L.warn("could not close stream ", (Throwable)e);
                    }
                }
            }
        }
        return res;
    }

    public static Properties getPackagedVersions() {
        block13: {
            if (packagedVersions == null) {
                packagedVersions = new Properties();
                FileInputStream inStream = null;
                try {
                    try {
                        URL u = new URL("platform:/plugin/com.ez.internal/static/versions.properties");
                        L.debug("url: {}", (Object)u);
                        URI vfUri = FileLocator.resolve((URL)u).toURI();
                        L.debug("uri: {}", (Object)vfUri);
                        inStream = new FileInputStream(new File(vfUri));
                        packagedVersions.load(inStream);
                    }
                    catch (Exception e) {
                        L.error("getPackagedVersions()", (Throwable)e);
                        if (inStream == null) break block13;
                        try {
                            inStream.close();
                        }
                        catch (IOException e2) {
                            L.warn("could not close stream ", (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            L.warn("could not close stream ", (Throwable)e);
                        }
                    }
                }
            }
        }
        return packagedVersions;
    }

    protected static boolean needsUpdate(String resourceKey) {
        Properties depVer = PathUtils.getDeployedVersions();
        try {
            int pNo;
            int dNo;
            Object deployedV = depVer.get(resourceKey);
            Object packagedV = PathUtils.getPackagedVersions().get(resourceKey);
            if (deployedV != null && packagedV != null && (dNo = Integer.parseInt(deployedV.toString())) >= (pNo = Integer.parseInt(packagedV.toString()))) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            L.warn("Could not compare versions for {}", (Object)resourceKey, (Object)e);
        }
        return true;
    }

    public static void copyResource(String pluginId, String pathInPlugin, File toFolder) {
        File dest = new File(toFolder, pathInPlugin);
        PathUtils.copyResource(pluginId, pathInPlugin, toFolder, dest);
    }

    public static void copyResource(String pluginId, String pathInPlugin, File toFolder, File dest) {
        block8: {
            try {
                String pluginPath = String.valueOf(pluginId) + (pathInPlugin.startsWith("/") ? pathInPlugin : "/" + pathInPlugin);
                if (!PathUtils.needsUpdate(pluginPath)) break block8;
                String urlText = "platform:/plugin/" + pluginPath;
                L.debug("url text: {}", (Object)urlText);
                URL url = new URL(urlText);
                URL url2 = null;
                try {
                    url2 = FileLocator.resolve((URL)url);
                }
                catch (Exception e) {
                    L.warn("Can't resolve resource: {}:{}", new Object[]{pluginId, pathInPlugin, e});
                    LogUtil.displayErrorMessage(null, Messages.getString(PathUtils.class, "resolve.resource.error.message", new String[]{pluginId, pathInPlugin}), (Plugin)Activator.getDefault(), false);
                }
                if (url2 != null) {
                    String protocol = url2.getProtocol();
                    L.debug("url2:{}", (Object)url2);
                    if (protocol.equals("file")) {
                        URI uri = new File(url2.getFile()).toURI();
                        L.debug("uri: {}", (Object)uri);
                        IFileStore sStore = EFS.getStore((URI)uri);
                        new File(dest.getParent()).mkdirs();
                        IFileStore dStore = EFS.getLocalFileSystem().getStore(dest.toURI());
                        sStore.copy(dStore, 2, (IProgressMonitor)new NullProgressMonitor());
                    } else if (protocol.equals("jar")) {
                        PathUtils.extract(url2, toFolder.getAbsolutePath());
                    }
                    PathUtils.updateDeployedVersion(pluginPath);
                }
            }
            catch (Exception e) {
                L.error("copyResource()", (Throwable)e);
                LogUtil.displayErrorMessage((Throwable)e, Messages.getString(PathUtils.class, "copy.resource.error.message", new String[]{pluginId, pathInPlugin}), (Plugin)Activator.getDefault(), false);
            }
        }
    }

    private static void extract(URL jarUrl, String where) throws IOException {
        if (!jarUrl.getProtocol().equals("jar")) {
            throw new IllegalArgumentException("wrong url protocol. requires \"jar\". " + jarUrl.getProtocol());
        }
        String path = jarUrl.getFile();
        L.debug("handling path {}", (Object)path);
        int idx = path.indexOf("!");
        String jarName = new URL(path.substring(0, idx)).getFile();
        String resName = path.substring(idx + 2);
        PathUtils.extract(jarName, resName, where);
    }

    private static void extract(String jarFile, String what, String where) throws IOException {
        L.debug("extracting: {} # {} # {}", new Object[]{jarFile, what, where});
        JarFile jar = new JarFile(jarFile);
        JarEntry entry = jar.getJarEntry(what);
        if (entry == null) {
            throw new FileNotFoundException(String.valueOf(what) + " was not found in " + jarFile);
        }
        if (entry.isDirectory()) {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry file = e.nextElement();
                if (!file.getName().startsWith(what)) continue;
                try (InputStream is = null;){
                    is = jar.getInputStream(file);
                    PathUtils.copyStream(is, where, file.getName());
                }
            }
        } else {
            try (InputStream is = null;){
                is = jar.getInputStream(entry);
                PathUtils.copyStream(is, where, entry.getName());
                is.close();
            }
        }
    }

    private static void copyStream(InputStream is, String where, String as) throws IOException {
        if (is.available() > 0) {
            File f = new File(where, as);
            new File(f.getParent()).mkdirs();
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(f);
                byte[] buffer = new byte[4096];
                int length = 0;
                while ((length = is.read(buffer)) > 0) {
                    fos.write(buffer, 0, length);
                }
            }
        }
    }

    public static File copyStaticResource(String pluginId, String pathInPlugin, String systemProperty, boolean overwrite, File output) {
        if (output == null) {
            output = new File(METADATA_FOLDER, pathInPlugin);
        }
        if (overwrite || !output.exists()) {
            PathUtils.copyResource(pluginId, pathInPlugin, METADATA_FOLDER);
        }
        if (systemProperty != null && output.isFile()) {
            String prop = System.getProperty(systemProperty);
            System.setProperty(systemProperty, String.valueOf(prop != null ? String.valueOf(prop) + File.pathSeparator : "") + output.getParent());
            L.debug("{}:{}", (Object)systemProperty, (Object)System.getProperty(systemProperty));
        }
        return output;
    }

    public static File copyStaticResource(String pluginId, String pathInPlugin, String systemProperty, boolean overwrite) {
        return PathUtils.copyStaticResource(pluginId, pathInPlugin, systemProperty, overwrite, null);
    }

    private static File getLastWorkspaceLocation(File filePath) {
        Properties prop = new Properties();
        Boolean lineFound = false;
        String path = "";
        FileInputStream input = null;
        try {
            input = new FileInputStream(filePath);
            prop.load(input);
            L.debug("RECENT_WORKSPACES: {}", (Object)prop.getProperty("RECENT_WORKSPACES"));
            if (prop.containsKey("RECENT_WORKSPACES")) {
                String line = prop.getProperty("RECENT_WORKSPACES");
                int start = 0;
                int end = line.indexOf("\n");
                if (end > -1) {
                    path = line.substring(start, end);
                    lineFound = true;
                }
            }
        }
        catch (IOException e) {
            L.error("Unexpected error.", (Throwable)e);
        }
        if (lineFound.booleanValue()) {
            return new File(path);
        }
        return null;
    }
}

