/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import com.ez.internal.utils.PathMappingUtils;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMapping {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static final Logger L = LoggerFactory.getLogger(PathMapping.class);

    public static String convertFromMapped(String path) {
        String rez = path;
        Properties mounts = PathMapping.getDrivesMapping();
        if (mounts != null) {
            for (Object ko : mounts.keySet()) {
                String ro = (String)ko;
                String lp = mounts.getProperty(ro);
                if (!path.startsWith(lp)) continue;
                rez = String.valueOf(ro) + path.substring(lp.length());
                rez = rez.replaceAll("/", "\\\\");
                break;
            }
        }
        return rez;
    }

    public static Properties getDrivesMapping() {
        return PathMappingUtils.getDrivesMapping(null);
    }

    public static String convertToMapped(String path) {
        String rez = path;
        Properties mounts = PathMapping.getDrivesMapping();
        if (mounts != null) {
            String slashes = path.replaceAll("\\\\", "/");
            IPath targetUpper = Path.fromPortableString((String)slashes.toUpperCase());
            IPath target = Path.fromPortableString((String)slashes);
            for (Object ro : mounts.keySet()) {
                String rp = (String)ro;
                IPath rPath = Path.fromPortableString((String)rp.toUpperCase().replaceAll("\\\\", "/"));
                if (!rPath.isPrefixOf(targetUpper)) continue;
                rez = mounts.getProperty(rp);
                IPath mapped = Path.fromPortableString((String)rez.replaceAll("\\\\", "/"));
                IPath newPath = mapped.append(target.removeFirstSegments(rPath.segmentCount()));
                rez = newPath.toOSString();
                break;
            }
        }
        return rez;
    }
}

