/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public interface MapFilter<K, V> {
    public boolean filter(Map<? extends K, ? extends V> var1);

    public static class AndMapFilter<K, V>
    implements MapFilter<K, V> {
        private Collection<? extends MapFilter<K, V>> fs;

        public AndMapFilter(Collection<? extends MapFilter<K, V>> fs) {
            if (fs == null) {
                fs = new HashSet<MapFilter<K, V>>();
            }
            this.fs = fs;
        }

        public AndMapFilter(MapFilter<K, V> f1, MapFilter<K, V> f2) {
            this.fs = Arrays.asList(f1, f2);
        }

        public static <K, V> MapFilter<K, V> createFilter(Collection<? extends MapFilter<K, V>> fs) {
            return new AndMapFilter<K, V>(fs);
        }

        public static <K, V> MapFilter<K, V> createFilter(MapFilter<K, V> f1, MapFilter<K, V> f2) {
            return new AndMapFilter<K, V>(f1, f2);
        }

        @Override
        public boolean filter(Map<? extends K, ? extends V> values) {
            boolean result = this.fs.size() > 0;
            for (MapFilter<? extends K, ? extends V> mapFilter : this.fs) {
                boolean bl = result = result && mapFilter.filter(values);
            }
            return result;
        }
    }

    public static class EmptyStringMapFilter<K, V>
    implements MapFilter<K, V> {
        private K key;

        public EmptyStringMapFilter(K key) {
            this.key = key;
        }

        public static <K, V> MapFilter<K, V> createFilter(K key) {
            return new EmptyStringMapFilter<K, V>(key);
        }

        @Override
        public boolean filter(Map<? extends K, ? extends V> values) {
            boolean retVal;
            V value = values.get(this.key);
            boolean bl = retVal = value == null;
            if (!retVal) {
                if (value instanceof String) {
                    retVal = ((String)value).isEmpty();
                } else {
                    throw new IllegalArgumentException("String expected for value corresponding to key " + this.key);
                }
            }
            return retVal;
        }
    }

    public static class NullMapFilter<K, V>
    implements MapFilter<K, V> {
        private K key;

        public NullMapFilter(K key) {
            this.key = key;
        }

        public static <K, V> MapFilter<K, V> createFilter(K key) {
            return new NullMapFilter<K, V>(key);
        }

        @Override
        public boolean filter(Map<? extends K, ? extends V> values) {
            V value = values.get(this.key);
            return value == null;
        }
    }

    public static class OrMapFilter<K, V>
    implements MapFilter<K, V> {
        private Collection<? extends MapFilter<K, V>> fs;

        public OrMapFilter(Collection<? extends MapFilter<K, V>> fs) {
            if (fs == null) {
                fs = new HashSet<MapFilter<K, V>>();
            }
            this.fs = fs;
        }

        public OrMapFilter(MapFilter<K, V> f1, MapFilter<K, V> f2) {
            this.fs = Arrays.asList(f1, f2);
        }

        public static <K, V> MapFilter<K, V> createFilter(Collection<? extends MapFilter<K, V>> fs) {
            return new OrMapFilter<K, V>(fs);
        }

        public static <K, V> MapFilter<K, V> createFilter(MapFilter<K, V> f1, MapFilter<K, V> f2) {
            return new OrMapFilter<K, V>(f1, f2);
        }

        @Override
        public boolean filter(Map<? extends K, ? extends V> values) {
            boolean result = false;
            for (MapFilter<? extends K, ? extends V> mapFilter : this.fs) {
                boolean bl = result = result || mapFilter.filter(values);
            }
            return result;
        }
    }
}

