/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import com.ez.internal.Activator;
import com.ez.internal.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(LogUtil.class);

    public static void log(int status, String message) {
        LogUtil.log(status, message, null, null);
    }

    public static void log(int status, String message, Throwable t, Bundle b) {
        try {
            if (b == null) {
                b = FrameworkUtil.getBundle(LogUtil.class);
            }
            Platform.getLog((Bundle)b).log((IStatus)new Status(status, b.getSymbolicName(), message, t));
        }
        catch (Exception exception) {
            L.error("Can't get log.");
        }
    }

    @Deprecated
    public static void displayErrorMessage(Throwable t, String msg, String title, Plugin bundle) {
        LogUtil.displayErrorMessage(t, msg, title, bundle, true);
    }

    @Deprecated
    public static void displayErrorMessage(Throwable t, String msg, String title, Plugin sbundle, boolean showDialog) {
        Activator bundle = null;
        bundle = sbundle == null ? Activator.getDefault() : sbundle;
        MultiStatus errorStatus = LogUtil.getServiceInfo(t, 4, msg, bundle.getBundle());
        LogUtil.displayErrorMessage((Status)errorStatus, showDialog);
    }

    public static void displayErrorMessage(Throwable t, String msg, Plugin bundle) {
        LogUtil.displayErrorMessage(t, msg, bundle, true);
    }

    public static void displayErrorMessage(Throwable t, String msg, Plugin sbundle, boolean showDialog) {
        Activator bundle = null;
        bundle = sbundle == null ? Activator.getDefault() : sbundle;
        MultiStatus errorStatus = LogUtil.getServiceInfo(t, 4, msg, bundle.getBundle());
        LogUtil.displayErrorMessage((Status)errorStatus, showDialog);
    }

    public static MultiStatus getServiceInfo(Throwable t, int severity, Bundle bundle) {
        return LogUtil.getServiceInfo(t, severity, null, bundle);
    }

    public static MultiStatus getServiceInfo(Throwable t, int severity, String msg, Bundle bundle) {
        String message;
        String symbolicName = bundle.getSymbolicName();
        String bundleName = ((String)bundle.getHeaders().get("Bundle-Name")).toString();
        String bundleVendor = ((String)bundle.getHeaders().get("Bundle-Vendor")).toString();
        String bundleVersion = ((String)bundle.getHeaders().get("Bundle-Version")).toString();
        String string = message = msg != null && !msg.isEmpty() ? msg : Messages.getString(LogUtil.class, "service.info.message");
        if ((msg == null || msg.isEmpty()) && t != null && t.getMessage() != null && !t.getMessage().trim().isEmpty()) {
            message = t.getMessage();
        }
        MultiStatus vitalInfoStatus = new MultiStatus(symbolicName, severity, message, t);
        vitalInfoStatus.add((IStatus)LogUtil.createStatus(severity, Messages.getString(LogUtil.class, "plugin.vendor.name", new String[]{bundleVendor}), bundle));
        vitalInfoStatus.add((IStatus)LogUtil.createStatus(severity, Messages.getString(LogUtil.class, "plugin.name", new String[]{bundleName}), bundle));
        vitalInfoStatus.add((IStatus)LogUtil.createStatus(severity, Messages.getString(LogUtil.class, "plugin.id", new String[]{symbolicName}), bundle));
        vitalInfoStatus.add((IStatus)LogUtil.createStatus(severity, Messages.getString(LogUtil.class, "bundle.version", new String[]{bundleVersion}), bundle));
        return vitalInfoStatus;
    }

    protected static Status createStatus(int severity, String msg, Bundle bundle) {
        return LogUtil.createStatus(severity, bundle, msg, null);
    }

    public static Status createStatus(int severity, Bundle bundle, String msg, Throwable error) {
        if (bundle == null) {
            bundle = Activator.getDefault().getBundle();
        }
        Status status = new Status(severity, bundle.getSymbolicName(), 0, msg, error);
        return status;
    }

    public static void displayErrorMessage(Status status, boolean showDialog) {
        int style = 1;
        if (showDialog) {
            style |= 2;
        }
        StatusManager.getManager().handle((IStatus)status, style);
    }
}

