/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ErrorUtils.class);

    public static void handleExecutionException(ExecutionException executionException) {
        ErrorUtils.handleWrapperRuntimeExceptionAndError(executionException);
    }

    public static <T extends Throwable> void handleExecutionException(ExecutionException executionException, Class<T> clazz) throws T {
        ErrorUtils.handleWrapperRuntimeExceptionAndError(executionException);
        ErrorUtils.handleWrapperException(executionException, clazz);
    }

    public static void handleWrapperRuntimeExceptionAndError(Throwable t) {
        ErrorUtils.handleWrapperException(t, RuntimeException.class);
        ErrorUtils.handleWrapperException(t, Error.class);
    }

    public static <T extends Throwable> void handleWrapperException(Throwable t, Class<T> clazz) throws T {
        if (t == null) {
            throw new IllegalArgumentException("exception must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must not be null");
        }
        Throwable cause = t.getCause();
        Throwable rethrown = ErrorUtils.generateRethrownCause(t);
        if (cause == null || clazz.isAssignableFrom(cause.getClass())) {
            if (rethrown != null) {
                throw rethrown;
            }
            if (cause == null) {
                throw new IllegalStateException("", t);
            }
            if (cause instanceof Error) {
                throw new Error(cause.getMessage(), t);
            }
            throw new IllegalStateException(cause.getMessage(), t);
        }
    }

    private static Throwable generateRethrownCause(Throwable t) {
        Throwable cause = t.getCause();
        Throwable rethrown = null;
        if (cause != null) {
            try {
                rethrown = (Throwable)cause.getClass().getConstructor(String.class, Throwable.class).newInstance(cause.getMessage(), t);
            }
            catch (InstantiationException e) {
                L.debug("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                L.debug("", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                L.debug("", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                L.debug("no constructor with parametters (String.class, Throwable.class) for exception {}", cause.getClass(), (Object)e);
            }
            catch (SecurityException e) {
                L.debug("", (Throwable)e);
            }
        }
        return rethrown;
    }

    private static void test() throws InterruptedException {
        System.out.println("test1: expected no exception because handleExecutionException is done only on RuntimeException and Errors");
        Thread.sleep(1000L);
        try {
            throw new ExecutionException("test", new IOException("exception test"));
        }
        catch (ExecutionException e) {
            try {
                ErrorUtils.handleExecutionException(e);
            }
            catch (Exception e1) {
                L.error("Error:", (Throwable)e1);
            }
            Thread.sleep(1000L);
            System.out.println();
            System.out.println("test2: expected IOException");
            Thread.sleep(1000L);
            try {
                throw new ExecutionException("test", new IOException("exception test"));
            }
            catch (ExecutionException e2) {
                try {
                    ErrorUtils.handleWrapperException(e2, IOException.class);
                }
                catch (IOException e1) {
                    L.error("Error:", (Throwable)e1);
                }
                Thread.sleep(1000L);
                System.out.println();
                System.out.println("test3: expected IllegalStateException because of null error cause");
                Thread.sleep(1000L);
                try {
                    throw new ExecutionException("test", null);
                }
                catch (ExecutionException e3) {
                    try {
                        ErrorUtils.handleExecutionException(e3, IOException.class);
                    }
                    catch (IOException e1) {
                        L.error("Error:", (Throwable)e1);
                    }
                    catch (Throwable e1) {
                        L.error("Error:", e1);
                    }
                    Thread.sleep(1000L);
                    System.out.println();
                    System.out.println("test4: expected IllegalArgumentException");
                    Thread.sleep(1000L);
                    try {
                        throw new ExecutionException("test", new IllegalArgumentException("exception test"));
                    }
                    catch (ExecutionException e4) {
                        try {
                            ErrorUtils.handleExecutionException(e4);
                        }
                        catch (RuntimeException e1) {
                            L.error("Error:", (Throwable)e1);
                        }
                        Thread.sleep(1000L);
                        System.out.println();
                        System.out.println("test5: expected Error since OutOfMemoryError can not have cause");
                        Thread.sleep(1000L);
                        try {
                            throw new ExecutionException("test", new OutOfMemoryError("exception test"));
                        }
                        catch (ExecutionException e5) {
                            try {
                                ErrorUtils.handleExecutionException(e5);
                            }
                            catch (Throwable e1) {
                                L.error("Error:", e1);
                            }
                            System.out.println();
                            return;
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
        ErrorUtils.test();
    }
}

