/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVWriter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CSVWriter.class);
    private File where;
    private Writer w = null;
    private String separator = ",";
    private boolean isExportOK = true;

    private CSVWriter(File where) {
        this.where = where;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void write(String ... entries) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (!first) {
                sb.append(this.separator);
            }
            first = false;
            sb.append(entry);
            ++n2;
        }
        this.writeLine(sb.toString());
    }

    public void writeLine(String line) {
        try {
            this.w.write(line);
            this.w.write("\r\n");
        }
        catch (IOException iOException) {
            this.isExportOK = false;
            L.error("could not write into " + this.where);
        }
    }

    public static CSVWriter open(File where) {
        return CSVWriter.open(where, false);
    }

    public static CSVWriter open(File where, boolean append) {
        CSVWriter csvWriter = new CSVWriter(where);
        String csvEncoding = System.getProperty("csvEncoding", null);
        try {
            csvWriter.w = csvEncoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(where, append), csvEncoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(where, append)));
        }
        catch (IOException iOException) {
            L.error("could not open " + where);
            csvWriter = null;
        }
        return csvWriter;
    }

    public void close() {
        if (this.w != null) {
            try {
                this.w.close();
            }
            catch (IOException iOException) {
                this.isExportOK = false;
                L.error("could not close stream for " + this.where);
            }
        }
    }

    public boolean isExportOK() {
        return this.isExportOK;
    }
}

