/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.model;

import com.ez.internal.analysis.config.inputs.EZObjectType;
import java.io.Serializable;
import org.eclipse.core.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EZProxy
implements Serializable {
    private static final Logger L = LoggerFactory.getLogger(EZProxy.class);
    protected IResource resource;

    public IResource getResource() {
        return this.resource;
    }

    public String getName() {
        String name = "";
        if (this.resource != null) {
            name = this.resource.getProjectRelativePath().removeFileExtension().toOSString();
        } else {
            L.warn("proxy has null resource");
        }
        return name;
    }

    public String getResourceName() {
        return this.resource.getName();
    }

    public abstract int getType();

    public abstract String getStringType();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EZProxy other = (EZProxy)obj;
        return this.getName().equals(other.getName());
    }

    public Object clone() {
        try {
            EZProxy cloned = (EZProxy)this.getClass().newInstance();
            cloned.resource = this.resource;
            return cloned;
        }
        catch (InstantiationException e) {
            L.error("clone()", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            L.error("clone()", (Throwable)e);
        }
        return null;
    }

    public abstract EZObjectType getInputType4Annotations();
}

