/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.id;

import com.ez.internal.id.EZSegment;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;

public class EZEntityID
implements Cloneable,
IAdaptable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private List<EZSegment> segments = new ArrayList<EZSegment>();

    public void addSegment(EZSegment segment) {
        this.segments.add(segment);
    }

    public List<EZSegment> getSegments() {
        return this.segments;
    }

    public void addEntitySegments(EZEntityID entity) {
        if (entity != null) {
            this.segments.addAll(entity.segments);
        }
    }

    public EZSegment getSegment(Class type) {
        EZSegment ret = null;
        for (EZSegment segment : this.segments) {
            if (!segment.isOfType(type)) continue;
            ret = segment;
            break;
        }
        return ret;
    }

    public void removeSegments(Class type) {
        ArrayList<EZSegment> sgTypes = new ArrayList<EZSegment>();
        for (EZSegment segment : this.segments) {
            if (!segment.isOfType(type)) continue;
            sgTypes.add(segment);
        }
        this.segments.removeAll(sgTypes);
    }

    public EZEntityID clone() throws CloneNotSupportedException {
        EZEntityID clone = new EZEntityID();
        clone.segments.addAll(this.segments);
        return clone;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EZEntityID.class) {
            return this;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EZEntityID other = (EZEntityID)obj;
        return !(this.segments == null ? other.segments != null : !this.segments.equals(other.segments));
    }

    public int hashCode() {
        return 1;
    }
}

