/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.file;

import com.ez.internal.file.BufferedRandomAccessFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.TreeMap;

public class LineFileReader
implements Closeable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private File file;
    private BufferedRandomAccessFile raf;
    private TreeMap<Long, Long[]> lineIdx;
    private long lines;
    boolean indexed = false;

    public LineFileReader(File f) throws IOException {
        this.file = f;
        this.raf = new BufferedRandomAccessFile(f, "r", Charset.defaultCharset());
        this.lineIdx = new TreeMap();
    }

    public LineFileReader(File f, Charset charset) throws IOException {
        this.file = f;
        this.raf = new BufferedRandomAccessFile(f, "r", charset);
        this.lineIdx = new TreeMap();
    }

    public LineFileReader(File f, TreeMap<Long, Long[]> lineIndexes, Charset charset) throws IOException {
        this.file = f;
        this.raf = new BufferedRandomAccessFile(f, "r", charset);
        if (lineIndexes != null) {
            this.lineIdx = lineIndexes;
            this.lines = lineIndexes.size();
            this.indexed = true;
        } else {
            this.index();
        }
    }

    public void index() throws IOException {
        this.raf.seek(0L);
        long end = this.file.length();
        Long charIdx = 0L;
        Long lineNr = 0L;
        while (this.raf.getFilePointer() < end) {
            this.lineIdx.put(lineNr, new Long[]{charIdx, this.raf.getFilePointer()});
            String[] line = this.raf.getNextLine();
            if (line[0] == null || line[1] == null) continue;
            charIdx = charIdx + (long)(line[0].length() + line[1].length());
            lineNr = lineNr + 1L;
        }
        this.lines = lineNr;
        this.indexed = true;
    }

    public TreeMap<Long, Long[]> getLineIndexes() throws IOException {
        if (!this.indexed) {
            this.index();
        }
        return this.lineIdx;
    }

    public long getLineCount() throws IOException {
        if (!this.indexed) {
            this.index();
        }
        return this.lines;
    }

    public Object[] getLine(long lineNr) throws IOException {
        if (!this.indexed) {
            this.index();
        }
        Object[] ret = new Object[]{null, null};
        Long[] lv = this.lineIdx.get(lineNr);
        if (lv != null) {
            this.raf.seek(lv[1]);
            String[] line = this.raf.getNextLine();
            if (line != null) {
                ret[0] = line[0];
                ret[1] = lv[0];
            }
        }
        return ret;
    }

    public Object[] getLineOfChar(long charIdx) throws IOException {
        if (!this.indexed) {
            this.index();
        }
        Object[] ret = new Object[]{null, null, null};
        long line = 0L;
        for (Long[] lv : this.lineIdx.values()) {
            if (lv[0] > charIdx) break;
            this.raf.seek(lv[1]);
            String[] l = this.raf.getNextLine();
            if (l != null) {
                ret[0] = l[0];
                ret[1] = line;
                ret[2] = charIdx - lv[0];
            }
            ++line;
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }
}

