/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_BUF_SIZE = 256;
    private static final int LINE_LENGTH = 256;
    private final int bufSize;
    private Charset charset;
    private byte[] buf;
    private int bEnd = 0;
    private int bIdx = 0;
    private long idx = 0L;

    public BufferedRandomAccessFile(File file, String mode, Charset charset) throws IOException {
        this(file, mode, 256, charset);
    }

    public BufferedRandomAccessFile(String filename, String mode, Charset charset) throws IOException {
        this(filename, mode, 256, charset);
    }

    public BufferedRandomAccessFile(File file, String mode, int bufSize, Charset charset) throws IOException {
        super(file, mode);
        this.invalidate();
        this.bufSize = bufSize;
        this.buf = new byte[bufSize];
        this.charset = charset;
    }

    public BufferedRandomAccessFile(String filename, String mode, int bufSize, Charset charset) throws IOException {
        super(filename, mode);
        this.invalidate();
        this.bufSize = bufSize;
        this.buf = new byte[bufSize];
        this.charset = charset;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.idx - (long)this.bEnd + (long)this.bIdx;
    }

    public final String[] getNextLine() throws IOException {
        return this.getNextLine(this.charset);
    }

    public final String[] getNextLine(Charset charset) throws IOException {
        String[] ret = new String[]{null, null};
        if (this.bEnd - this.bIdx <= 0 && this.fillBuffer() < 0) {
            return ret;
        }
        int lineEnd = -1;
        int i = this.bIdx;
        while (i < this.bEnd) {
            if (this.buf[i] == 10) {
                lineEnd = i;
                break;
            }
            ++i;
        }
        if (lineEnd < 0) {
            int c;
            byte[] bytes = new byte[256];
            int byteIdx = 0;
            StringBuilder el = new StringBuilder();
            while ((c = this.read()) != -1 && c != 10) {
                if ((char)c != '\r') {
                    if (byteIdx + 1 >= bytes.length) continue;
                    bytes[byteIdx++] = (byte)c;
                    continue;
                }
                el.append((char)c);
            }
            if (c == -1 && byteIdx == 0) {
                return ret;
            }
            el.append((char)c);
            ret[0] = new String(bytes, 0, byteIdx, charset);
            ret[1] = el.toString();
            return ret;
        }
        if (lineEnd > 0 && this.buf[lineEnd - 1] == 13) {
            ret[0] = new String(this.buf, this.bIdx, lineEnd - this.bIdx - 1, charset);
            ret[1] = "\r\n";
        } else {
            ret[0] = new String(this.buf, this.bIdx, lineEnd - this.bIdx, charset);
            ret[1] = "\n";
        }
        this.bIdx = lineEnd + 1;
        return ret;
    }

    @Override
    public final int read() throws IOException {
        if (this.bIdx >= this.bEnd && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.bEnd == 0) {
            return -1;
        }
        return this.buf[this.bIdx++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int unread = this.bEnd - this.bIdx;
        if (len <= unread) {
            System.arraycopy(this.buf, this.bIdx, b, off, len);
            this.bIdx += len;
            return len;
        }
        int i = 0;
        while (i < len) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            b[off + i] = (byte)c;
            ++i;
        }
        return len;
    }

    @Override
    public void seek(long pos) throws IOException {
        int n = (int)(this.idx - pos);
        if (n >= 0 && n <= this.bEnd) {
            this.bIdx = this.bEnd - n;
        } else {
            super.seek(pos);
            this.invalidate();
        }
    }

    private int fillBuffer() throws IOException {
        int n = super.read(this.buf, 0, this.bufSize);
        if (n >= 0) {
            this.idx += (long)n;
            this.bEnd = n;
            this.bIdx = 0;
        }
        return n;
    }

    private void invalidate() throws IOException {
        this.bEnd = 0;
        this.bIdx = 0;
        this.idx = super.getFilePointer();
    }
}

