/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.analysis.config.inputs.generator;

import com.ez.internal.analysis.config.inputs.generator.DataMappingStore;
import com.ez.internal.analysis.config.inputs.generator.MappingKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectTypeInstanceGenerator<T>
extends DataMappingStore<Class<? extends T>> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ObjectTypeInstanceGenerator.class);

    public ObjectTypeInstanceGenerator() {
        this(null);
    }

    public ObjectTypeInstanceGenerator(String defaultType) {
        super(defaultType);
    }

    public T createInstance(Integer prgTypeId) {
        if (this.getDefaultType() == null) {
            throw new UnsupportedOperationException("Method can't be used since " + this.getClass().getSimpleName() + "has no default type. Use getObject(Integer prgTypeId, String type) instead.");
        }
        return this.createInstance(prgTypeId, this.getDefaultType());
    }

    public T createInstance(Integer prgTypeId, String type) {
        return this.createInstance(new MappingKey<Integer>(prgTypeId, type));
    }

    public T createInstance(MappingKey<Integer> mappingKey) {
        Class clazz = (Class)this.getObject(mappingKey);
        if (clazz == null) {
            throw new IllegalStateException("No class for id= " + mappingKey.getId() + " and type " + mappingKey.getType());
        }
        return this.createInstance(clazz);
    }

    private T createInstance(Class<? extends T> clazz) {
        T ezObjectType = null;
        if (clazz == null) {
            throw new IllegalArgumentException("The provided class must not be null");
        }
        try {
            ezObjectType = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            L.debug("InstantiationException for class {}", (Object)clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            L.debug("IllegalAccessException for class {}", (Object)clazz.getName());
        }
        return ezObjectType;
    }
}

