/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.analysis.config.inputs.generator;

import com.ez.internal.analysis.config.inputs.generator.DataMappingStore;
import com.ez.internal.analysis.config.inputs.generator.MappingKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class DoubleLinkedDataMappingStore<T>
extends DataMappingStore<T> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final Map<MappingKey<T>, Set<Integer>> reverseObjectTypeMap = new HashMap<MappingKey<T>, Set<Integer>>();

    public DoubleLinkedDataMappingStore() {
        this(null);
    }

    public DoubleLinkedDataMappingStore(String defaultType) {
        super(defaultType);
    }

    @Override
    protected void addMapping(int id, String type, T object) {
        super.addMapping(id, type, object);
        this.addReverseMapping(new MappingKey<T>(object, type), id);
    }

    private void addReverseMapping(MappingKey<T> mappingKey, Integer id) {
        Set<Integer> set = null;
        set = this.reverseObjectTypeMap.get(mappingKey);
        if (set == null) {
            set = new HashSet<Integer>();
        }
        set.add(id);
        this.reverseObjectTypeMap.put(mappingKey, set);
    }

    public Set<Integer> getIdCollectionForObject(T object) {
        if (this.getDefaultType() == null) {
            throw new UnsupportedOperationException("Method can't be used since " + this.getClass().getSimpleName() + "has no default type. Use getObject(Integer prgTypeId, String type) instead.");
        }
        return this.getIdCollectionForObject((Object)object, this.getDefaultType());
    }

    public Set<Integer> getIdCollectionForObject(T object, String type) {
        return this.reverseObjectTypeMap.get(new MappingKey<T>(object, type));
    }
}

