/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.analysis.config.inputs.generator;

import com.ez.internal.analysis.config.inputs.generator.MappingKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataMappingStore<T> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DataMappingStore.class);
    public static final int DEFAULT_ID = -1;
    private final Map<MappingKey<Integer>, T> objectTypeMap = new HashMap<MappingKey<Integer>, T>();
    private String defaultType;

    public DataMappingStore() {
        this(null);
    }

    public DataMappingStore(String defaultType) {
        this.defaultType = defaultType;
        this.register();
    }

    protected void addMapping(int id, String type, T object) {
        this.addMapping(new MappingKey<Integer>(id, type), object);
    }

    private void addMapping(MappingKey<Integer> mappingKey, T object) {
        if (mappingKey == null) {
            throw new UnsupportedOperationException("MappingKey must not be null");
        }
        if (object != null) {
            this.objectTypeMap.put(mappingKey, object);
        } else {
            L.warn("Null object");
        }
    }

    public T getObject(Integer prgTypeId) {
        if (this.getDefaultType() == null) {
            throw new UnsupportedOperationException("Method can't be used since " + this.getClass().getSimpleName() + "has no default type. Use getObject(Integer prgTypeId, String type) method instead.");
        }
        return this.getObject(prgTypeId, this.getDefaultType());
    }

    public T getObject(Integer prgTypeId, String type) {
        T object = null;
        if (type != null) {
            object = this.getObject(new MappingKey<Integer>(prgTypeId, type));
        }
        return object;
    }

    protected T getObject(MappingKey<?> key) {
        T object = this.getObjectTypeMap().get(key);
        if (object == null) {
            object = this.getDefaultObject(key);
        }
        return object;
    }

    public T getDefaultObject(MappingKey<?> mappingKey) {
        return null;
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    private Map<MappingKey<Integer>, T> getObjectTypeMap() {
        return this.objectTypeMap;
    }

    public Collection<String> getRegisterdTypes() {
        HashSet<String> registerdTypesCollection = new HashSet<String>();
        for (MappingKey<Integer> mappingKey : this.getObjectTypeMap().keySet()) {
            registerdTypesCollection.add(mappingKey.getType());
        }
        return registerdTypesCollection;
    }

    public Collection<Integer> getIdCollectionForType(String type) {
        HashSet<Integer> mappingKeyCollection = new HashSet<Integer>();
        for (MappingKey<Integer> mappingKey : this.getObjectTypeMap().keySet()) {
            if (!mappingKey.getType().equals(type)) continue;
            mappingKeyCollection.add(mappingKey.getId());
        }
        return mappingKeyCollection;
    }

    public Collection<Integer> getIdCollectionForObject(T object) {
        if (this.getDefaultType() == null) {
            throw new UnsupportedOperationException("Method can't be used since " + this.getClass().getSimpleName() + "has no default type. Use getObject(Integer prgTypeId, String type) instead.");
        }
        return this.getIdCollectionForObject(object, this.getDefaultType());
    }

    public Collection<Integer> getIdCollectionForObject(T object, String type) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Map.Entry<MappingKey<Integer>, T> objectTypeMapEntry : this.objectTypeMap.entrySet()) {
            MappingKey<Integer> mappingKey = objectTypeMapEntry.getKey();
            if (!type.equals(mappingKey.getType()) || !object.equals(objectTypeMapEntry.getValue())) continue;
            set.add(mappingKey.getId());
        }
        return set;
    }

    protected abstract void register();
}

