/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal;

import com.ez.internal.utils.PreferenceConstants;
import com.ibm.ad.internal.PasswordUtils;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "com.ez.internal";
    private static Activator plugin;
    private static ConcurrentMap<String, Properties> dbSettings;

    static {
        dbSettings = new ConcurrentHashMap<String, Properties>();
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PasswordUtils.decryptSystemProperties();
        System.setProperty("log4j.defaultInitOverride", "false");
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle().equals(Activator.this.getBundle()) && event.getType() == 2) {
                    PreferenceConstants.loadInstallPropFile();
                }
            }
        });
        L.debug("Internal started");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void addSettings(String server, Properties dbProp) {
        dbSettings.put(server, dbProp);
    }

    public Properties getDbSettings(String server) {
        return (Properties)dbSettings.get(server);
    }
}

