/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.mainframe.usage.catalogapi;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.internal.analysis.config.inputs.CatalogAPIInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.ProjectInfo;
import com.ibm.ez.analysis.api.model.APIRelatedNode;
import com.ibm.ez.analysis.api.model.ApiInterface;
import com.ibm.ez.analysis.api.model.CatalogAPISg;
import com.ibm.ez.analysis.api.model.Node;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class CatalogApiUsageTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public CatalogApiUsageTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        Map nodes = (Map)this.descriptor.getState().getData().get("apiNodes");
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap, nodes);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return null;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        Map<Integer, Node> nodes;

        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap, Map<Integer, Node> nodes) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
            this.nodes = nodes;
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElement resultElement;
                    String name;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    if (elemNameColumn == null) {
                        throw new IllegalArgumentException("No column for resource " + levelElementType);
                    }
                    String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (levelElementType.equals((Object)ResultElementType.CATALOG_TARGET)) {
                        Integer id = (Integer)r.getColumnValue(DatabaseMetadata.CATALOG_TARGET_ID.getName());
                        Integer typeId = (Integer)r.getColumnValue(DatabaseMetadata.CATALOG_TARGET_TYPE_ID.getName());
                        if (id != null) {
                            key = key.concat(id.toString());
                        }
                        if (typeId != null) {
                            key = key.concat(typeId.toString());
                        }
                    }
                    ResultElement resultElement2 = resultElement = key != null ? parent.getChild(key) : null;
                    if (resultElement == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        this.addElementInfo(resultElement, r);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(key, resultElement);
                    }
                    CatalogApiUsageTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                }
                ++levelIndex;
            }
            return true;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            Integer rowID = (Integer)r.getColumnValue(DatabaseMetadata.CATALOG_API_ID.getName());
            Node n = this.nodes.get(rowID);
            ProjectInfo pi = r.getProjectInfo();
            resultElement.addProperty("ProjectInfo", pi);
            switch (resultElement.getType()) {
                case PROJECT_INFO: {
                    n = null;
                    break;
                }
                case CATALOG_API: {
                    String apiName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CATALOG_API_NAME.getName()));
                    resultElement.addProperty(DatabaseMetadata.CATALOG_API_NAME.getName(), apiName);
                    n = ApiInterface.Type.API.equals((Object)n.getType()) ? n : (Node)n.getParent();
                    break;
                }
                case CATALOG_SERVICE: {
                    String serviceName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CATALOG_SERVICE_NAME.getName()));
                    resultElement.addProperty(DatabaseMetadata.CATALOG_SERVICE_NAME.getName(), serviceName);
                    break;
                }
                case CATALOG_TARGET: {
                    String ancestorName;
                    Integer id = (Integer)r.getColumnValue(DatabaseMetadata.CATALOG_TARGET_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.CATALOG_TARGET_ID.getName(), id);
                    String targetName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CATALOG_TARGET_NAME.getName()));
                    resultElement.addProperty(DatabaseMetadata.CATALOG_TARGET_NAME.getName(), targetName);
                    String tgType = (String)r.getColumnValue(DatabaseMetadata.CATALOG_TARGET_TYPE.getName());
                    resultElement.addProperty(DatabaseMetadata.CATALOG_TARGET_TYPE.getName(), tgType);
                    GenericProgramRelatedNode prgNodeElem = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.IMS_TRANSACTION.name());
                    resultElement.addProperty("Node_Mainframe", prgNodeElem);
                    Object prgTypeId = r.getColumnValue(DatabaseMetadata.CATALOG_TARGET_TYPE_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.CATALOG_TARGET_TYPE_ID.getName(), prgTypeId);
                    resultElement.addProperty("Program Type Id", prgTypeId);
                    String targetPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CATALOG_TARGET_PATH.getName()));
                    if (targetPath != null) {
                        resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), targetPath);
                        if (!targetPath.isEmpty()) {
                            Utils.setFileAttribute(resultElement, prgTypeId.toString(), targetPath, 0, 0);
                        }
                    }
                    if ((ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()))) != null && !ancestorName.isEmpty()) {
                        resultElement.addProperty("Ancestor Name", ancestorName);
                    }
                    Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR_ID.getName());
                    resultElement.addProperty("Ancestor Id", ancestorId);
                    ProgramUtils.getProgramTypeAsString(resultElement);
                    n = null;
                }
            }
            if (n != null) {
                resultElement.addProperty("Node_Mainframe", new APIRelatedNode((ApiInterface)n));
                CatalogAPIInputType apiInpt = new CatalogAPIInputType();
                EZEntityID apiID = new EZEntityID();
                apiID.addSegment((EZSegment)new CatalogAPISg((ApiInterface)n));
                apiInpt.setEntID(apiID);
                resultElement.addProperty("APPLICABLE_INPUT", apiInpt);
            }
        }
    }
}

