/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.mainframe.usage.catalogapi;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.FormatInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.AbstractUsageAnalysis;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.RecordsetProviderBuilder;
import com.ez.analysis.mainframe.usage.adapters.SerializationHandler;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.internal.GuiErrorLog;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.queries.CatalogApiUsageQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.NonBlockingOperationHandle;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ibm.ez.analysis.api.model.ApiInterface;
import com.ibm.ez.analysis.api.model.ApiTargetType;
import com.ibm.ez.analysis.api.model.IAPIFillerService;
import com.ibm.ez.analysis.api.model.Node;
import com.ibm.ez.analysis.mainframe.usage.catalogapi.CatalogApiFilter;
import com.ibm.ez.analysis.mainframe.usage.catalogapi.CatalogApiUsageTreeProvider;
import com.ibm.ez.analysis.mainframe.usage.catalogapi.State;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogApiUsageDescriptor
extends UsageDescriptorAdapter {
    private static final String ASTERISK = "*";
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(CatalogApiUsageDescriptor.class);
    static final String API_NODES_MAP = "apiNodes";
    static final String API_SEARCH_MAP = "apiResPart";
    public static final String MAINFRAME_API_USAGE = "com.ibm.ez.analysis.mainframe.usage.catalogapi";
    private static final String CATALOG_API_USAGE_FILTERS_FILE_NAME = "CatalogApiUsageFilters.properties";
    static final Map<String, List<ColumnInfo>> CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.CATALOG_API.name(), list);
            list.add(DatabaseMetadata.CATALOG_API_NAME);
            list = new ArrayList();
            this.put(ResultElementType.CATALOG_SERVICE.name(), list);
            list.add(DatabaseMetadata.CATALOG_SERVICE_NAME);
            list = new ArrayList();
            this.put(ResultElementType.CATALOG_TARGET.name(), list);
            list.add(DatabaseMetadata.CATALOG_TARGET_ID);
            list.add(DatabaseMetadata.CATALOG_TARGET_NAME);
            list.add(DatabaseMetadata.CATALOG_TARGET_TYPE);
            list.add(DatabaseMetadata.CATALOG_TARGET_TYPE_ID);
            list.add(DatabaseMetadata.CATALOG_TARGET_PATH);
        }
    };

    public CatalogApiUsageDescriptor(AbstractUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_API_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.state.getData().put("disable_limits", Boolean.TRUE);
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new CatalogApiUsageTreeProvider(this);
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
        this.elemTypeToElemNameColumns.put(ResultElementType.CATALOG_API, DatabaseMetadata.CATALOG_API_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.CATALOG_SERVICE, DatabaseMetadata.CATALOG_SERVICE_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.CATALOG_TARGET, DatabaseMetadata.CATALOG_TARGET_NAME.getName());
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new CatalogApiFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public String getDatabaseViewName() {
        return null;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        return null;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        return null;
    }

    @Override
    public Map<String, String> getStoredProcedureOrderBy() {
        return null;
    }

    @Override
    public boolean isEnableLimits() {
        return false;
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.CATALOG_API_HEADER_INFO;
    }

    @Override
    public String getFileName() {
        return CATALOG_API_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new CatalogApiUsageQueryBuilder();
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    public void createState(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1000);
        this.monitor = monitor;
        if (!monitor.isCanceled()) {
            UsageStateAdapter newState = this.createNewState();
            Map<String, Object> contextData = this.state.getData();
            FilterData filter = (FilterData)contextData.get("FilterData");
            if (filter == null) {
                List objTypes = (List)contextData.get("ANALYSIS_TYPE_INPUTS");
                filter = this.getFilter(objTypes);
            }
            newState.getData().put("FilterData", filter);
            List allProjects = (List)contextData.get("projects");
            if (allProjects == null) {
                L.trace("load projects list from service");
                IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
                allProjects = service.getProjects();
                Collections.sort(allProjects);
            }
            newState.getData().put("projects", allProjects);
            List inputProjects = (ArrayList)contextData.get("PROJECT_LIST");
            if (inputProjects == null) {
                L.trace("compute input project list");
                List objTypes = (List)contextData.get("ANALYSIS_TYPE_INPUTS");
                inputProjects = com.ez.mainframe.gui.utils.Utils.computeInputProjectList((List)objTypes);
            }
            if (inputProjects == null) {
                inputProjects = new ArrayList();
            }
            newState.getData().put("PROJECT_LIST", inputProjects);
            Boolean enableLimits = Boolean.FALSE;
            newState.getData().put("EnableLimitsState", enableLimits);
            HashMap<String, SerializationHandler> tempSHMap = null;
            Boolean notComputeResults = (Boolean)contextData.get("NOT_COMPUTE_USAGE_RESULTS");
            if (inputProjects.isEmpty()) {
                notComputeResults = true;
                contextData.put("NOT_COMPUTE_USAGE_RESULTS", Boolean.FALSE);
            }
            boolean hasKey = contextData.containsKey("NOT_COMPUTE_USAGE_RESULTS");
            L.trace("notcomputeResults={}, NotComputeKey={}", (Object)notComputeResults, (Object)hasKey);
            if (!(monitor.isCanceled() || hasKey && notComputeResults.booleanValue())) {
                long jobStartTime = System.currentTimeMillis();
                L.info(String.valueOf(this.getAnalysisType().toString()) + " - start time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
                tempSHMap = new HashMap<String, SerializationHandler>();
                this.searchThrouthAPI(newState, filter);
                Map apiFilter = (Map)newState.getData().get(API_SEARCH_MAP);
                if (apiFilter != null && !apiFilter.isEmpty()) {
                    int workPerProject = 1000 / inputProjects.size();
                    SerializationHandler sh = new SerializationHandler(SerializationHandler.getFile(), this.getRowHeaderInfo(), FormatInfo.getDefault(), new APIRowMangler(apiFilter));
                    tempSHMap.put("RECORDSET", sh);
                    Map<String, List<Integer>> tempParamForAdditionalSP = null;
                    RuntimeException e = null;
                    boolean oneOk = false;
                    Iterator it = inputProjects.iterator();
                    while (!monitor.isCanceled() && it.hasNext()) {
                        ProjectInfo pi = (ProjectInfo)it.next();
                        try {
                            this.computeResultsPerProject(pi, (IActionContext)this.state, newState, tempSHMap, tempParamForAdditionalSP, filter, (IProgressMonitor)monitor.newChild(workPerProject));
                            oneOk = true;
                        }
                        catch (RuntimeException ee) {
                            L.debug("Unexpected error.", (Throwable)ee);
                            e = ee;
                        }
                    }
                    if (!oneOk && e != null) {
                        throw e;
                    }
                } else {
                    L.debug("no data filtered from API model. search will not continue in projects");
                }
                long jobDuration = System.currentTimeMillis() - jobStartTime;
                L.info(String.valueOf(this.getAnalysisType().toString()) + " - duration: " + jobDuration + " ms.");
            } else {
                L.debug("computes results when user press filter button");
            }
            newState.getData().put("last executed entries, only in use entries", this.getEntryInUseNames(filter));
            RecordsetProviderBuilder recProBuilder = new RecordsetProviderBuilder();
            if (tempSHMap != null) {
                for (String key : tempSHMap.keySet()) {
                    recProBuilder.addRecordset(key, (SerializationHandler)tempSHMap.get(key));
                }
            }
            newState.setRecordsets(recProBuilder.build());
            this.setState(newState);
        }
        monitor.setWorkRemaining(0);
    }

    private void searchThrouthAPI(UsageStateAdapter newState, FilterData filter) {
        L.trace("search in API model for filtered entries");
        HashMap<Integer, String[]> apiFilter = new HashMap<Integer, String[]>();
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        IAPIFillerService service = (IAPIFillerService)ServiceUtils.getService(IAPIFillerService.class);
        if (service != null) {
            FilterEntry apiFilters = filter.getEntry(ResultElementType.CATALOG_API);
            ArrayList<String> apiNames = null;
            if (apiFilters.isEntryInUse()) {
                apiNames = new ArrayList<String>();
                String tmp = apiFilters.get("Filter");
                if (!tmp.isEmpty()) {
                    String[] n = tmp.split(",");
                    String[] stringArray = n;
                    int n2 = n.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String s = stringArray[n3];
                        if (!s.trim().isEmpty()) {
                            apiNames.add(s.trim());
                        }
                        ++n3;
                    }
                }
            }
            FilterEntry servFilters = filter.getEntry(ResultElementType.CATALOG_SERVICE);
            ArrayList<String> servNames = null;
            if (servFilters.isEntryInUse()) {
                servNames = new ArrayList<String>();
                String tmp = servFilters.get("Filter");
                if (!tmp.isEmpty()) {
                    String[] n;
                    String[] stringArray = n = tmp.split(",");
                    int n4 = n.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String s = stringArray[n5];
                        if (!s.trim().isEmpty()) {
                            servNames.add(s.trim());
                        }
                        ++n5;
                    }
                }
            }
            L.debug("apiNames={}", apiNames);
            L.debug("servNames={}", servNames);
            Set apis = service.getAPIs();
            int i = 1;
            if (apis != null) {
                block6: for (ApiInterface o : apis) {
                    Node n = (Node)o;
                    switch (n.getType()) {
                        case SERVICE: {
                            if (servNames == null) break;
                            boolean added = false;
                            String apiName = null;
                            if (!apiNames.isEmpty()) {
                                if (n.getParent() != null) {
                                    apiName = ((Node)n.getParent()).getName();
                                    added = apiNames.contains(apiName);
                                }
                            } else {
                                added = true;
                            }
                            if (added) {
                                added = this.checkService(apiFilter, i, n, servNames);
                            } else {
                                L.trace("service {} ignored because is exposed by a filtered API {}", (Object)n.getName(), (Object)apiName);
                            }
                            if (!added) break;
                            nodes.put(i, n);
                            ++i;
                            break;
                        }
                        case API: {
                            boolean cont = true;
                            if (apiNames != null) {
                                if (!apiNames.isEmpty() && !(cont = apiNames.contains(n.getName())) && apiNames.size() == 1) {
                                    cont = this.checkFilterAsterisk(apiNames, n.getName());
                                }
                            } else {
                                boolean bl = cont = servNames != null;
                            }
                            if (cont) {
                                for (Node s : n.getChildren()) {
                                    boolean add = this.checkService(apiFilter, i, s, servNames);
                                    if (add) {
                                        nodes.put(i, s);
                                        ++i;
                                        continue;
                                    }
                                    L.debug("API {} is ignored as not exposing at least a filtered service", (Object)n.getName());
                                }
                                continue block6;
                            }
                            L.debug("API {} is filtered by name", (Object)n.getName());
                        }
                    }
                }
            } else {
                L.debug("no APIs from model");
            }
        } else {
            L.debug("API Catalog service is null");
        }
        newState.getData().put(API_SEARCH_MAP, apiFilter);
        newState.getData().put(API_NODES_MAP, nodes);
        L.trace("filtered nodes={}", nodes);
    }

    private boolean checkFilterAsterisk(List<String> names, String name) {
        boolean cont = false;
        for (String an : names) {
            if (an.length() > 1 && an.startsWith(ASTERISK) && an.endsWith(ASTERISK) && name.contains(an.substring(1, an.length() - 1))) {
                cont = true;
                continue;
            }
            if (an.startsWith(ASTERISK) && name.endsWith(an.substring(1))) {
                cont = true;
                continue;
            }
            if (!an.endsWith(ASTERISK) || !name.startsWith(an.substring(0, an.length() - 1))) continue;
            cont = true;
        }
        return cont;
    }

    private boolean checkService(Map<Integer, String[]> apiFilter, int i, Node n, List<String> servNames) {
        boolean ret = false;
        boolean cont = true;
        String servName = n.getName();
        if (!servNames.isEmpty() && !(cont = servNames.contains(servName)) && servNames.size() == 1) {
            cont = this.checkFilterAsterisk(servNames, servName);
        }
        if (cont) {
            String apiName = n.getType().equals((Object)ApiInterface.Type.API) ? servName : (n.getParent() != null ? ((Node)n.getParent()).getName() : "");
            ApiTargetType targetType = n.getTargetType();
            if (targetType.equals((Object)ApiTargetType.PROGRAM) || targetType.equals((Object)ApiTargetType.IMS_TRANSACTION)) {
                apiFilter.put(i, new String[]{String.valueOf(i), apiName, servName, targetType.name(), (String)n.getInfo().get("target")});
                ret = true;
            } else {
                L.debug("unsupported target type: {}", (Object)targetType);
            }
        } else {
            L.debug("service {} is filtered", (Object)servName);
        }
        return ret;
    }

    @Override
    protected void computeResultsPerProject(final ProjectInfo pi, IActionContext context, UsageStateAdapter state, final Map<String, SerializationHandler> tempSHMap, final Map<String, List<Integer>> tempParamForAdditionalSP, final FilterData filter, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        if (!monitor.isCanceled()) {
            String prjName = pi.getName();
            try {
                L.debug("search targets in project {}", (Object)prjName);
                IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = service.getProjectHandler(prjName, null);
                ServerType dbEngine = ServerType.findByValue((int)((Integer)pi.getInfo().get("dbEngine")));
                Map<String, FilterEntryParameterGenerator> filterEntryParameterGeneratorMap = this.getFilterEntryParameterGeneratorMap();
                List<String> paramsList = filter.getParameters(filterEntryParameterGeneratorMap, dbEngine);
                filter.completeWithSpecificParameters(paramsList);
                final String[] params = paramsList.toArray(new String[0]);
                final Map apiFilter = (Map)state.getData().get(API_SEARCH_MAP);
                if (!monitor.isCanceled()) {
                    ph.executeWithLock(ph, new IMFRunnable(){

                        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                            SubMonitor sm = SubMonitor.convert((IProgressMonitor)pmonitor, (int)120);
                            if (!sm.isCanceled()) {
                                CatalogApiUsageDescriptor.this.queryForData(pi, tempSHMap, tempParamForAdditionalSP, filter, params, "EZViewer_Usage_API", apiFilter.values(), conn, (IProgressMonitor)sm.newChild(100));
                            }
                        }
                    }, LockType.Shared, (IProgressMonitor)monitor.newChild(90));
                }
                if (monitor.isCanceled()) {
                    state.getData().put("IS_CANCELED", true);
                }
                monitor.setWorkRemaining(0);
                monitor.done();
            }
            catch (Exception e) {
                L.error("while computing results", (Throwable)e);
                GuiErrorLog.err(e.getMessage(), e);
            }
        }
    }

    protected void queryForData(ProjectInfo pi, Map<String, SerializationHandler> tempSHMap, Map<String, List<Integer>> tempParamForAdditionalSP, FilterData filter, String[] params, String procName, Collection<String[]> collection, EZSourceConnection conn, IProgressMonitor pmonitor) {
        String tempTable;
        block19: {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)pmonitor);
            sm.setTaskName(Messages.getString(CatalogApiUsageDescriptor.class, "query.for.data"));
            ServerType dbEngine = ServerType.findByValue((int)((Integer)pi.getInfo().get("dbEngine")));
            tempTable = com.ez.mainframe.data.utils.Utils.getTempTableName((ServerType)dbEngine, (String)"tempAPI ");
            conn.beginTransaction();
            try {
                try {
                    String createTempSql = null;
                    switch (dbEngine) {
                        case SqlServer: {
                            createTempSql = "create table " + tempTable + " (ID int not null, prgName varchar(250), imsTran varchar(250))";
                            break;
                        }
                        case Db2Z: {
                            createTempSql = " DECLARE GLOBAL TEMPORARY TABLE " + tempTable;
                            createTempSql = String.valueOf(createTempSql) + "( ID INTEGER NOT NULL, ";
                            createTempSql = String.valueOf(createTempSql) + "prgName VARGRAPHIC(250), ";
                            createTempSql = String.valueOf(createTempSql) + "imsTran VARGRAPHIC(250)) ";
                            createTempSql = String.valueOf(createTempSql) + " CCSID UNICODE ";
                            createTempSql = String.valueOf(createTempSql) + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                            break;
                        }
                        case Db2: {
                            createTempSql = " DECLARE GLOBAL TEMPORARY TABLE " + tempTable;
                            createTempSql = String.valueOf(createTempSql) + "( ID INTEGER NOT NULL, ";
                            createTempSql = String.valueOf(createTempSql) + "prgName VARGRAPHIC(250), ";
                            createTempSql = String.valueOf(createTempSql) + "imsTran VARGRAPHIC(250)) ";
                            createTempSql = String.valueOf(createTempSql) + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ";
                            break;
                        }
                    }
                    Assert.isNotNull(createTempSql);
                    conn.executeUpdate(createTempSql);
                    ArrayList<EZSourceDataType> param = new ArrayList<EZSourceDataType>();
                    param.add(EZSourceDataType.Integer);
                    param.add(EZSourceDataType.String);
                    param.add(EZSourceDataType.String);
                    int j = 0;
                    String[][] pVals = new String[collection.size()][3];
                    for (String[] v : collection) {
                        pVals[j][0] = v[0];
                        String type = v[3];
                        if (ApiTargetType.PROGRAM.name().equalsIgnoreCase(type)) {
                            pVals[j][1] = v[4].trim();
                        } else if (ApiTargetType.IMS_TRANSACTION.name().equalsIgnoreCase(type)) {
                            pVals[j][2] = v[4].trim();
                        }
                        L.trace("tempTable value: {}", (Object)Arrays.toString(pVals[j]));
                        ++j;
                    }
                    conn.insertBatch(tempTable, pVals, param);
                    conn.voteCommitTransaction();
                    conn.endTransaction();
                    int estimatedRowNumber = filter.getEstimatedRowNumber();
                    conn.beginTransaction();
                    L.trace("calling {}", (Object)procName);
                    NonBlockingOperationHandle resultHandler = conn.beginNonTransactionalStoredProc(procName, null, 2000);
                    Integer rowNumber = resultHandler.totalRowsCount();
                    if (rowNumber == null) {
                        rowNumber = estimatedRowNumber;
                    }
                    L.trace("done call");
                    sm.worked(10);
                    SerializationHandler sh = tempSHMap.get("RECORDSET");
                    this.fillState(sh, resultHandler, pi, tempParamForAdditionalSP, (IProgressMonitor)sm.newChild(70), rowNumber);
                    sm.setWorkRemaining(40);
                    resultHandler.close();
                    L.trace("after write data");
                    if (tempParamForAdditionalSP != null) {
                        for (String key : tempParamForAdditionalSP.keySet()) {
                            tempParamForAdditionalSP.put(key, null);
                        }
                    }
                }
                catch (Exception e) {
                    L.error("while fetching results", (Throwable)e);
                    GuiErrorLog.err(e.getMessage(), e);
                    conn.voteRollbackTransaction();
                    conn.endTransaction();
                    break block19;
                }
            }
            catch (Throwable throwable) {
                conn.voteRollbackTransaction();
                conn.endTransaction();
                throw throwable;
            }
            conn.voteRollbackTransaction();
            conn.endTransaction();
        }
        try {
            conn.beginTransaction();
            conn.executeUpdate("drop table " + tempTable);
            conn.voteCommitTransaction();
            conn.endTransaction();
        }
        catch (Exception e) {
            L.error("while droping temp table", (Throwable)e);
            GuiErrorLog.err(e.getMessage(), e);
        }
    }

    @Override
    protected void fillState(SerializationHandler sh, NonBlockingOperationHandle resultHandler, ProjectInfo pi, Map<String, List<Integer>> paramsToCollect, IProgressMonitor pmonitor, int estimatedRowNumber) {
        if (!pmonitor.isCanceled()) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            monitor.setTaskName(Messages.getString(((Object)((Object)this)).getClass(), "compute.results", new String[]{pi.getName()}));
            L.trace("before load recordset");
            sh.write(resultHandler, pi, paramsToCollect, (IProgressMonitor)monitor.newChild(100), estimatedRowNumber);
            monitor.setWorkRemaining(0);
        }
    }

    @Override
    protected void addLevelNotInFilter(List<ResultElementType> list) {
        list.add(ResultElementType.CATALOG_TARGET);
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return CSV_HEADER;
    }

    @Override
    protected List<String> getEntryInUseNames(FilterData filter) {
        ArrayList<String> list = new ArrayList<String>();
        for (FilterEntry entry : ((CatalogApiFilter)filter).getEntries4CSV()) {
            if (!entry.isEntryInUse()) continue;
            String name = entry.get("filterEntryName");
            list.add(name);
        }
        return list;
    }

    public class APIRowMangler
    implements SerializationHandler.RowMangler {
        public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
        Map<Integer, String[]> apiResults;

        public APIRowMangler(Map<Integer, String[]> apiFilter) {
            this.apiResults = apiFilter;
        }

        @Override
        public String[] mangle(String[] rawRow) {
            Object[] ret = new String[13];
            String rowID = rawRow[0];
            String[] apis = this.apiResults.get(Integer.valueOf(rowID));
            int i = 0;
            while (i < 4) {
                ret[i] = apis[i];
                ++i;
            }
            i = 1;
            while (i < rawRow.length) {
                ret[i + 3] = rawRow[i];
                ++i;
            }
            L.trace("row={}", (Object)Arrays.toString(ret));
            return ret;
        }
    }
}

