/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public enum StmtFilters {
    NO_FILTER("", ""),
    ASSEMBLER_VAR_FILTER("1", "17"),
    COBOL_VAR_FILTER("1", "3_19"),
    NATURAL_VAR_FILTER("1", "4"),
    PL1_VAR_FILTER("1", "5"),
    ADABAS_FILTER("0_1_6_10", "1_6_10_3_4_7_12_19"),
    DAL_FILTER("0_1_6_10", "6_24"),
    DBI_FILTER("0_1_6_10", "6_25"),
    DATACOM_TABLE_FILTER("0_1_6_10", "6_21"),
    DATASET_PROG_FILTER("0_1_6_10", "1_10_3_4_12_17_19"),
    FILE_IN_PROGRAM_FILTER("0_1_6_10", "1_10_3_4_12_17_19"),
    IDMS_FILTER("0_1_6_10", "6_8"),
    IDMSX_FILTER("0_1_6_10", "6_8"),
    IMSDB_FILTER("0_1_6_10", "10_13"),
    IMSDB_LOGICAL_FILTER("0_1_6_10", "10_13"),
    INCLUDE_FILTER("0_1_6_10", "1_10_3_4_5_12_17_19"),
    MQUEUE_FILTER("0_1_6_10", "10_18"),
    OPENTP_FILTER("0_1_6_10", "10_20"),
    SQL_TABLE_FIELD_FILTER("0_1_6_10", "6_9"),
    SQL_TABLE_FILTER("0_1_6_10", "6_9_24"),
    TPMSX_FILTER("0_1_6_10", "1_10_3_12_19_20");

    private String[] filteredLang;

    private StmtFilters(String ... filteredLang) {
        this.filteredLang = filteredLang;
    }

    public String[] getFilter() {
        return this.filteredLang;
    }

    public static StmtFilters getFilterByDescriptor(String id) {
        switch (id) {
            case "com.ez.analysis.mainframe.usage.pl1var": {
                return PL1_VAR_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.naturalvar": {
                return NATURAL_VAR_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.assemblervar": {
                return ASSEMBLER_VAR_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.cobolvar": {
                return COBOL_VAR_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.adabas": {
                return ADABAS_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.dal": {
                return DAL_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.datacom": {
                return DATACOM_TABLE_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.datasets": {
                return DATASET_PROG_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.idms": {
                return IDMS_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.imsdb.physical": {
                return IMSDB_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.imsdb.logical": {
                return IMSDB_LOGICAL_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.include": {
                return INCLUDE_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.mq": {
                return MQUEUE_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.sqltablefields": {
                return SQL_TABLE_FIELD_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.sqltables": {
                return SQL_TABLE_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.dbi": {
                return DBI_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.files": {
                return FILE_IN_PROGRAM_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.idmsx": {
                return IDMSX_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.opentp": {
                return OPENTP_FILTER;
            }
            case "com.ez.analysis.mainframe.usage.tpmsx": {
                return TPMSX_FILTER;
            }
        }
        return NO_FILTER;
    }

    public static List<Integer> getParents(StmtFilters filter) {
        if (filter.filteredLang[0].isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(filter.filteredLang[0].split("_")).stream().map(parent -> Integer.parseInt(parent)).collect(Collectors.toList());
    }

    public static List<Integer> getChildren(StmtFilters filter) {
        if (filter.filteredLang[1].isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(filter.filteredLang[1].split("_")).stream().map(child -> Integer.parseInt(child)).collect(Collectors.toList());
    }
}

