/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.utils;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;

public class ProgramUtils {
    public static final String STEP_NAME_IN_JCL = "stepInJCL executing pgm or proc";
    public static final int LOAD_MODULE_ID = -2;
    public static final int UTILITY_ID = -3;

    public static int getFakeProgTypeID(String prgName) {
        int ret = -2;
        if (com.ez.mainframe.data.utils.Utils.isUtility((String)prgName)) {
            ret = -3;
        }
        return ret;
    }

    public static void setFakeProgTypeID(ResultElement resultElement, String prgName) {
        int id = ProgramUtils.getFakeProgTypeID(prgName);
        resultElement.addProperty("Program Type Id", id);
    }

    public static String getProgramTypeAsString(ResultElement resultElement) {
        String programType = (String)resultElement.getProperty("ProgramTypeAsString");
        if (programType != null) {
            return programType;
        }
        if (resultElement.getProperty("Program Type Id") != null) {
            Integer programTypeId = (Integer)resultElement.getProperty("Program Type Id");
            programType = ProgramUtils.getProgramTypeAsString(programTypeId);
        }
        resultElement.addProperty("ProgramTypeAsString", programType);
        return programType;
    }

    public static String getProgramTypeAsString(Integer programTypeId) {
        String programType;
        switch (programTypeId) {
            case -2: {
                programType = ResultElementType.LOAD_MODULE.getDisplayName();
                break;
            }
            case -3: {
                programType = ResultElementType.UTILITY.getDisplayName();
                break;
            }
            case 15: 
            case 16: {
                programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(8));
                break;
            }
            default: {
                programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
            }
        }
        return programType;
    }

    public static ResultElementType getProgramResultElementType(Integer programTypeId) {
        ResultElementType ret = ResultElementType.PROGRAM;
        if (-2 == programTypeId) {
            ret = ResultElementType.LOAD_MODULE;
        } else if (-3 == programTypeId) {
            ret = ResultElementType.UTILITY;
        }
        return ret;
    }

    public static ResultElement getOrCreateCategoryForProgram(Row r, ResultElement parent, String name) {
        Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
        String programType = null;
        if (programTypeId == null || programTypeId == 0) {
            programTypeId = ProgramUtils.getFakeProgTypeID(name);
        } else {
            programType = ProgramUtils.getProgramTypeAsString(programTypeId);
        }
        ResultElementType elemType = ProgramUtils.getProgramResultElementType(programTypeId);
        ResultElement categoryResultElement = Utils.getCategory(elemType, parent, programType);
        categoryResultElement.addProperty("Program Type Id", programTypeId);
        return categoryResultElement;
    }

    public static void setPropertiesViewer(ResultElement resultElement, String name, String path, String programType) {
        if (programType.equals(ResultElementType.UTILITY.getDisplayName())) {
            GenericProgramRelatedNode prgNode = new GenericProgramRelatedNode(name, ResultElementType.UTILITY.getDisplayName());
            resultElement.addProperty("Node_Mainframe", prgNode);
        } else if (programType.equals(ResultElementType.LOAD_MODULE.getDisplayName())) {
            GenericProgramRelatedNode prgNode = new GenericProgramRelatedNode(name, ResultElementType.LOAD_MODULE.getDisplayName());
            resultElement.addProperty("Node_Mainframe", prgNode);
        } else {
            MainframeSourceNode prgNode = new MainframeSourceNode(programType, path);
            resultElement.addProperty("Node_Mainframe", prgNode);
        }
    }
}

