/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.utils;

import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.IMSDBAccessType;

public class IMSDBUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String IMSDB_DATABASE_PARAM = "@Imsdb";
    public static final String IMSDB_DATABASE_PARAM_LIMIT = "@ImsdbLimit";
    public static final String IMSDB_SEGMENT_NAME_PARAM = "@ImsdbSegment";
    public static final String IMSDB_FIELD_NAME_PARAM = "@ImsdbField";
    public static final String IS_LOGICAL_CONTEXT = "IS_LOGICAL_CONTEXT";

    public static ResultElementType getIMSDBType(Integer accessType) {
        IMSDBAccessType type = null;
        if (accessType != null) {
            IMSDBAccessType[] iMSDBAccessTypeArray = IMSDBAccessType.values();
            int n = iMSDBAccessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMSDBAccessType val = iMSDBAccessTypeArray[n2];
                if (val.ordinal() == accessType - 1) {
                    type = val;
                    break;
                }
                ++n2;
            }
        }
        if (type == null) {
            return ResultElementType.IMSDB_NOT_AVAILABLE;
        }
        switch (type) {
            case MSDB: 
            case DEDB: {
                return ResultElementType.IMSDB_FAST_PATH;
            }
            case HSAM: 
            case GSAM: 
            case SHSAM: {
                return ResultElementType.IMSDB_FILE_ACCESS;
            }
            case LOGICAL: {
                return ResultElementType.IMSDB_LOGICAL;
            }
        }
        return ResultElementType.IMSDB_FULL_FUNCTION;
    }
}

