/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.utils;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.adapters.CsvExportDescriptor;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.cobol.callgraph.nodes.DDNameNode;
import java.util.Arrays;
import java.util.List;

public class DatasetUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String SYSOUT_DATASET = "SYSOUT";
    public static final String JCLPROGRAMTYPE = "22";

    public static String getFullDSName(Row r, String name) {
        Integer currentDSGenerationNo = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName());
        String datasetMemberName = (String)r.getColumnValue(DatabaseMetadata.DATASET_MEMBER_NAME.getName());
        String retVal = DatasetUtils.getFullDSName(name, currentDSGenerationNo, datasetMemberName);
        return retVal;
    }

    public static String getFullDSName(String name, Integer currentDSGenerationNo, String datasetMemberName) {
        String retVal = name;
        if (currentDSGenerationNo != null) {
            retVal = String.valueOf(retVal) + "(" + currentDSGenerationNo + ")";
        }
        if (datasetMemberName != null && !datasetMemberName.toString().isEmpty()) {
            retVal = String.valueOf(retVal) + " (" + datasetMemberName + ")";
        }
        return retVal;
    }

    public static String getFilterDSName(String datasetName, String datasetMemberName) {
        return String.valueOf(datasetName) + (datasetMemberName != null && !datasetMemberName.isEmpty() ? " (" + datasetMemberName + ")" : "");
    }

    public static String computeDatasetName(Row r, String name) {
        String ret = name;
        if (name.isEmpty()) {
            String spoolClassName = (String)r.getColumnValue(DatabaseMetadata.SPOOL_DATASET_CLASS.getName());
            if (spoolClassName != null) {
                StringBuilder sb = new StringBuilder(SYSOUT_DATASET);
                sb.append("(").append(spoolClassName).append(")");
                ret = sb.toString();
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public static CsvExportDescriptor.CsvHandler getDatasetNameCsvHandler() {
        return null;
    }

    public static void setDDPath(ResultElement resultElement, Row r) {
        String path = (String)r.getColumnValue(DatabaseMetadata.DD_PATH.getName());
        if (path != null) {
            Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.DD_START_ROW.getName());
            Utils.setFileAttribute(resultElement, JCLPROGRAMTYPE, path, startRow);
        }
    }

    public static void setPropertiesInfoForDD(ResultElement resultElement, Row r) {
        String path = (String)r.getColumnValue(DatabaseMetadata.DD_PATH.getName());
        if (path != null) {
            String name = (String)r.getColumnValue(DatabaseMetadata.DD_NAME.getName());
            Integer nr = (Integer)r.getColumnValue(DatabaseMetadata.DD_ISDUMMY.getName());
            boolean isDummy = nr != 0;
            String disposition = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DD_NORMAL_DISPOSITION.getName()));
            String status = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DD_STATUS.getName()));
            Integer overrideID = (Integer)r.getColumnValue(DatabaseMetadata.DD_OVERRIDE_DDID.getName());
            boolean isOverriden = overrideID != 0;
            DDNameNode ddNode = new DDNameNode(name, Boolean.valueOf(isDummy), disposition, status, isOverriden, true);
            resultElement.addProperty("Node_Mainframe", ddNode);
        }
    }

    public static List<ColumnInfo> getCsvColumns() {
        return Arrays.asList(DatabaseMetadata.DATASET_ID, DatabaseMetadata.DATASET_NAME, DatabaseMetadata.DATASET_MEMBER_NAME, DatabaseMetadata.DATASET_GENERATION_NUMBER);
    }
}

