/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.ProcessRowCallbackInterface;
import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.Activator;
import com.ez.analysis.mainframe.usage.adapters.CsvExportDescriptor;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.programs.ProgramVarTreeProvider;
import com.ez.analysis.mainframe.usage.queries.StoredProcDetail;
import com.ez.analysis.mainframe.usage.rank.IMSDBQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.utils.DatasetUtils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.IMSDBNode;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.config.context.AnalysisBrowserContext;
import com.ez.internal.analysis.config.inputs.CatalogAPIInputType;
import com.ez.internal.analysis.config.inputs.ControlmApplication;
import com.ez.internal.analysis.config.inputs.ControlmJobObjectType;
import com.ez.internal.analysis.config.inputs.EZAMNode;
import com.ez.internal.analysis.config.inputs.EZAsmCSECTProgram;
import com.ez.internal.analysis.config.inputs.EZAsmEntryProgram;
import com.ez.internal.analysis.config.inputs.EZCobolProgram;
import com.ez.internal.analysis.config.inputs.EZDDCLFile;
import com.ez.internal.analysis.config.inputs.EZDDCLSchema;
import com.ez.internal.analysis.config.inputs.EZDDCLSubschema;
import com.ez.internal.analysis.config.inputs.EZJobInputType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSCLProgram;
import com.ez.internal.analysis.config.inputs.EZSourceAdabas;
import com.ez.internal.analysis.config.inputs.EZSourceAdabasDB;
import com.ez.internal.analysis.config.inputs.EZSourceAdabasFile;
import com.ez.internal.analysis.config.inputs.EZSourceDAL;
import com.ez.internal.analysis.config.inputs.EZSourceDBI;
import com.ez.internal.analysis.config.inputs.EZSourceDDName;
import com.ez.internal.analysis.config.inputs.EZSourceDatacom;
import com.ez.internal.analysis.config.inputs.EZSourceDataset;
import com.ez.internal.analysis.config.inputs.EZSourceExecProc;
import com.ez.internal.analysis.config.inputs.EZSourceFile;
import com.ez.internal.analysis.config.inputs.EZSourceIDMSRecord;
import com.ez.internal.analysis.config.inputs.EZSourceIDMSSet;
import com.ez.internal.analysis.config.inputs.EZSourceIMSDB;
import com.ez.internal.analysis.config.inputs.EZSourceIMSDBField;
import com.ez.internal.analysis.config.inputs.EZSourceIMSDBSegment;
import com.ez.internal.analysis.config.inputs.EZSourceIMSDatabase;
import com.ez.internal.analysis.config.inputs.EZSourceInclude;
import com.ez.internal.analysis.config.inputs.EZSourceJclStep;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.analysis.config.inputs.EZSourceQueue;
import com.ez.internal.analysis.config.inputs.EZSourceQueueManager;
import com.ez.internal.analysis.config.inputs.EZSourceSQLTable;
import com.ez.internal.analysis.config.inputs.EZSourceSQLTableField;
import com.ez.internal.analysis.config.inputs.EZSourceScreen;
import com.ez.internal.analysis.config.inputs.EZSourceVariable;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.MapFilter;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.IMSDBAccessType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.properties.IMSFieldPropertiesNode;
import com.ez.mainframe.gui.properties.IMSSegmentPropertiesNode;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.model.segments.ControlmApplicationSg;
import com.ez.workspace.model.segments.ControlmJobSg;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceAdabasIDSg;
import com.ez.workspace.model.segments.EZSourceDALIDSg;
import com.ez.workspace.model.segments.EZSourceDBIIDSg;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceDDNameIDSg;
import com.ez.workspace.model.segments.EZSourceDatacomTableIDSg;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceExecProcIDSg;
import com.ez.workspace.model.segments.EZSourceFileIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSRecordIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSSetIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDBFieldIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDBIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDBSegmentIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDatabaseIDSg;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceJclStepIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProgramTypeIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceQueueIDSg;
import com.ez.workspace.model.segments.EZSourceQueueManagerIDSg;
import com.ez.workspace.model.segments.EZSourceSQLFieldTableIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import com.ez.workspace.model.segments.EZSourceVariableIDSg;
import com.ibm.ez.analysis.api.model.ApiInterface;
import com.ibm.ez.analysis.api.model.ApiTargetType;
import com.ibm.ez.analysis.api.model.CatalogAPISg;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);
    public static final String NOT_AVAILABLE_LBL = "N/A";
    private static final String csvSeparator = ";";
    static boolean continueSave = false;
    private static final String IMSDB_DETAILS_QUERY = "select VERSION, RMNAME, PSNAME, PASSWD, FPINDEX, REMARKS from IMSDBInfo where DBId = ";
    private static final String IMS_SEGMENT_DETAILS_QUERY = "select TYPE,  EXTERNALNAME,  BYTES,  FREQ,   ENCODING, REMARKS from IMSDBSegments where SegmentId = ";
    private static final String IMS_FIELD_DETAILS_QUERY = "select EXTERNALNAME, TYPE, DATATYPE, BYTES, START, RELSTART, MAXOCCURS,  MAXBYTES,  CASENAME, REMARKS from IMSDBFields where FieldId = ";
    public static final String KEY_SEPARATOR = "|";

    public static String null2empty(Object o) {
        String s = "";
        if (o != null) {
            s = o.toString();
        }
        return s;
    }

    public static void setFileAttribute(ResultElement resultElement, String programTypeId, String programPath, Integer ... positionInfos) {
        TextSelectionInFile infoSel = new TextSelectionInFile(programPath, programTypeId, positionInfos);
        HashSet<TextSelectionInFile> infoSelSet = (HashSet<TextSelectionInFile>)resultElement.getProperty("FILE");
        if (infoSelSet == null) {
            infoSelSet = new HashSet<TextSelectionInFile>();
        }
        infoSelSet.add(infoSel);
        resultElement.addProperty("FILE", infoSelSet);
        resultElement.addProperty("GOTOSOURCE", true);
    }

    protected static void exportResultsCSV(UsageDescriptorAdapter descriptor, String fileNamePath, List<String> files, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        Map<ResultElementType, Pair<String, List<ResultElementType>>> suffixes = descriptor.getCSVFileSuffixMap();
        CsvExportDescriptor csvExportDescriptor = descriptor.getCsvExportDescriptor();
        Map<ResultElementType, MapFilter<ColumnInfo, Object>> filterMap = csvExportDescriptor != null ? csvExportDescriptor.getCsvFilterMap() : null;
        Map<ColumnInfo, CsvExportDescriptor.CsvHandler> csvHandlerMap = csvExportDescriptor != null ? csvExportDescriptor.getHandlerMap() : null;
        String fileName = fileNamePath;
        int pos = fileNamePath.lastIndexOf(".csv");
        if (pos > 0) {
            fileNamePath = fileNamePath.substring(0, pos);
        }
        if (suffixes != null) {
            List inUseEntryTypes = (List)descriptor.getState().getData().get("last executed entries, only in use entries");
            for (String name : inUseEntryTypes) {
                MapFilter<ColumnInfo, Object> filter;
                ResultElementType ret = ResultElementType.valueOfName((String)name);
                Pair<String, List<ResultElementType>> csvInfoPerEntry = suffixes.get(ret);
                MapFilter<ColumnInfo, Object> mapFilter = filter = filterMap != null ? filterMap.get(ret) : null;
                if (csvInfoPerEntry == null) continue;
                String suffix = (String)csvInfoPerEntry.getFirst();
                List paramTypes = (List)csvInfoPerEntry.getSecond();
                fileName = fileNamePath.concat(suffix).concat(".csv");
                File exportFile = new File(fileName);
                L.debug("exporting results for " + suffix + " in file: " + fileName);
                boolean status = Utils.exportInFile(descriptor, "RECORDSET", exportFile, null, paramTypes, filter, csvHandlerMap, monitor);
                if (!status) continue;
                files.add(exportFile.getAbsolutePath());
            }
        } else {
            Map<String, StoredProcDetail> map;
            L.debug("exporting basic results in file: " + fileName);
            File exportFile = new File(fileName);
            MapFilter<ColumnInfo, Object> filter = filterMap != null ? filterMap.get("") : null;
            boolean status = Utils.exportInFile(descriptor, "RECORDSET", exportFile, null, null, filter, csvHandlerMap, monitor);
            if (status) {
                files.add(exportFile.getAbsolutePath());
            }
            if ((map = descriptor.getAdditionalSpMap()) != null) {
                for (String recordProviderKey : map.keySet()) {
                    StoredProcDetail spd;
                    List<ColumnInfo> specificColumns;
                    status = Utils.exportInFile(descriptor, recordProviderKey, exportFile = new File(fileName = fileNamePath.concat(recordProviderKey).concat(".csv")), specificColumns = (spd = map.get(recordProviderKey)).getRowHeaderInfo().getColumnInfo(), null, filter, csvHandlerMap, monitor);
                    if (!status) continue;
                    files.add(exportFile.getAbsolutePath());
                }
            }
        }
        monitor.done();
    }

    private static boolean exportInFile(UsageDescriptorAdapter descriptor, String recordProviderKey, final File exportFile, List<ColumnInfo> specificColumns, List<ResultElementType> paramTypes, MapFilter<ColumnInfo, Object> filter, Map<ColumnInfo, CsvExportDescriptor.CsvHandler> csvHandlerMap, SubMonitor monitor) {
        boolean exportStatus;
        block39: {
            boolean deleteTempFile;
            File tempFile;
            BufferedWriter buffWriter;
            block38: {
                exportStatus = false;
                continueSave = false;
                if (exportFile.exists()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            continueSave = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString(Utils.class, "confirm.save.as"), (String)Messages.getString(Utils.class, "confirm.dialog.question", new String[]{exportFile.toString()}));
                        }
                    });
                } else {
                    continueSave = true;
                }
                if (!continueSave) {
                    return exportStatus;
                }
                buffWriter = null;
                tempFile = null;
                UsageStateAdapter state = descriptor.getState();
                Map data = state.getData();
                boolean rsIsEmpty = true;
                RecordsetProvider rsProvider = descriptor.getRecordsetProvider(recordProviderKey);
                if (rsProvider != null) {
                    rsIsEmpty = rsProvider.getRowsCount() == 0;
                }
                String analysis = descriptor.getAnalysisType().getName();
                String summary = "\"" + (String)descriptor.getState().getData().get("fullSummary") + "\"";
                deleteTempFile = false;
                try {
                    try {
                        MyCallback callback = null;
                        tempFile = File.createTempFile("exportFile-", ".tmp", exportFile.getParentFile());
                        buffWriter = new BufferedWriter(new FileWriter(tempFile));
                        if (rsIsEmpty) break block38;
                        monitor.beginTask(Messages.getString(Utils.class, "export.csv.writeTask.name"), rsProvider.getRowsCount());
                        buffWriter.write(analysis);
                        buffWriter.write("\r\n");
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd' 'HH:mm");
                        buffWriter.write(String.valueOf(Messages.getString(Utils.class, "csv.header.date")) + " " + sdf.format(new Date()));
                        buffWriter.write("\r\n");
                        buffWriter.write(summary);
                        buffWriter.write("\r\n");
                        buffWriter.write("\r\n");
                        StringBuilder rowStringBuilder = new StringBuilder();
                        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
                        HashSet<ColumnInfo> columnsAlreadyAdded = new HashSet<ColumnInfo>();
                        Map<String, List<ColumnInfo>> csvInfo = descriptor.getCSVColumnInfo();
                        String prjKey = ResultElementType.PROJECT_INFO.name();
                        List<ColumnInfo> prjColumns = csvInfo.get(prjKey);
                        Utils.addColums(prjColumns, rowStringBuilder, columns, columnsAlreadyAdded);
                        if (specificColumns != null) {
                            Utils.addColums(specificColumns, rowStringBuilder, columns, columnsAlreadyAdded);
                        } else if (paramTypes == null) {
                            List entries = (List)data.get("last executed entries, only in use entries");
                            for (String key : entries) {
                                specificColumns = csvInfo.get(key);
                                Utils.addColums(specificColumns, rowStringBuilder, columns, columnsAlreadyAdded);
                            }
                        } else {
                            for (ResultElementType ret : paramTypes) {
                                String key = ret.name();
                                specificColumns = csvInfo.get(key);
                                Utils.addColums(specificColumns, rowStringBuilder, columns, columnsAlreadyAdded);
                            }
                        }
                        buffWriter.write(rowStringBuilder.toString());
                        buffWriter.write("\n");
                        callback = new MyCallback(buffWriter, columns, filter, csvHandlerMap, tempFile);
                        rsProvider.load(callback, (IProgressMonitor)monitor);
                        deleteTempFile = callback.shouldDeleteTempfile();
                    }
                    catch (IOException e) {
                        L.error("Failed to write to CSV export file." + tempFile.getAbsolutePath(), (Throwable)e);
                        LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(Utils.class, "export.csv.write.error.msg"), (Plugin)Activator.getDefault(), (boolean)false);
                        deleteTempFile = true;
                        if (buffWriter != null) {
                            try {
                                buffWriter.close();
                            }
                            catch (IOException e2) {
                                L.warn("Failed to close CSV export file " + tempFile.getAbsolutePath(), (Throwable)e2);
                                MultiStatus warningStatus = LogUtil.getServiceInfo((Throwable)e2, (int)2, (String)Messages.getString(Utils.class, "export.csv.close.warn.msg"), (Bundle)Activator.getDefault().getBundle());
                                LogUtil.displayErrorMessage((Status)warningStatus, (boolean)false);
                            }
                        }
                        if (!monitor.isCanceled() && !deleteTempFile) {
                            if (exportFile.exists()) {
                                exportFile.delete();
                            }
                            if (!tempFile.renameTo(exportFile)) {
                                tempFile.delete();
                                L.error("Failed to overwrite CSV export file " + exportFile.getAbsolutePath());
                                LogUtil.displayErrorMessage(null, (String)Messages.getString(Utils.class, "export.csv.overwrite.error.msg", new String[]{exportFile.getAbsolutePath()}), (Plugin)Activator.getDefault(), (boolean)false);
                            } else {
                                exportStatus = true;
                            }
                        } else {
                            tempFile.delete();
                        }
                        break block39;
                    }
                }
                catch (Throwable throwable) {
                    if (buffWriter != null) {
                        try {
                            buffWriter.close();
                        }
                        catch (IOException e) {
                            L.warn("Failed to close CSV export file " + tempFile.getAbsolutePath(), (Throwable)e);
                            MultiStatus warningStatus = LogUtil.getServiceInfo((Throwable)e, (int)2, (String)Messages.getString(Utils.class, "export.csv.close.warn.msg"), (Bundle)Activator.getDefault().getBundle());
                            LogUtil.displayErrorMessage((Status)warningStatus, (boolean)false);
                        }
                    }
                    if (!monitor.isCanceled() && !deleteTempFile) {
                        if (exportFile.exists()) {
                            exportFile.delete();
                        }
                        if (!tempFile.renameTo(exportFile)) {
                            tempFile.delete();
                            L.error("Failed to overwrite CSV export file " + exportFile.getAbsolutePath());
                            LogUtil.displayErrorMessage(null, (String)Messages.getString(Utils.class, "export.csv.overwrite.error.msg", new String[]{exportFile.getAbsolutePath()}), (Plugin)Activator.getDefault(), (boolean)false);
                        } else {
                            exportStatus = true;
                        }
                    } else {
                        tempFile.delete();
                    }
                    throw throwable;
                }
            }
            if (buffWriter != null) {
                try {
                    buffWriter.close();
                }
                catch (IOException e) {
                    L.warn("Failed to close CSV export file " + tempFile.getAbsolutePath(), (Throwable)e);
                    MultiStatus warningStatus = LogUtil.getServiceInfo((Throwable)e, (int)2, (String)Messages.getString(Utils.class, "export.csv.close.warn.msg"), (Bundle)Activator.getDefault().getBundle());
                    LogUtil.displayErrorMessage((Status)warningStatus, (boolean)false);
                }
            }
            if (!monitor.isCanceled() && !deleteTempFile) {
                if (exportFile.exists()) {
                    exportFile.delete();
                }
                if (!tempFile.renameTo(exportFile)) {
                    tempFile.delete();
                    L.error("Failed to overwrite CSV export file " + exportFile.getAbsolutePath());
                    LogUtil.displayErrorMessage(null, (String)Messages.getString(Utils.class, "export.csv.overwrite.error.msg", new String[]{exportFile.getAbsolutePath()}), (Plugin)Activator.getDefault(), (boolean)false);
                } else {
                    exportStatus = true;
                }
            } else {
                tempFile.delete();
            }
        }
        return exportStatus;
    }

    private static void addColums(List<ColumnInfo> localColumns, StringBuilder rowStringBuilder, List<ColumnInfo> columns, Set<ColumnInfo> columnsAlreadyAdded) {
        if (localColumns == null) {
            return;
        }
        for (ColumnInfo cInfo : localColumns) {
            if (columnsAlreadyAdded.contains(cInfo)) continue;
            columns.add(cInfo);
            String cDescr = cInfo.getDescription();
            rowStringBuilder.append(cDescr);
            rowStringBuilder.append(csvSeparator);
            columnsAlreadyAdded.add(cInfo);
        }
    }

    public static EZObjectType createApplicableInputType(ResultElement resultElement, ProjectInfo pi) {
        EZObjectType inputType = (EZObjectType)resultElement.getProperty("APPLICABLE_INPUT");
        if (inputType != null) {
            return inputType;
        }
        EZSourceProgramIDSg resourceSg = null;
        EZEntityID temporarEntity = null;
        switch (resultElement.getType()) {
            case PROJECT_INFO: {
                inputType = new EZSourceProjectInputType();
                EZEntityID entity = new EZEntityID();
                inputType.setEntID(entity);
                entity.addSegment((EZSegment)new EZSourceProjectIDSg(pi));
                inputType.setName(pi.getName());
                inputType.addProperty("PROJECT_INFO", (Object)pi);
                inputType.setContext(AnalysisBrowserContext.class);
                break;
            }
            case PROGRAM: 
            case SCL_PROCEDURE: 
            case ASSEMBLER_CSECT: 
            case ASSEMBLER_ENTRY: 
            case COBOL_OR_DDCL: {
                Integer programTypeId = (Integer)resultElement.getProperty("Program Type Id");
                if (programTypeId != null && programTypeId > 0) {
                    inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(programTypeId);
                    resourceSg = Utils.makeProgramSegment(inputType, resultElement);
                    inputType.addProperty("is program scl having procedure's information", resultElement.getProperty("is program scl having procedure's information"));
                    break;
                }
                Pair<EZObjectType, EZSegment> p = Utils.makeDDCLInput(resultElement);
                if (p == null) break;
                inputType = (EZObjectType)p.getFirst();
                resourceSg = (EZSegment)p.getSecond();
                break;
            }
            case IDMSX_SCHEMA: 
            case IDMSX_SUBSCHEMA: 
            case DDCL_ELEMENT_NAME: 
            case DDCL_ELEMENT: 
            case DDCL_ELEMENT_FILE_NAME: {
                Integer ddclElementTypeId;
                Boolean isIDMSX;
                Pair<EZObjectType, EZSegment> p = Utils.makeDDCLInput(resultElement);
                if (p != null) {
                    inputType = (EZObjectType)p.getFirst();
                    resourceSg = (EZSegment)p.getSecond();
                }
                if ((isIDMSX = (Boolean)resultElement.getProperty("Is IDMSX Key")) == null || !isIDMSX.booleanValue() || (ddclElementTypeId = (Integer)resultElement.getProperty(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName())) == null) break;
                switch (ddclElementTypeId) {
                    case 10: {
                        temporarEntity = new EZEntityID();
                        temporarEntity.addSegment((EZSegment)new EZSourceIDMSSetIDSg(resultElement.getDisplayName()));
                        inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(76));
                        break;
                    }
                    case 3: {
                        temporarEntity = new EZEntityID();
                        temporarEntity.addSegment((EZSegment)new EZSourceIDMSRecordIDSg(resultElement.getDisplayName()));
                        inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(75));
                    }
                }
                break;
            }
            case IDMS_SET: 
            case IDMS_RECORD: {
                Integer resourceTypeId = (Integer)resultElement.getProperty("Resource Type");
                if (resourceTypeId == 10) {
                    temporarEntity = new EZEntityID();
                    Integer ddclElementId = (Integer)resultElement.getProperty(DatabaseMetadata.SET_OR_RECORD_IN_DDCL_ID.getName());
                    temporarEntity.addSegment((EZSegment)new EZSourceDDCLElementIDSg(resultElement.getDisplayName(), Integer.valueOf(10), ddclElementId));
                    resourceTypeId = 76;
                } else if (resourceTypeId == 3) {
                    temporarEntity = new EZEntityID();
                    Integer ddclElementId = (Integer)resultElement.getProperty(DatabaseMetadata.SET_OR_RECORD_IN_DDCL_ID.getName());
                    temporarEntity.addSegment((EZSegment)new EZSourceDDCLElementIDSg(resultElement.getDisplayName(), Integer.valueOf(3), ddclElementId));
                    resourceTypeId = 75;
                }
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(resourceTypeId);
                if (resourceTypeId.equals(75)) {
                    resourceSg = new EZSourceIDMSRecordIDSg(resultElement.getDisplayName());
                    inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                    break;
                }
                if (!resourceTypeId.equals(76)) break;
                resourceSg = new EZSourceIDMSSetIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case SQL_TABLE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(1), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceSQLTableIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                String key1 = DatabaseMetadata.SQL_TABLE_NAME.getName();
                inputType.addProperty(key1, resultElement.getProperty(key1));
                key1 = DatabaseMetadata.SQL_TABLE_ID.getName();
                inputType.addProperty(key1, resultElement.getProperty(key1));
                break;
            }
            case DATACOM: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(182), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceDatacomTableIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case INCLUDE: {
                Integer pathID = (Integer)resultElement.getProperty(DatabaseMetadata.INCLUDE_RESOURCE_PATH_ID.getName());
                inputType = new EZSourceInclude();
                inputType.addProperty("include is not on disk", resultElement.getProperty("include is not on disk"));
                temporarEntity = new EZEntityID();
                temporarEntity.addSegment((EZSegment)Utils.makeProgramTypeIDSegment(resultElement));
                resourceSg = new EZSourceIncludeIDSg(resultElement.getDisplayName(), pathID);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case VARIABLE: {
                inputType = new EZSourceVariable();
                resourceSg = Utils.makeProgramSegment(inputType, resultElement);
                Integer level = (Integer)resultElement.getProperty(DatabaseMetadata.VAR_iLevel.getName());
                Integer varID = (Integer)resultElement.getProperty(DatabaseMetadata.VAR_ID.getName());
                String isField = (String)resultElement.getProperty(DatabaseMetadata.VAR_IsField.getName());
                String isFiller = (String)resultElement.getProperty(DatabaseMetadata.VAR_IsFiller.getName());
                Integer varStartRow = (Integer)resultElement.getProperty(DatabaseMetadata.VAR_START_ROW.getName());
                String pic = (String)resultElement.getProperty(DatabaseMetadata.VAR_PIC.getName());
                Integer father = (Integer)resultElement.getProperty(DatabaseMetadata.VAR_Father.getName());
                Integer ancestor = (Integer)resultElement.getProperty(DatabaseMetadata.VAR_ANCESTOR.getName());
                String type = (String)resultElement.getProperty(DatabaseMetadata.VAR_TYPE_ID.getName());
                Integer prgRefId = (Integer)resultElement.getProperty(DatabaseMetadata.VAR_PRG_REF_ID.getName());
                EZSourceVariableIDSg varSeg = new EZSourceVariableIDSg(resultElement.getName(), varID.toString(), String.valueOf(level), isField, isFiller, String.valueOf(varStartRow), pic, type, ancestor != null ? ancestor.toString() : null, prgRefId != null ? prgRefId.toString() : null, father != null ? father.toString() : null);
                inputType.addProperty("mainframe resource id sg", (Object)varSeg);
                temporarEntity = new EZEntityID();
                temporarEntity.addSegment((EZSegment)varSeg);
                temporarEntity.addSegment((EZSegment)Utils.makeProgramTypeIDSegment(resultElement));
                break;
            }
            case PARAMETER: 
            case SCL_VARIABLE: {
                break;
            }
            case DATASET: {
                Integer dsId = (Integer)resultElement.getProperty(DatabaseMetadata.DATASET_ID.getName());
                Boolean isCICS = !((String)resultElement.getProperty(DatabaseMetadata.DATASET_NAME.getName())).equalsIgnoreCase("UNKNOWN") && dsId == null;
                if (dsId == null && !isCICS.booleanValue()) break;
                String dsName = (String)resultElement.getProperty(DatabaseMetadata.DATASET_NAME.getName());
                String dsMembrerName = (String)resultElement.getProperty(DatabaseMetadata.DATASET_MEMBER_NAME.getName());
                inputType = new EZSourceDataset();
                String ddName = (String)resultElement.getProperty(DatabaseMetadata.DD_NAME.getName());
                EZSourceDataset.setLIBProperty((EZObjectType)inputType, (String)ddName);
                inputType.setName(dsName);
                Integer genNumber = (Integer)resultElement.getProperty(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName());
                resourceSg = new EZSourceDatasetIDSg(dsName, dsId, dsMembrerName, genNumber);
                resourceSg.setIncompleteSegment(true);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                inputType.addProperty("dataset from File Control Table, FCT", (Object)isCICS);
                break;
            }
            case DDNAME: {
                if (resultElement.getDisplayName().equalsIgnoreCase(NOT_AVAILABLE_LBL)) break;
                inputType = new EZSourceDDName();
                String ddName = resultElement.getDisplayName();
                resourceSg = new EZSourceDDNameIDSg(ddName);
                break;
            }
            case JCL_JOB: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22));
                String jobName = (String)resultElement.getProperty(DatabaseMetadata.JOB_NAME.getName());
                Integer jobId = (Integer)resultElement.getProperty(DatabaseMetadata.JOB_ID.getName());
                String memberName = (String)resultElement.getProperty(DatabaseMetadata.JOB_MEMBER_NAME.getName());
                Integer ca7jobId = (Integer)resultElement.getProperty(DatabaseMetadata.CA7_JOB_ID.getName());
                String ca7JobName = (String)resultElement.getProperty(DatabaseMetadata.CA7_JOB_NAME.getName());
                resourceSg = new EZSourceJobIDSg(jobName, jobId.intValue(), Integer.valueOf(22), memberName, ca7JobName, ca7jobId);
                temporarEntity = new EZEntityID();
                temporarEntity.addSegment((EZSegment)new EZSourceAAUTOJobIDSg(jobName, null));
                MainframeSourceNode node = (MainframeSourceNode)resultElement.getProperty("Node_Mainframe");
                if (node == null) break;
                String jobPath = node.getPath();
                inputType.addProperty("job_path", (Object)jobPath);
                resourceSg.setPath(jobPath);
                break;
            }
            case JCL_PROCEDURE: {
                inputType = new EZSourceExecProc();
                String procName = (String)resultElement.getProperty(DatabaseMetadata.PROC_EXEC_IN_STEP.getName());
                resourceSg = new EZSourceExecProcIDSg(procName);
                break;
            }
            case JCL_STEP: {
                Integer programTypeId = (Integer)resultElement.getProperty("Program Type Id");
                if (programTypeId != null && programTypeId > 0) {
                    inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(programTypeId);
                    resourceSg = Utils.makeProgramSegment(inputType, resultElement);
                    inputType.setName(resourceSg.getProgramName());
                    inputType.addProperty("stepInJCL executing pgm or proc", (Object)resultElement.getName());
                    break;
                }
                if (resultElement.getProperty(DatabaseMetadata.PROC_EXEC_IN_STEP.getName()) != null) {
                    inputType = new EZSourceExecProc();
                    String procName = (String)resultElement.getProperty(DatabaseMetadata.PROC_EXEC_IN_STEP.getName());
                    inputType.setName(procName);
                    resourceSg = new EZSourceExecProcIDSg(procName);
                    inputType.addProperty("stepInJCL executing pgm or proc", (Object)resultElement.getName());
                    break;
                }
                inputType = new EZSourceJclStep();
                resourceSg = new EZSourceJclStepIDSg(resultElement.getName());
                break;
            }
            case FILE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(9), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceFileIDSg(resultElement.getDisplayName(), 9);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                if (resultElement.getProperty("isPhysicalFile attribute") == null) break;
                inputType.addProperty("isPhysicalFile attribute", resultElement.getProperty("isPhysicalFile attribute"));
                break;
            }
            case LOGICAL_NAME: {
                if (resultElement.getDisplayName().equalsIgnoreCase(NOT_AVAILABLE_LBL)) break;
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(9), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceFileIDSg(resultElement.getDisplayName(), 9);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                inputType.addProperty("logical file attribute", (Object)resultElement.getDisplayName());
                break;
            }
            case TPMSX: {
                Integer screenID = (Integer)resultElement.getProperty(DatabaseMetadata.TPMSX_ID.getName());
                Integer prgTypeID = (Integer)resultElement.getProperty(DatabaseMetadata.PRG_TYPE_ID.getName());
                String screenName = resultElement.getDisplayName();
                if (prgTypeID == 1) {
                    inputType = new EZSourceScreen();
                    resourceSg = new EZSourceScreenIDSg(screenID, screenName, 101, null);
                    break;
                }
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(14), "EZ_OBJECT_TYPE_FOR_DDCL_ELEMENT");
                if (inputType == null) break;
                resourceSg = new EZSourceDDCLElementIDSg(screenName, Integer.valueOf(14), screenID);
                break;
            }
            case IMSDB_TERMINAL: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(18), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                Integer imstype = (Integer)resultElement.getProperty(DatabaseMetadata.IMSDB_TERMINAL_OR_DATABASE.getName());
                resourceSg = new EZSourceIMSDBIDSg(resultElement.getDisplayName(), imstype.intValue());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case MQ_QUEUE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(81), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceQueueIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case MQ_MANAGER: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(79), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceQueueManagerIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case ADABAS_DB: {
                if (resultElement.getProperty("adabasNotAvailable") != null) break;
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(194), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceAdabasIDSg(resultElement.getDisplayName());
                ((EZSourceAdabasIDSg)resourceSg).setDbName((String)resultElement.getProperty(DatabaseMetadata.ADABAS_DB.getName()));
                break;
            }
            case ADABAS_VIEW: {
                if (resultElement.getProperty("adabasNotAvailable") != null) break;
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(62), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceAdabasIDSg(resultElement.getDisplayName());
                ((EZSourceAdabasIDSg)resourceSg).setViewName((String)resultElement.getProperty(DatabaseMetadata.ADABAS_VIEW.getName()));
                break;
            }
            case ADABAS_FILE: {
                if (resultElement.getProperty("adabasNotAvailable") != null) break;
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(56), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceAdabasIDSg(resultElement.getDisplayName());
                resourceSg.setNumber(((Integer)resultElement.getProperty(DatabaseMetadata.ADABAS_FILE_ID.getName())).intValue());
                ((EZSourceAdabasIDSg)resourceSg).setFileName((String)resultElement.getProperty(DatabaseMetadata.ADABAS_FILE.getName()));
                ((EZSourceAdabasIDSg)resourceSg).setDbName((String)resultElement.getProperty(DatabaseMetadata.ADABAS_DB.getName()));
                break;
            }
            case DAL: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(189), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceDALIDSg(resultElement.getDisplayName());
                Integer occID = (Integer)resultElement.getProperty(DatabaseMetadata.RESOURCE_OCCURID.getName());
                ((EZSourceDALIDSg)resourceSg).setVirtual(Integer.valueOf(occID));
                break;
            }
            case DBI_TABLE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(190), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                Integer dbiID = (Integer)resultElement.getProperty(DatabaseMetadata.RESOURCE_ID.getName());
                resourceSg = new EZSourceDBIIDSg(dbiID, resultElement.getDisplayName());
                break;
            }
            case SQL_FIELD_TABLE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(187), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String tnKey = DatabaseMetadata.SQL_TABLE_NAME.getName();
                String tableName = (String)resultElement.getProperty(tnKey);
                inputType.addProperty(tnKey, (Object)tableName);
                String key = DatabaseMetadata.SQL_TABLE_FIELD_ID.getName();
                Integer fieldId = (Integer)resultElement.getProperty(key);
                inputType.addProperty(key, (Object)fieldId);
                resourceSg = new EZSourceSQLFieldTableIDSg(resultElement.getDisplayName(), fieldId, tableName);
                key = DatabaseMetadata.SQL_TABLE_FIELD_NAME.getName();
                inputType.addProperty(key, resultElement.getProperty(key));
                key = DatabaseMetadata.SQL_TABLE_ID.getName();
                inputType.addProperty(key, resultElement.getProperty(key));
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case CTRLM_JOB: {
                String keyJobId = DatabaseMetadata.CTRLM_JOB_ID.getName();
                String jobGenId = (String)resultElement.getProperty(keyJobId);
                String keyJclJobId = DatabaseMetadata.JCL_JOB_ID.getName();
                String jclJobId = (String)resultElement.getProperty(keyJclJobId);
                String keyJclJobName = DatabaseMetadata.JCL_JOB_NAME.getName();
                String jclJobName = (String)resultElement.getProperty(keyJclJobName);
                String keyCtrlmJobMemberName = DatabaseMetadata.CTRLM_JOB_MEMBER_NAME.getName();
                String ctrlmJobMemberName = (String)resultElement.getProperty(keyCtrlmJobMemberName);
                if (jclJobId != null && !jclJobId.isEmpty()) {
                    inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22));
                    Boolean deleted = false;
                    EZSourceJobIDSg jclJobSg = new EZSourceJobIDSg(jclJobName, jclJobId, 22, ctrlmJobMemberName, deleted.booleanValue());
                    temporarEntity = new EZEntityID();
                    temporarEntity.addSegment((EZSegment)jclJobSg);
                } else {
                    inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(224), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                }
                String Key = DatabaseMetadata.CTRLM_JOB.getName();
                String tableJob = (String)resultElement.getProperty(Key);
                inputType.addProperty(Key, (Object)tableJob);
                Key = DatabaseMetadata.CTRLM_APPLICATION.getName();
                String tableApp = (String)resultElement.getProperty(Key);
                inputType.addProperty(Key, (Object)tableApp);
                Key = DatabaseMetadata.CTRLM_FOLDER.getName();
                String tableFolder = (String)resultElement.getProperty(Key);
                inputType.addProperty(Key, (Object)tableFolder);
                resourceSg = new ControlmJobSg(Integer.valueOf(jobGenId), resultElement.getDisplayName(), tableApp, tableFolder, ctrlmJobMemberName, null, null);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case CTRLM_APPLICATION: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(5224), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String applicationName = DatabaseMetadata.CTRLM_APPLICATION.getName();
                String tableApplication = (String)resultElement.getProperty(applicationName);
                inputType.addProperty(applicationName, (Object)tableApplication);
                resourceSg = new ControlmApplicationSg(tableApplication);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case IMSDB_SEGMENT: 
            case IMSDB_LOGICAL_SEGMENT: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(209), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String dbKey = DatabaseMetadata.IMS_DB_NAME.getName();
                String dbName = (String)resultElement.getProperty(dbKey);
                resourceSg = new EZSourceIMSDBSegmentIDSg(resultElement.getDisplayName(), dbName);
                Integer sid = (Integer)resultElement.getProperty(DatabaseMetadata.IMSDB_SEGMENT_ID.getName());
                if (sid != null) {
                    ((EZSourceIMSDBSegmentIDSg)resourceSg).setSegmentID(sid);
                }
                if (((Boolean)resultElement.hasProperty(DatabaseMetadata.IMSDB_SEG_SOURCE_ID.getName())).booleanValue()) {
                    Integer sourceSgId = (Integer)resultElement.getProperty(DatabaseMetadata.IMSDB_SEG_SOURCE_ID.getName());
                    if (sourceSgId == null || sourceSgId <= 0) break;
                    inputType.addProperty("LOGICAL_SEGMENT_TYPE", (Object)true);
                    break;
                }
                if (!resultElement.getType().equals((Object)ResultElementType.IMSDB_LOGICAL_SEGMENT)) break;
                inputType.addProperty("LOGICAL_SEGMENT_TYPE", (Object)true);
                break;
            }
            case IMSDB_FIELD: 
            case IMSDB_SEARCH_FIELD: {
                Integer fid;
                if (resultElement.getDisplayName().equalsIgnoreCase(NOT_AVAILABLE_LBL)) break;
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(210), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String fieldName = resultElement.getName();
                String dbName = (String)resultElement.getProperty(DatabaseMetadata.IMS_DB_NAME.getName());
                String segName = (String)resultElement.getProperty(DatabaseMetadata.IMSDB_SEGMENT_NAME.getName());
                resourceSg = new EZSourceIMSDBFieldIDSg(resultElement.getDisplayName(), segName, dbName);
                if (resultElement.getProperty("IS_LOGICAL_CONTEXT") != null && ((Boolean)resultElement.getProperty("IS_LOGICAL_CONTEXT")).booleanValue()) {
                    inputType.addProperty("IS_LOGICAL_CONTEXT", (Object)Boolean.TRUE);
                }
                if ((fid = (Integer)resultElement.getProperty(DatabaseMetadata.IMSDB_FIELD_ID.getName())) != null) {
                    ((EZSourceIMSDBFieldIDSg)resourceSg).setFieldID(fid);
                }
                inputType.setName(fieldName);
                break;
            }
            case IMSDB_DATABASE: 
            case IMSDB_FULL_FUNCTION: 
            case IMSDB_FAST_PATH: 
            case IMSDB_FILE_ACCESS: 
            case IMSDB_LOGICAL: 
            case IMSDB_NOT_AVAILABLE: {
                String dbName = resultElement.getName();
                Integer dbid = (Integer)resultElement.getProperty(DatabaseMetadata.IMS_DB_ID.getName());
                Integer dbtype = (Integer)resultElement.getProperty(DatabaseMetadata.IMSDB_ACCESS_TYPE.getName());
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(18), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                inputType.addProperty("IMSDB_DATABASE_TYPE", (Object)dbtype);
                inputType.addProperty("IMSDB_DATABASE_ID", (Object)dbid);
                inputType.setName(dbName);
                resourceSg = new EZSourceIMSDatabaseIDSg(dbName);
                break;
            }
            case CATALOG_TARGET: {
                String programType;
                Integer id = (Integer)resultElement.getProperty(DatabaseMetadata.CATALOG_TARGET_ID.getName());
                String tgType = (String)resultElement.getProperty(DatabaseMetadata.CATALOG_TARGET_TYPE.getName());
                String targetName = (String)resultElement.getProperty(DatabaseMetadata.CATALOG_TARGET_NAME.getName());
                if (ApiTargetType.IMS_TRANSACTION.name().equals(tgType)) {
                    inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(20), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                    resultElement.getName();
                    inputType.setName(targetName);
                    EZEntityID entityId = new EZEntityID();
                    entityId.addSegment((EZSegment)new EZSourceProjectIDSg(pi));
                    resourceSg = new EZSourceTransactionIDSg(targetName);
                    ((EZSourceTransactionIDSg)resourceSg).setTransactionType(20);
                    EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg(resultElement.getProperty("Node_Mainframe"));
                    entityId.addSegment((EZSegment)sg);
                    inputType.setEntID(entityId);
                    break;
                }
                if (!ApiTargetType.PROGRAM.name().equals(tgType)) break;
                String targetPath = null;
                Integer programTypeId = (Integer)resultElement.getProperty(DatabaseMetadata.CATALOG_TARGET_TYPE_ID.getName());
                if (programTypeId != null && programTypeId > 0) {
                    resultElement.addProperty("Program Type Id", programTypeId);
                    resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                    targetPath = (String)resultElement.getProperty(DatabaseMetadata.PRG_PATH.getName());
                    String cfr_ignored_0 = (String)resultElement.getProperty("Ancestor Name");
                    Integer cfr_ignored_1 = (Integer)resultElement.getProperty("Ancestor Id");
                    inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(programTypeId);
                    resourceSg = Utils.makeProgramSegment(inputType, resultElement);
                }
                if ((programType = ProgramUtils.getProgramTypeAsString(resultElement)) == null) break;
                ProgramUtils.setPropertiesViewer(resultElement, targetName, targetPath, programType);
            }
        }
        if (inputType != null) {
            if (inputType.getName() == null) {
                inputType.setName(resultElement.getName());
            }
            if (resourceSg != null) {
                EZEntityID entityId = new EZEntityID();
                entityId.addSegment((EZSegment)new EZSourceProjectIDSg(pi));
                entityId.addSegment((EZSegment)resourceSg);
                if (temporarEntity != null) {
                    entityId.addEntitySegments(temporarEntity);
                }
                inputType.setEntID(entityId);
            }
            resultElement.addProperty("APPLICABLE_INPUT", inputType);
        }
        return inputType;
    }

    private static Pair<EZObjectType, EZSegment> makeDDCLInput(ResultElement resultElement) {
        EZObjectType inputType = null;
        EZSourceDDCLElementIDSg resourceSg = null;
        Integer ddclElementTypeId = (Integer)resultElement.getProperty(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName());
        Integer ddclElementID = (Integer)resultElement.getProperty(DatabaseMetadata.DDCL_ELEM_ID.getName());
        if (ddclElementTypeId != null && ddclElementID != null && (inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(ddclElementTypeId, "EZ_OBJECT_TYPE_FOR_DDCL_ELEMENT")) != null) {
            String name = (String)resultElement.getProperty(DatabaseMetadata.DDCL_ELEM_NAME.getName());
            resourceSg = new EZSourceDDCLElementIDSg(name, ddclElementTypeId, ddclElementID);
            return new Pair((Object)inputType, (Object)resourceSg);
        }
        return null;
    }

    private static EZSourceProgramTypeIDSg makeProgramTypeIDSegment(ResultElement resultElement) {
        Integer programTypeId = (Integer)resultElement.getProperty("Program Type Id");
        return new EZSourceProgramTypeIDSg(programTypeId);
    }

    public static EZSourceProgramIDSg makeProgramSegment(EZObjectType inpType, ResultElement resultElement) {
        Integer programId = (Integer)resultElement.getProperty(DatabaseMetadata.PRG_ID.getName());
        Integer programTypeId = (Integer)resultElement.getProperty("Program Type Id");
        String prgName = (String)resultElement.getProperty("Program name");
        if (prgName == null) {
            prgName = resultElement.getName();
        }
        String programPath = (String)resultElement.getProperty(DatabaseMetadata.PRG_PATH.getName());
        Boolean occur = null;
        if (programPath != null) {
            occur = !programPath.isEmpty();
            inpType.addProperty("program_path", (Object)programPath);
        }
        inpType.addProperty("program occur", occur);
        EZSourceProgramIDSg prgSg = new EZSourceProgramIDSg(prgName, programId, programTypeId, occur);
        prgSg.setPath(programPath);
        String ancestorName = (String)resultElement.getProperty("Ancestor Name");
        if (ancestorName != null && !ancestorName.isEmpty()) {
            prgSg.setAncestorName(ancestorName);
            Integer ancestorId = (Integer)resultElement.getProperty("Ancestor Id");
            prgSg.setAncestorId(ancestorId);
        }
        return prgSg;
    }

    public static void completeProjectInfo(ResultElement resultElement, ProjectInfo projectInfo) {
        ArrayList<ProjectInfo> list = (ArrayList<ProjectInfo>)resultElement.getProperty("ProjectInfo List");
        if (list == null) {
            list = new ArrayList<ProjectInfo>();
            resultElement.addProperty("ProjectInfo List", list);
        }
        if (!list.contains(projectInfo)) {
            list.add(projectInfo);
        }
    }

    public static ResultElement getCategory(ResultElementType type, ResultElement parent, String forcedCategoryName) {
        ResultElement categoryResultElement;
        ResultElementType categoryType = null;
        switch (type) {
            case PROGRAM: {
                categoryType = ResultElementType.PROGRAM_CATEGORY;
                break;
            }
            case LOAD_MODULE: {
                categoryType = ResultElementType.LOAD_MODULE_CATEGORY;
                break;
            }
            case UTILITY: {
                categoryType = ResultElementType.UTILITY_CATEGORY;
                break;
            }
            case STMT_TYPE: {
                categoryType = ResultElementType.STMT_READ_WRITE_CATEGORY;
                break;
            }
            case VARIABLE: {
                categoryType = ResultElementType.VARIABLE_CATEGORY;
                break;
            }
            case PARAGRAPH: {
                categoryType = ResultElementType.PARAGRAPH_CATEGORY;
                break;
            }
            case SUBROUTINE: {
                categoryType = ResultElementType.SUBROUTINE_CATEGORY;
                break;
            }
            case PROCEDURE: {
                categoryType = ResultElementType.PROCEDURE_CATEGORY;
                break;
            }
            case INCLUDE: {
                categoryType = ResultElementType.INCLUDE_CATEGORY;
                break;
            }
            case MACRO: {
                categoryType = ResultElementType.MACRO_CATEGORY;
                break;
            }
            case ASSEMBLER_CSECT: {
                categoryType = ResultElementType.ASSEMBLER_CSECT_CATEGORY;
                break;
            }
            case ASSEMBLER_ENTRY: {
                categoryType = ResultElementType.ASSEMBLER_ENTRY_CATEGORY;
                break;
            }
            case IDMS_SET: {
                categoryType = ResultElementType.IDMS_SET_CATEGORY;
                break;
            }
            case IDMS_RECORD: {
                categoryType = ResultElementType.IDMS_RECORD_CATEGORY;
                break;
            }
            case JCL_JOB: {
                categoryType = ResultElementType.INVOKEDBY_CATEGORY;
                break;
            }
            case JCL_STEP: {
                categoryType = ResultElementType.STEP_CATEGORY;
                break;
            }
            case DATASET: {
                categoryType = ResultElementType.DATASET_CATEGORY;
                break;
            }
            case JCL_PROCEDURE: {
                categoryType = ResultElementType.JCL_PROCEDURE_CATEGORY;
                break;
            }
            case PARAMETER: {
                categoryType = ResultElementType.PARAMETER_CATEGORY;
                break;
            }
            case SCL_VARIABLE: {
                categoryType = ResultElementType.SCL_VARIABLE_CATEGORY;
                break;
            }
            case SCL_PROC_SYNONYM: {
                categoryType = ResultElementType.SCL_PROC_SYNONYM_CATEGORY;
                break;
            }
            case DDCL_ELEMENT_NAME: 
            case DDCL_ELEMENT: 
            case COBOL_OR_DDCL: {
                categoryType = ResultElementType.DDCL_ELEMENT_TYPE_CATEGORY;
                break;
            }
            case IMSDB_TERMINAL: {
                categoryType = ResultElementType.IMSDB_TERMINAL_CATEGORY;
                break;
            }
            case IMSDB_DATABASE: {
                categoryType = ResultElementType.IMSDB_DATABASE_CATEGORY;
                break;
            }
            case IMSDB_FAST_PATH: {
                categoryType = ResultElementType.IMSDB_FAST_PATH_CATEGORY;
                break;
            }
            case IMSDB_FULL_FUNCTION: {
                categoryType = ResultElementType.IMSDB_FULL_FUNCTION_CATEGORY;
                break;
            }
            case IMSDB_FILE_ACCESS: {
                categoryType = ResultElementType.IMSDB_FILE_ACCESS_CATEGORY;
                break;
            }
            case IMSDB_LOGICAL: {
                categoryType = ResultElementType.IMSDB_LOGICAL_CATEGORY;
                break;
            }
            case IMSDB_NOT_AVAILABLE: {
                categoryType = ResultElementType.IMSDB_NOT_AVAILABLE_CATEGORY;
                break;
            }
            case DDNAME: {
                categoryType = ResultElementType.DDNAME_CATEGORY;
                break;
            }
            case IDCAMS_AMS_STMT: {
                categoryType = ResultElementType.IDCAMS_AMS_CATEGORY;
            }
        }
        String categoryKey = forcedCategoryName;
        String categoryDisplayName = forcedCategoryName;
        if (forcedCategoryName == null) {
            categoryKey = categoryType.name();
            categoryDisplayName = categoryType.getDisplayName();
        }
        if ((categoryResultElement = parent.getChild(categoryKey)) == null) {
            categoryResultElement = new ResultElement(categoryDisplayName, categoryType, parent);
            parent.addChild(categoryKey, categoryResultElement);
        }
        return categoryResultElement;
    }

    public static String getParagraphLabelForPrgType(int prgTypeId) {
        String lbl = "";
        switch (prgTypeId) {
            case 1: 
            case 9: {
                lbl = Messages.getString(Utils.class, "paragraph.lbl");
                break;
            }
            case 3: 
            case 10: {
                lbl = Messages.getString(Utils.class, "subroutine.lbl");
                break;
            }
            case 2: {
                lbl = Messages.getString(Utils.class, "procedure.lbl");
            }
        }
        return lbl;
    }

    public static String readOrWriteStmt(Integer bRead) {
        String categoryName = Messages.getString(ProgramVarTreeProvider.class, "read.category.name");
        if (bRead == 0 || bRead == 2) {
            categoryName = Messages.getString(ProgramVarTreeProvider.class, "write.category.name");
        }
        return categoryName;
    }

    public static Map<ResultElementType, StringBuilder> processInputs(List<EZObjectType> objTypes, ResultElementType ... ret) {
        return Utils.processInputs(objTypes, false, ret);
    }

    public static Map<ResultElementType, StringBuilder> processInputs(List<EZObjectType> objTypes, boolean separateAncestorAndChild, ResultElementType ... ret) {
        objTypes = new ArrayList<EZObjectType>(new HashSet<EZObjectType>(objTypes));
        HashMap<ResultElementType, StringBuilder> defaultPatterns = new HashMap<ResultElementType, StringBuilder>();
        if (objTypes != null) {
            HashSet<String> ancestors = new HashSet<String>();
            for (EZObjectType objType : objTypes) {
                EZSourceJobIDSg segment;
                ControlmJobSg sg;
                EZSourceProgramIDSg ezSourceProgramIDSg;
                EZEntityID entID;
                String name = objType.getName();
                if (objType instanceof EZSourceAdabas) {
                    EZSourceAdabasIDSg adabasSg = (EZSourceAdabasIDSg)objType.getEntID().getSegment(EZSourceAdabasIDSg.class);
                    name = adabasSg.getResourceName();
                    if (objType instanceof EZSourceAdabasFile) {
                        String fName = adabasSg.getFileName();
                        Utils.addInput(defaultPatterns, ResultElementType.ADABAS_FILE, fName);
                        String db = adabasSg.getDbName();
                        if (db == null || db.isEmpty()) continue;
                        Utils.addInput(defaultPatterns, ResultElementType.ADABAS_DB, db);
                        continue;
                    }
                    if (objType instanceof EZSourceAdabasDB) {
                        Utils.addInput(defaultPatterns, ResultElementType.ADABAS_DB, adabasSg.getDbName());
                        continue;
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.ADABAS_VIEW, adabasSg.getViewName());
                    continue;
                }
                if (separateAncestorAndChild && objType instanceof EZAsmCSECTProgram) {
                    entID = objType.getEntID();
                    EZSourceProgramIDSg ezProgSg = (EZSourceProgramIDSg)entID.getSegment(EZSourceProgramIDSg.class);
                    String nameCsect = ezProgSg.getProgramName();
                    String ancestorName = ezProgSg.getAncestorName();
                    Utils.addInput(defaultPatterns, ResultElementType.ASSEMBLER_CSECT, nameCsect);
                    Utils.addInput(defaultPatterns, ResultElementType.PROGRAM, ancestorName);
                    ancestors.add(ancestorName);
                    continue;
                }
                if (separateAncestorAndChild && objType instanceof EZAsmEntryProgram) {
                    entID = objType.getEntID();
                    EZSourceProgramIDSg ezProgSg = (EZSourceProgramIDSg)entID.getSegment(EZSourceProgramIDSg.class);
                    String ancestorName = ezProgSg.getAncestorName();
                    String nameEntry = ezProgSg.getProgramName();
                    Utils.addInput(defaultPatterns, ResultElementType.ASSEMBLER_ENTRY, nameEntry);
                    Utils.addInput(defaultPatterns, ResultElementType.PROGRAM, ancestorName);
                    ancestors.add(ancestorName);
                    continue;
                }
                if (separateAncestorAndChild && objType instanceof EZSCLProgram) {
                    EZSCLProgram sclProgram = (EZSCLProgram)objType;
                    EZEntityID entity = sclProgram.getEntID();
                    EZSourceProgramIDSg prgIdSg = (EZSourceProgramIDSg)entity.getSegment(EZSourceProgramIDSg.class);
                    if (name == null) {
                        name = prgIdSg.getProgramName();
                    }
                    if (prgIdSg.getTypeId() == 13 || sclProgram.getProperty("is program scl having procedure's information") != null && ((Boolean)sclProgram.getProperty("is program scl having procedure's information")).booleanValue()) {
                        Utils.addInput(defaultPatterns, ResultElementType.PROGRAM, name);
                        continue;
                    }
                    if (prgIdSg.getTypeId() != 19) continue;
                    Utils.addInput(defaultPatterns, ResultElementType.SCL_PROCEDURE, name);
                    continue;
                }
                if (separateAncestorAndChild && objType instanceof EZCobolProgram) {
                    ezSourceProgramIDSg = (EZSourceProgramIDSg)objType.getEntID().getSegment(EZSourceProgramIDSg.class);
                    name = ezSourceProgramIDSg.getProgramName();
                    Utils.addInput(defaultPatterns, ResultElementType.PROGRAM, name);
                    continue;
                }
                if (objType instanceof EZSourceProgram) {
                    ezSourceProgramIDSg = (EZSourceProgramIDSg)objType.getEntID().getSegment(EZSourceProgramIDSg.class);
                    name = ezSourceProgramIDSg.getProgramName();
                    String ancestorName = ezSourceProgramIDSg.getAncestorName();
                    String prgName = "";
                    if (ancestorName != null && !ancestorName.trim().isEmpty()) {
                        prgName = String.valueOf(ancestorName) + ":";
                    }
                    prgName = String.valueOf(prgName) + name;
                    Utils.addInput(defaultPatterns, ResultElementType.PROGRAM, prgName);
                    if (objType.getProperty("stepInJCL executing pgm or proc") == null) continue;
                    Utils.addInput(defaultPatterns, ResultElementType.JCL_STEP, (String)objType.getProperty("stepInJCL executing pgm or proc"));
                    continue;
                }
                if (objType instanceof EZSourceInclude) {
                    if (name == null) {
                        EZSourceIncludeIDSg eZSourceIncludeIDSg = (EZSourceIncludeIDSg)objType.getEntID().getSegment(EZSourceIncludeIDSg.class);
                        name = eZSourceIncludeIDSg.getResourceName();
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.INCLUDE, name);
                    continue;
                }
                if (objType instanceof EZSourceDAL) {
                    Utils.addInput(defaultPatterns, ResultElementType.DAL, name);
                    continue;
                }
                if (objType instanceof EZSourceDBI) {
                    Utils.addInput(defaultPatterns, ResultElementType.DBI_TABLE, name);
                    continue;
                }
                if (objType instanceof EZAMNode) {
                    if (objType instanceof EZDDCLFile || objType instanceof EZDDCLSchema || objType instanceof EZDDCLSubschema) {
                        if (ret != null && ret.length > 0) {
                            Utils.addInput(defaultPatterns, ret[0], name);
                            continue;
                        }
                        Utils.addInput(defaultPatterns, ResultElementType.DDCL_ELEMENT_NAME, name);
                        continue;
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.DDCL_ELEMENT_NAME, name);
                    continue;
                }
                if (objType instanceof EZSourceSQLTable) {
                    Utils.addInput(defaultPatterns, ResultElementType.SQL_TABLE, name);
                    continue;
                }
                if (objType instanceof EZSourceDatacom) {
                    Utils.addInput(defaultPatterns, ResultElementType.DATACOM, name);
                    continue;
                }
                if (objType instanceof EZSourceDataset) {
                    entID = objType.getEntID();
                    EZSourceDatasetIDSg ezProgSg = (EZSourceDatasetIDSg)entID.getSegment(EZSourceDatasetIDSg.class);
                    String datasetName = ezProgSg.getDatasetName();
                    String datasetMemberName = ezProgSg.getDatasetMemberName();
                    name = DatasetUtils.getFilterDSName(datasetName, datasetMemberName);
                    Utils.addInput(defaultPatterns, ResultElementType.DATASET, name);
                    continue;
                }
                if (objType instanceof EZJobInputType) {
                    if (name == null) {
                        ezSourceProgramIDSg = (EZSourceJobIDSg)objType.getEntID().getSegment(EZSourceJobIDSg.class);
                        name = ezSourceProgramIDSg.getJobName();
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.JCL_JOB, name);
                    sg = (ControlmJobSg)objType.getEntID().getSegment(ControlmJobSg.class);
                    if (sg == null) continue;
                    Utils.handleCtrlMInfo(defaultPatterns, sg);
                    continue;
                }
                if (objType instanceof EZSourceJclStep) {
                    if (name == null) {
                        segment = (EZSourceJobIDSg)objType.getEntID().getSegment(EZSourceJobIDSg.class);
                        name = segment.getJobName();
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.JCL_STEP, name);
                    continue;
                }
                if (objType instanceof EZSourceDDName) {
                    if (name == null) {
                        segment = (EZSourceDDNameIDSg)objType.getEntID().getSegment(EZSourceDDNameIDSg.class);
                        name = segment.getResourceName();
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.DDNAME, name);
                    continue;
                }
                if (objType instanceof EZSourceFile) {
                    EZSourceFile file = (EZSourceFile)objType;
                    boolean isPhysicalFile = file.getProperty("isPhysicalFile attribute") != null;
                    name = (String)(isPhysicalFile ? file.getProperty("isPhysicalFile attribute") : file.getName());
                    if (name == null) {
                        EZSourceFileIDSg segment2 = (EZSourceFileIDSg)objType.getEntID().getSegment(EZSourceFileIDSg.class);
                        name = segment2.getResourceName();
                    }
                    Utils.addInput(defaultPatterns, isPhysicalFile ? ResultElementType.FILE : ResultElementType.LOGICAL_NAME, name);
                    continue;
                }
                if (objType instanceof EZSourceSQLTableField) {
                    Utils.addInput(defaultPatterns, ResultElementType.SQL_FIELD_TABLE, name);
                    continue;
                }
                if (objType instanceof EZSourceExecProc) {
                    Utils.addInput(defaultPatterns, ResultElementType.JCL_PROCEDURE, name);
                    continue;
                }
                if (objType instanceof EZSourceQueue) {
                    if (name == null) {
                        segment = (EZSourceQueueIDSg)objType.getEntID().getSegment(EZSourceQueueIDSg.class);
                        name = segment.getResourceName();
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.MQ_QUEUE, name);
                    continue;
                }
                if (objType instanceof EZSourceQueueManager) {
                    Utils.addInput(defaultPatterns, ResultElementType.MQ_MANAGER, name);
                    continue;
                }
                if (objType instanceof EZSourceIDMSSet) {
                    if (name == null) {
                        segment = (EZSourceIDMSSetIDSg)objType.getEntID().getSegment(EZSourceIDMSSetIDSg.class);
                        name = segment.getResourceName();
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.IDMS_SET, name);
                    Utils.addInput(defaultPatterns, ResultElementType.DDCL_ELEMENT_NAME, name);
                    continue;
                }
                if (objType instanceof EZSourceIDMSRecord) {
                    if (name == null) {
                        segment = (EZSourceIDMSRecordIDSg)objType.getEntID().getSegment(EZSourceIDMSRecordIDSg.class);
                        name = segment.getResourceName();
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.IDMS_RECORD, name);
                    Utils.addInput(defaultPatterns, ResultElementType.DDCL_ELEMENT_NAME, name);
                    continue;
                }
                if (objType instanceof EZSourceIMSDB) {
                    String filter = objType.getName();
                    Integer imstype = (Integer)objType.getProperty("imsdb TERMINAL, DATABASE, TERMINAL_OR_TRANSACTION");
                    if (!defaultPatterns.containsKey(ResultElementType.IMSDB)) {
                        if (18 == imstype) {
                            filter = IMSDBQueryBuilder.DATABASE_PREFFIX.concat(filter);
                        } else if (19 == imstype) {
                            filter = IMSDBQueryBuilder.TERMINAL_PREFFIX.concat(filter);
                        }
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.IMSDB, filter);
                    continue;
                }
                if (objType instanceof EZSourceVariable) {
                    if (name == null) {
                        segment = (EZSourceVariableIDSg)objType.getEntID().getSegment(EZSourceVariableIDSg.class);
                        name = segment.getResourceName();
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.VARIABLE, name);
                    continue;
                }
                if (objType instanceof EZSourceIMSDBSegment) {
                    segment = (EZSourceIMSDBSegmentIDSg)objType.getEntID().getSegment(EZSourceIMSDBSegmentIDSg.class);
                    String dbdName = segment.getDBDName();
                    Boolean isLogical = (Boolean)objType.getProperty("LOGICAL_SEGMENT_TYPE");
                    if (isLogical != null && isLogical.booleanValue()) {
                        Utils.addInput(defaultPatterns, ResultElementType.IMSDB_LOGICAL_SEGMENT, name);
                        if (dbdName == null) continue;
                        Utils.addInput(defaultPatterns, ResultElementType.IMSDB_LOGICAL, dbdName);
                        continue;
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.IMSDB_SEGMENT, name);
                    if (dbdName == null) continue;
                    Utils.addInput(defaultPatterns, ResultElementType.IMSDB_DATABASE, dbdName);
                    continue;
                }
                if (objType instanceof EZSourceIMSDBField) {
                    segment = (EZSourceIMSDBFieldIDSg)objType.getEntID().getSegment(EZSourceIMSDBFieldIDSg.class);
                    String dbdName = segment.getDBDName();
                    String segName = segment.getIMSDBSegmentName();
                    Boolean isLogicalContext = (Boolean)objType.getProperty("IS_LOGICAL_CONTEXT");
                    if (isLogicalContext != null && isLogicalContext.booleanValue()) {
                        if (segName != null) {
                            Utils.addInput(defaultPatterns, ResultElementType.IMSDB_LOGICAL_SEGMENT, segName);
                        }
                        if (dbdName != null) {
                            Utils.addInput(defaultPatterns, ResultElementType.IMSDB_LOGICAL, dbdName);
                        }
                    } else {
                        if (segName != null) {
                            Utils.addInput(defaultPatterns, ResultElementType.IMSDB_SEGMENT, segName);
                        }
                        if (dbdName != null) {
                            Utils.addInput(defaultPatterns, ResultElementType.IMSDB_DATABASE, dbdName);
                        }
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.IMSDB_FIELD, name);
                    Utils.addInput(defaultPatterns, ResultElementType.IMSDB_SEARCH_FIELD, name);
                    continue;
                }
                if (objType instanceof EZSourceIMSDatabase) {
                    Integer accessType = (Integer)objType.getProperty("IMSDB_DATABASE_TYPE");
                    if (accessType != null && accessType == IMSDBAccessType.LOGICAL.ordinal() + 1) {
                        Utils.addInput(defaultPatterns, ResultElementType.IMSDB_LOGICAL, name);
                        continue;
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.IMSDB_DATABASE, name);
                    continue;
                }
                if (objType instanceof CatalogAPIInputType) {
                    CatalogAPISg catalogApiSg = (CatalogAPISg)objType.getEntID().getSegment(CatalogAPISg.class);
                    ApiInterface node = catalogApiSg.getNode();
                    name = catalogApiSg.getNode().getName();
                    switch (node.getType()) {
                        case API: {
                            Utils.addInput(defaultPatterns, ResultElementType.CATALOG_API, name);
                            break;
                        }
                        case SERVICE: {
                            Utils.addInput(defaultPatterns, ResultElementType.CATALOG_SERVICE, name);
                            break;
                        }
                    }
                    continue;
                }
                if (objType instanceof ControlmApplication) {
                    String applicationName = ((ControlmApplicationSg)objType.getEntID().getSegment(ControlmApplicationSg.class)).getJobApplication();
                    Utils.addInput(defaultPatterns, ResultElementType.CTRLM_APPLICATION, applicationName);
                    continue;
                }
                if (!(objType instanceof ControlmJobObjectType)) continue;
                sg = (ControlmJobSg)objType.getEntID().getSegment(ControlmJobSg.class);
                Utils.handleCtrlMInfo(defaultPatterns, sg);
            }
        }
        return defaultPatterns;
    }

    private static void handleCtrlMInfo(Map<ResultElementType, StringBuilder> defaultPatterns, ControlmJobSg segment) {
        String nameApplication = segment.getJobApplication();
        Utils.addInput(defaultPatterns, ResultElementType.CTRLM_APPLICATION, nameApplication);
        String nameFolder = segment.getJobFolderName();
        Utils.addInput(defaultPatterns, ResultElementType.CTRLM_FOLDER, nameFolder);
        String nameJob = segment.getJobName();
        Utils.addInput(defaultPatterns, ResultElementType.CTRLM_JOB, nameJob);
    }

    public static void addInput(Map<ResultElementType, StringBuilder> defaultPatterns, ResultElementType type, String inputName) {
        if (inputName != null) {
            StringBuilder sb = defaultPatterns.get(type);
            if (sb == null) {
                sb = new StringBuilder();
                defaultPatterns.put(type, sb);
            } else {
                sb.append(",");
                if (ResultElementType.IMSDB.equals((Object)type)) {
                    int idxPrefix = sb.indexOf(IMSDBQueryBuilder.DATABASE_PREFFIX);
                    int length = IMSDBQueryBuilder.DATABASE_PREFFIX.length();
                    if (idxPrefix < 0) {
                        idxPrefix = sb.indexOf(IMSDBQueryBuilder.TERMINAL_PREFFIX);
                        length = IMSDBQueryBuilder.TERMINAL_PREFFIX.length();
                    }
                    if (idxPrefix == 0) {
                        String withoutType = sb.substring(length, sb.length());
                        sb.delete(0, sb.length());
                        sb.append(withoutType);
                    }
                }
            }
            sb.append(inputName);
        } else {
            L.error("", (Throwable)new IllegalStateException("null inputName provided for resultElementType " + type));
        }
    }

    public static void collectProperties4UsageResultTree(final ResultElement resultElement) {
        if (resultElement.getType().equals((Object)ResultElementType.IMSDB_NOT_AVAILABLE)) {
            IMSDBNode dbNode = new IMSDBNode(resultElement.getName(), resultElement.getType().getDisplayName());
            resultElement.addProperty("Node_Mainframe", dbNode);
            return;
        }
        if (resultElement.getType().equals((Object)ResultElementType.IMSDB_SEARCH_FIELD) && resultElement.getName().equalsIgnoreCase(NOT_AVAILABLE_LBL)) {
            return;
        }
        String q = null;
        ProjectInfo pi = (ProjectInfo)resultElement.getProperty("ProjectInfo");
        if (pi == null) {
            ArrayList piList = (ArrayList)resultElement.getProperty("ProjectInfo List");
            for (ProjectInfo prjInfo : piList) {
                if (piList.size() != 1) continue;
                pi = prjInfo;
                break;
            }
        }
        String prjName = pi != null ? pi.getName() : null;
        switch (resultElement.getType()) {
            case IMSDB_FULL_FUNCTION: 
            case IMSDB_FAST_PATH: 
            case IMSDB_FILE_ACCESS: 
            case IMSDB_LOGICAL: {
                Integer dbID = (Integer)resultElement.getProperty(DatabaseMetadata.IMS_DB_ID.getName());
                q = IMSDB_DETAILS_QUERY.concat(String.valueOf(dbID));
                break;
            }
            case IMSDB_SEGMENT: 
            case IMSDB_LOGICAL_SEGMENT: {
                Integer segID = (Integer)resultElement.getProperty(DatabaseMetadata.IMSDB_SEGMENT_ID.getName());
                q = IMS_SEGMENT_DETAILS_QUERY.concat(String.valueOf(segID));
                break;
            }
            case IMSDB_FIELD: 
            case IMSDB_SEARCH_FIELD: {
                Integer fieldID = (Integer)resultElement.getProperty(DatabaseMetadata.IMSDB_FIELD_ID.getName());
                q = IMS_FIELD_DETAILS_QUERY.concat(String.valueOf(fieldID));
            }
        }
        final String sql = q;
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(prjName, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                    try {
                        String[][] results = conn.executeSQL(sql);
                        Utils.createNodeForProperties(results[0], resultElement);
                    }
                    catch (Throwable t) {
                        L.error("could not get element types", t);
                    }
                }
            }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            L.error("", (Throwable)e);
        }
        catch (Exception e) {
            L.error("error at executing of report", (Throwable)e);
        }
    }

    private static void createNodeForProperties(String[] results, ResultElement resultElement) {
        switch (resultElement.getType()) {
            case IMSDB_FULL_FUNCTION: 
            case IMSDB_FAST_PATH: 
            case IMSDB_FILE_ACCESS: 
            case IMSDB_LOGICAL: {
                IMSDBNode dbNode = new IMSDBNode(resultElement.getName(), resultElement.getType().getDisplayName());
                dbNode.setVersion(results[0]);
                dbNode.setRmName(results[1]);
                dbNode.setPSName(results[2]);
                dbNode.setPass(results[3]);
                dbNode.setFPIndex(results[4]);
                dbNode.setRemarks(results[5]);
                resultElement.addProperty("Node_Mainframe", dbNode);
                break;
            }
            case IMSDB_SEGMENT: 
            case IMSDB_LOGICAL_SEGMENT: {
                Integer sourceSegID = (Integer)resultElement.getProperty(DatabaseMetadata.IMSDB_SEG_SOURCE_ID.getName());
                ResultElementType segType = sourceSegID != null && sourceSegID > 0 ? ResultElementType.IMSDB_LOGICAL_SEGMENT : ResultElementType.IMSDB_SEGMENT;
                IMSSegmentPropertiesNode segNode = new IMSSegmentPropertiesNode(resultElement.getName(), segType.getDisplayName());
                segNode.setType(results[0]);
                segNode.setExternalName(results[1]);
                segNode.setBytes(results[2]);
                segNode.setFreq(results[3]);
                segNode.setEncoding(results[4]);
                segNode.setRemarks(results[5]);
                resultElement.addProperty("Node_Mainframe", segNode);
                break;
            }
            case IMSDB_FIELD: 
            case IMSDB_SEARCH_FIELD: {
                IMSFieldPropertiesNode fieldNode = new IMSFieldPropertiesNode(resultElement.getName());
                fieldNode.setExternalName(results[0]);
                fieldNode.setType(results[1]);
                fieldNode.setDataType(results[2]);
                fieldNode.setBytes(results[3]);
                String startVal = results[4] != null ? results[4] : results[5];
                fieldNode.setStart(startVal);
                fieldNode.setMaxOccurs(results[6]);
                fieldNode.setMaxBytes(results[7]);
                fieldNode.setCaseName(results[7]);
                fieldNode.setRemarks(results[8]);
                resultElement.addProperty("Node_Mainframe", fieldNode);
            }
        }
    }

    public static String getKeyForVariable(String prjName, Object varID) {
        return prjName.concat(KEY_SEPARATOR).concat(varID.toString());
    }

    static class MyCallback
    implements ProcessRowCallbackInterface {
        String previousRow = null;
        BufferedWriter buffWriter = null;
        List<ColumnInfo> columns;
        boolean deleteTempFile = false;
        File tempFile;
        private MapFilter<ColumnInfo, Object> csvFilter;
        private Map<ColumnInfo, CsvExportDescriptor.CsvHandler> csvHandlerMap;

        MyCallback(BufferedWriter writer, List<ColumnInfo> columns, MapFilter<ColumnInfo, Object> csvFilter, Map<ColumnInfo, CsvExportDescriptor.CsvHandler> csvHandlerMap, File file) {
            this.buffWriter = writer;
            this.columns = columns;
            this.csvFilter = csvFilter;
            this.csvHandlerMap = csvHandlerMap;
            this.tempFile = file;
        }

        @Override
        public boolean processRow(Row row, int rowIndex, IProgressMonitor monitor) {
            String currentRow;
            if (monitor.isCanceled()) {
                return false;
            }
            StringBuilder rowStringBuilder = new StringBuilder();
            boolean allValuesAreNull = true;
            HashMap<ColumnInfo, Object> values = new HashMap<ColumnInfo, Object>();
            for (ColumnInfo cInfo : this.columns) {
                Object value = null;
                if (cInfo.equals(DatabaseMetadata.PROJECT_NAME)) {
                    value = row.getProjectInfo().getName();
                } else if (row.hasColumn(cInfo.getName().toString())) {
                    value = row.getColumnValue(cInfo.getName().toString());
                }
                values.put(cInfo, value);
            }
            boolean ignoreRow = false;
            if (this.csvFilter != null) {
                ignoreRow = this.csvFilter.filter(values);
            }
            if (!ignoreRow) {
                for (ColumnInfo cInfo : this.columns) {
                    CsvExportDescriptor.CsvHandler csvHandler;
                    if (cInfo == null) continue;
                    Object value = null;
                    if (cInfo.equals(DatabaseMetadata.PROJECT_NAME)) {
                        value = row.getProjectInfo().getName();
                    } else if (row.hasColumn(cInfo.getName().toString())) {
                        value = row.getColumnValue(cInfo.getName().toString());
                    }
                    if (this.csvHandlerMap != null && (csvHandler = this.csvHandlerMap.get(cInfo)) != null) {
                        value = csvHandler.handle(value, row);
                    }
                    if ((value = this.refineValue(cInfo, value)) != null) {
                        rowStringBuilder.append(value);
                        allValuesAreNull = false;
                    } else {
                        rowStringBuilder.append("");
                    }
                    rowStringBuilder.append(Utils.csvSeparator);
                }
            }
            if (allValuesAreNull) {
                rowStringBuilder = null;
            }
            if (rowStringBuilder != null && !(currentRow = rowStringBuilder.toString()).equals(this.previousRow)) {
                try {
                    this.buffWriter.write(currentRow);
                    this.buffWriter.write("\n");
                    this.previousRow = currentRow;
                }
                catch (IOException e) {
                    L.error("Failed to write to CSV export file." + this.tempFile.getAbsolutePath(), (Throwable)e);
                    LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(Utils.class, "export.csv.write.error.msg"), (Plugin)Activator.getDefault(), (boolean)false);
                    this.deleteTempFile = true;
                    return false;
                }
            }
            monitor.worked(1);
            return true;
        }

        private Object refineValue(ColumnInfo cInfo, Object value) {
            if (value == null) {
                return value;
            }
            if (cInfo.equals(DatabaseMetadata.PRG_TYPE_ID) || cInfo.equals(DatabaseMetadata.CHILD_PRG_TYPE_ID)) {
                value = com.ez.mainframe.data.utils.Utils.getPrgType((String)value.toString());
            } else if (cInfo.equals(DatabaseMetadata.STMT_bREAD)) {
                value = Utils.readOrWriteStmt(Integer.valueOf(value.toString()));
            }
            return value;
        }

        boolean shouldDeleteTempfile() {
            return this.deleteTempFile;
        }
    }
}

